/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.persistence;

import java.util.Date;
import oracle.dss.util.Utility;
import oracle.dss.util.persistence.AggregateInfo;
import oracle.dss.util.persistence.Anonymizer;
import oracle.dss.util.persistence.Persistable;
import oracle.dss.util.persistence.PersistableAttributes;
import oracle.dss.util.persistence.SerializableIdentityHashSet;
import oracle.dss.util.persistence.XMLContext;

public class PersistableUtilities
extends Utility {
    public static String buildXMLNS(String tag) {
        return "dvt-cube:" + tag;
    }

    public static void clearUOIDs(Persistable p) {
        if (p == null) {
            return;
        }
        PersistableUtilities.recursiveClearUOIDs(p, new SerializableIdentityHashSet());
    }

    public static Object getContextValue(XMLContext context, String key) {
        if (context != null && context.getScope() != null) {
            return context.getScope().getObject(key);
        }
        return null;
    }

    private static void recursiveClearUOIDs(Persistable p, SerializableIdentityHashSet recursionControl) {
        if (!recursionControl.contains(p)) {
            AggregateInfo[] _aggs;
            recursionControl.add(p);
            PersistableAttributes _attrs = p.getPersistableAttributes(null);
            if (_attrs != null) {
                _attrs.setUOID(null);
                _attrs.setNewUOID(null);
            }
            if ((_aggs = p.getPersistableComponents()) != null) {
                for (int i = 0; i < _aggs.length; ++i) {
                    AggregateInfo _agg = _aggs[i];
                    if (!_agg.byValue()) continue;
                    PersistableUtilities.recursiveClearUOIDs(_agg.getPersistable(), recursionControl);
                }
            }
        }
    }

    public static void makeAnonymousObject(Persistable persistable) {
        if (persistable == null) {
            return;
        }
        String _type = persistable.getPersistableAttributes(null).getObjectType();
        if (persistable instanceof Anonymizer) {
            ((Anonymizer)((Object)persistable)).makeAnonymous();
            return;
        }
        if ("Calculation".equals(_type) || "DimensionCalc".equals(_type) || "Selection".equals(_type)) {
            return;
        }
        persistable.setPersistableAttributes(null);
        AggregateInfo[] _aggrs = persistable.getPersistableComponents();
        if (_aggrs == null) {
            return;
        }
        for (int i = 0; i < _aggrs.length; ++i) {
            Persistable _persistable = _aggrs[i].getPersistable();
            PersistableUtilities.makeAnonymousObject(_persistable);
        }
    }

    public static int getExtensibleAttributeObjectType(Object obj) {
        if (obj instanceof String) {
            return 9;
        }
        if (obj instanceof Boolean) {
            return 8;
        }
        if (obj instanceof Byte) {
            return 1;
        }
        if (obj instanceof Character) {
            return 2;
        }
        if (obj instanceof Date) {
            return 10;
        }
        if (obj instanceof Double) {
            return 3;
        }
        if (obj instanceof Float) {
            return 4;
        }
        if (obj instanceof Integer) {
            return 5;
        }
        if (obj instanceof Long) {
            return 6;
        }
        if (obj instanceof Short) {
            return 7;
        }
        return -1;
    }
}

