/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui.context;

import java.util.Enumeration;
import java.util.Hashtable;

public class PropertyHashtable
extends Hashtable {
    private static final long serialVersionUID = 1L;
    public static final boolean INCLUDE_MAIN_METHOD = true;

    public static void main(String[] strArguments) {
        int nIndex;
        PropertyHashtable propertyHashtable = new PropertyHashtable();
        propertyHashtable.setProperty("Property1", new String("My first property"));
        propertyHashtable.setProperty("Property2", new Integer("2"));
        propertyHashtable.setProperty("Property3", new Boolean(true));
        System.out.println("Keys and Values");
        System.out.println("---------------");
        Object[] objPropertyKeys = propertyHashtable.getPropertyKeys();
        Object[] objPropertyValues = propertyHashtable.getPropertyValues();
        if (objPropertyKeys != null) {
            for (nIndex = 0; nIndex < objPropertyKeys.length; ++nIndex) {
                System.out.println(objPropertyKeys[nIndex].toString() + " " + objPropertyValues[nIndex].toString());
            }
        }
        propertyHashtable.remove("Property1");
        System.out.println();
        System.out.println("Keys and Values (remove Property1)");
        System.out.println("----------------------------------");
        objPropertyKeys = propertyHashtable.getPropertyKeys();
        objPropertyValues = propertyHashtable.getPropertyValues();
        if (objPropertyKeys != null) {
            for (nIndex = 0; nIndex < objPropertyKeys.length; ++nIndex) {
                System.out.println(objPropertyKeys[nIndex].toString() + " " + objPropertyValues[nIndex].toString());
            }
        }
        propertyHashtable.removeAll();
        System.out.println();
        System.out.println("Keys and Values (remove all Properties)");
        System.out.println("---------------------------------------");
        objPropertyKeys = propertyHashtable.getPropertyKeys();
        objPropertyValues = propertyHashtable.getPropertyValues();
        if (objPropertyKeys != null) {
            for (nIndex = 0; nIndex < objPropertyKeys.length; ++nIndex) {
                System.out.println(objPropertyKeys[nIndex].toString() + " " + objPropertyValues[nIndex].toString());
            }
        }
    }

    public void setProperty(Object objKey, Object objValue) {
        if (objKey != null && objValue != null) {
            this.put(objKey, objValue);
        }
    }

    public Object getProperty(Object objKey) {
        return this.get(objKey);
    }

    public Object[] getPropertyKeys() {
        if (this.size() == 0) {
            return null;
        }
        Object[] objects = new Object[this.size()];
        Enumeration enumKeys = this.keys();
        int nIndex = 0;
        while (enumKeys.hasMoreElements()) {
            objects[nIndex++] = enumKeys.nextElement();
        }
        return objects;
    }

    public Object[] getPropertyValues() {
        if (this.size() == 0) {
            return null;
        }
        Object[] objects = new Object[this.size()];
        Enumeration enumValues = this.elements();
        int nIndex = 0;
        while (enumValues.hasMoreElements()) {
            objects[nIndex++] = enumValues.nextElement();
        }
        return objects;
    }

    public void removeAll() {
        Enumeration enumKeys = this.keys();
        if (enumKeys != null) {
            while (enumKeys.hasMoreElements()) {
                this.remove(enumKeys.nextElement());
            }
        }
    }
}

