/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.awt.Component;
import java.util.HashMap;
import java.util.Locale;

public final class LocaleUtils {
    public static final Locale ARABIC = new Locale("ar", "", "");
    public static final Locale CHINESE = Locale.CHINESE;
    public static final Locale CZECH = new Locale("cs", "", "");
    public static final Locale DANISH = new Locale("da", "", "");
    public static final Locale DUTCH = new Locale("nl", "", "");
    public static final Locale ENGLISH = Locale.ENGLISH;
    public static final Locale FINNISH = new Locale("fi", "", "");
    public static final Locale FRENCH = Locale.FRENCH;
    public static final Locale GERMAN = Locale.GERMAN;
    public static final Locale HUNGARIAN = new Locale("hu", "", "");
    public static final Locale ITALIAN = Locale.ITALIAN;
    public static final Locale JAPANESE = Locale.JAPANESE;
    public static final Locale KOREAN = Locale.KOREAN;
    public static final Locale NORWEGIAN = new Locale("no", "", "");
    public static final Locale POLISH = new Locale("pl", "", "");
    public static final Locale PORTUGUESE = new Locale("pt", "", "");
    public static final Locale RUSSIAN = new Locale("ru", "", "");
    public static final Locale SLOVAK = new Locale("sk", "", "");
    public static final Locale SPANISH = new Locale("es", "", "");
    public static final Locale SWEDISH = new Locale("sv", "", "");
    public static final Locale SIMPLIFIED_CHINESE = Locale.SIMPLIFIED_CHINESE;
    public static final Locale TRADITIONAL_CHINESE = Locale.TRADITIONAL_CHINESE;
    public static final Locale BRAZIL = new Locale("pt", "BR", "");
    public static final Locale CANADA = Locale.CANADA;
    public static final Locale CANADA_FRENCH = Locale.CANADA_FRENCH;
    public static final Locale CHINA = Locale.CHINA;
    public static final Locale FRANCE = Locale.FRANCE;
    public static final Locale GERMANY = Locale.GERMANY;
    public static final Locale ITALY = Locale.ITALY;
    public static final Locale JAPAN = Locale.JAPAN;
    public static final Locale KOREA = Locale.KOREA;
    public static final Locale PRC = Locale.PRC;
    public static final Locale TAIWAN = Locale.TAIWAN;
    public static final Locale UK = Locale.UK;
    public static final Locale US = Locale.US;
    public static final int DIRECTION_DEFAULT = 0;
    public static final int DIRECTION_LEFTTORIGHT = 1;
    public static final int DIRECTION_RIGHTTOLEFT = 2;
    public static final int ALIGNMENT_DEFAULT = 0;
    public static final int ALIGNMENT_LEFT = 1;
    public static final int ALIGNMENT_RIGHT = 2;
    public static final int ALIGNMENT_CENTER = 3;
    private static final String[] _LANG_TO_TERRITORY = new String[]{"aa", "DJ", "ab", "GE", "af", "ZA", "am", "ET", "ar", "EG", "as", "IN", "ay", "BO", "az", "AZ", "ba", "RU", "be", "BY", "bg", "BG", "bh", "IN", "bi", "VU", "bn", "BD", "bo", "CN", "br", "FR", "ca", "ES", "co", "FR", "cs", "CZ", "cy", "GB", "da", "DK", "de", "DE", "dz", "BT", "el", "GR", "en", "US", "eo", "FR", "es", "ES", "et", "EE", "eu", "ES", "fa", "IR", "fi", "FI", "fj", "FJ", "fo", "GB", "fr", "FR", "fy", "NL", "ga", "IE", "gd", "GB", "gl", "ES", "gn", "PY", "gu", "IN", "ha", "NG", "he", "IL", "hi", "IN", "hr", "HR", "hu", "HU", "hy", "AM", "ia", "FR", "id", "ID", "ie", "FR", "ik", "US", "in", "ID", "is", "IS", "it", "IT", "iu", "GL", "iw", "IL", "ja", "JP", "ji", "IL", "jw", "ID", "ka", "GE", "kk", "KZ", "kl", "GL", "km", "KH", "kn", "IN", "ko", "KR", "ks", "IN", "ku", "TR", "ky", "KG", "la", "VA", "ln", "ZR", "lo", "LA", "lt", "LT", "lv", "LV", "mg", "MG", "mi", "NZ", "mk", "MK", "ml", "IN", "mn", "MN", "mo", "MD", "mr", "IN", "ms", "MY", "mt", "MT", "my", "MM", "na", "NR", "ne", "NP", "nl", "NL", "no", "NO", "oc", "FR", "om", "ET", "or", "IN", "pa", "IN", "pl", "PL", "ps", "AF", "pt", "PT", "qu", "PE", "rm", "CH", "rn", "BI", "ro", "RO", "ru", "RU", "rw", "RW", "sa", "IN", "sd", "PK", "sg", "CF", "sh", "YU", "si", "LK", "sk", "SK", "sl", "SI", "sm", "WS", "sn", "ZW", "so", "So", "sq", "AL", "sr", "YU", "ss", "SZ", "st", "LS", "su", "SD", "sv", "SE", "sw", "TZ", "ta", "IN", "te", "IN", "tg", "TJ", "th", "TH", "ti", "ER", "tk", "TM", "tl", "PH", "tn", "BW", "to", "TO", "tr", "TK", "ts", "ZA", "tt", "RU", "tw", "BF", "ug", "CN", "uk", "UA", "ur", "PK", "uz", "UZ", "vi", "VN", "vo", "DE", "wo", "SN", "xh", "ZA", "yi", "IL", "yo", "NG", "za", "CN", "zh", "CN", "zu", "ZA"};
    private static HashMap _sLangToTerritoryMap;

    private LocaleUtils() {
    }

    public static Locale getDefaultableLocale(Component component) {
        Locale locale = null;
        try {
            locale = component.getLocale();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static int getReadingDirectionForLocale(Locale locale) {
        String language = locale.getLanguage();
        if ("ar".equals(language) || "he".equals(language) || "iw".equals(language)) {
            return 2;
        }
        return 1;
    }

    public static int getAlignmentForReadingDirection(int readingDirection) {
        return readingDirection;
    }

    public static Locale getLocaleForIANAString(String s) {
        String s1;
        if (s == null || "".equals(s)) {
            return null;
        }
        String s2 = "";
        String s3 = "";
        int i = s.indexOf(45);
        if (i < 0) {
            s1 = s;
        } else {
            s1 = s.substring(0, i);
            int j = i + 1;
            if ((i = s.indexOf(45, j)) < 0) {
                s2 = s.substring(j);
            } else {
                s2 = s.substring(j, i);
                s3 = s.substring(i + 1);
            }
        }
        return new Locale(s1, s2, s3);
    }

    public static Locale getLocaleWithCountry(Locale locale) {
        if (locale == null) {
            return null;
        }
        if ("".equals(locale.getCountry())) {
            String s = locale.getLanguage();
            String s1 = LocaleUtils._languageToTerritory(s);
            String s2 = locale.getVariant();
            return new Locale(s, s1, s2);
        }
        return locale;
    }

    private static String _languageToTerritory(String s) {
        String s1;
        if (_sLangToTerritoryMap == null) {
            int i = _LANG_TO_TERRITORY.length;
            HashMap<String, String> optimistichashmap = new HashMap<String, String>((int)((double)i * 0.7));
            for (int j = 0; j < i; ++j) {
                String s2 = _LANG_TO_TERRITORY[j];
                String s3 = _LANG_TO_TERRITORY[++j];
                optimistichashmap.put(s2, s3);
            }
            _sLangToTerritoryMap = optimistichashmap;
        }
        if ((s1 = (String)_sLangToTerritoryMap.get(s)) != null) {
            return s1;
        }
        _sLangToTerritoryMap.put(s, "");
        return "";
    }
}

