/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.model.dvt.util.transform;

import java.util.ArrayList;
import oracle.adf.model.dvt.util.transform.TransformException;
import oracle.adfinternal.model.dvt.util.transform.BaseNode;
import oracle.adfinternal.model.dvt.util.transform.Cache;
import oracle.adfinternal.model.dvt.util.transform.CubeImpl;
import oracle.adfinternal.model.dvt.util.transform.EdgeTreeImpl;
import oracle.adfinternal.model.dvt.util.transform.InsertInfo;
import oracle.adfinternal.model.dvt.util.transform.Page;
import oracle.adfinternal.model.dvt.util.transform.PageInfo;
import oracle.adfinternal.model.dvt.util.transform.QDRLite;
import oracle.adfinternal.model.dvt.util.transform.ResultTable;
import oracle.adfinternal.model.dvt.util.transform.ResultTableInsert;
import oracle.adfinternal.model.dvt.util.transform.RowBasedEdgeTree;
import oracle.adfinternal.model.dvt.util.transform.TransformUtils;
import oracle.dss.util.LayerSortInfo;

class RowBasedCube
extends CubeImpl {
    private ArrayList<QDRLite> m_realQDRs = new ArrayList();
    private ResultTable m_rt = null;
    private BaseNode[][] m_nodes = null;
    private String[] m_measList = null;

    public RowBasedCube() {
    }

    public RowBasedCube(PageInfo pageInfo) {
        super(pageInfo);
    }

    public RowBasedCube(ResultTable rt, Cache cache, boolean[] alwaysAdd, boolean keepNulls, PageInfo pageInfo, LayerSortInfo[] sortInfo) throws TransformException {
        super(pageInfo);
        this.setup(rt, cache, alwaysAdd, keepNulls, pageInfo.getStartPage(), sortInfo);
    }

    public RowBasedCube(ResultTable rt, Cache cache, boolean[] alwaysAdd, boolean keepNulls) throws TransformException {
        this(rt, cache, alwaysAdd, keepNulls, new PageInfo(), null);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RowBasedCube newCube = (RowBasedCube)super.clone();
        newCube.m_realQDRs = (ArrayList)this.m_realQDRs.clone();
        newCube.m_nodes = (BaseNode[][])this.m_nodes.clone();
        newCube.m_measList = (String[])this.m_measList.clone();
        return newCube;
    }

    @Override
    public Object clone(boolean caching) throws CloneNotSupportedException {
        RowBasedCube newCube = (RowBasedCube)super.clone(caching);
        newCube.m_nodes = (BaseNode[][])this.m_nodes.clone();
        newCube.m_measList = (String[])this.m_measList.clone();
        return newCube;
    }

    @Override
    public ArrayList<QDRLite> getRealQDRs() {
        return this.m_realQDRs;
    }

    private void setup(ResultTable rt, Cache cache, boolean[] alwaysAdd, boolean keepNulls, Page page, LayerSortInfo[] sortInfo) throws TransformException {
        if (rt == null) {
            return;
        }
        this.m_rt = rt;
        String[][] layout = rt.getProjection().getLayout();
        int edgeCount = layout.length;
        if (rt.getDataTable() == null) {
            return;
        }
        this.setHasEdge(new boolean[edgeCount]);
        this.m_nodes = new BaseNode[edgeCount][];
        this.m_measList = TransformUtils.getMeasList(this.m_rt.getProjection());
        for (int e = 0; e < edgeCount; ++e) {
            if (layout[e] == null) continue;
            this.getHasEdge()[e] = true;
            this.m_nodes[e] = new BaseNode[layout[e].length];
            for (int layer = 0; layer < this.m_nodes[e].length; ++layer) {
                this.m_nodes[e][layer] = new BaseNode(layout[e][layer]);
            }
            if (e <= 1) continue;
            this.setEdgeTree(e, page);
        }
        this.walkData(rt, cache, page, alwaysAdd, keepNulls, true, sortInfo);
    }

    @Override
    protected EdgeTreeImpl setEdgeTree(int edge, Page page) throws TransformException {
        RowBasedEdgeTree et = new RowBasedEdgeTree(this.m_nodes[edge], this.m_rt.getProjection().getDataLayer(), this.m_measList, this.m_rt.getProjection(), edge);
        super.setEdgeTree(edge, et, page);
        return et;
    }

    protected void addIn(ResultTableInsert[] rti, Cache cache, boolean[] alwaysAdd, boolean keepNulls, Page page) throws TransformException {
        if (rti == null) {
            return;
        }
        for (int i = 0; i < rti.length; ++i) {
            this.unlockTrees(rti[i].getEdgeInserts(false), page);
            this.walkData(rti[i], cache, page, alwaysAdd, keepNulls, true, null);
        }
        this.lockTrees();
    }

    protected void unlockTrees(InsertInfo[] edgeInserts, Page page) throws TransformException {
        if (this.getEdgeTree(0, page) != null && this.getEdgeTree(0, page).unlock(this.getColumn(edgeInserts, 0))) {
            return;
        }
        if (this.getEdgeTree(1, page) != null && this.getEdgeTree(1, page).unlock(this.getColumn(edgeInserts, 1))) {
            return;
        }
    }

    @Override
    public int getEdgeCount() {
        return this.m_nodes.length;
    }
}

