/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.model.dvt.util.transform;

import oracle.adf.model.dvt.util.transform.BaseRowIterator;
import oracle.adf.model.dvt.util.transform.RowProjection;
import oracle.adf.model.dvt.util.transform.TransformException;
import oracle.adf.model.dvt.util.transform.total.AggType;
import oracle.adfinternal.model.dvt.util.transform.DataTable;
import oracle.adfinternal.model.dvt.util.transform.Filter;
import oracle.adfinternal.model.dvt.util.transform.calcColumns.CalculatedColumnSpec;
import oracle.adfinternal.model.dvt.util.transform.total.AggSpec;

public class ResultTable {
    protected RowProjection m_projection = null;
    protected DataTable m_dt = null;

    public ResultTable(BaseRowIterator iter, CalculatedColumnSpec[] colSpecs) throws TransformException {
        this();
        this.m_dt = new DataTable(iter, colSpecs, null);
    }

    public ResultTable(BaseRowIterator iter, CalculatedColumnSpec[] colSpecs, AggSpec[][] aggs) throws TransformException {
        this();
        this.m_dt = new DataTable(iter, colSpecs, aggs);
    }

    public ResultTable(RowProjection projection, CalculatedColumnSpec[] colSpecs, AggSpec[][] aggs) throws TransformException {
        this();
        this.m_projection = projection;
        this.m_dt = new DataTable(projection, projection.getRowIterator(), colSpecs, aggs, null, false);
    }

    public ResultTable(RowProjection projection) throws TransformException {
        this();
        this.m_projection = projection;
        this.m_dt = new DataTable(projection);
    }

    public ResultTable(RowProjection projection, AggSpec[] aggs) throws TransformException {
        this();
        this.m_projection = projection;
        this.m_dt = new DataTable(projection, new AggSpec[][]{aggs});
    }

    public ResultTable(RowProjection projection, AggSpec[][] aggs) throws TransformException {
        this();
        this.m_projection = projection;
        this.m_dt = new DataTable(projection, aggs);
    }

    public ResultTable(RowProjection projection, AggSpec[][] aggs, boolean includeDataLayerInMembers) throws TransformException {
        this(projection, aggs, null, includeDataLayerInMembers);
    }

    public ResultTable(RowProjection projection, AggSpec[][] aggs, Filter[] filters, boolean includeDataLayerInMembers) throws TransformException {
        this();
        this.m_projection = projection;
        this.m_dt = new DataTable(projection, aggs, filters, includeDataLayerInMembers);
    }

    protected ResultTable() {
    }

    protected AggSpec[][] getAggSpec() {
        return this.m_dt.getAggSpec();
    }

    public void close() throws TransformException {
        if (this.m_dt != null && this.m_dt.getIterator() != null) {
            this.m_dt.getIterator().close();
        }
        this.m_projection = null;
        this.m_dt = null;
    }

    public Object clone() throws CloneNotSupportedException {
        ResultTable rt = new ResultTable();
        rt.m_projection = this.m_projection;
        rt.m_dt = this.m_dt;
        return rt;
    }

    public DataTable getDataTable() {
        return this.m_dt;
    }

    public boolean isLocalStorage() {
        return this.getDataTable().isMixedFrequencyProjection();
    }

    protected boolean hasAggTypeForColumn(String column, AggType type) {
        AggSpec[][] aggSpecs = this.m_dt.getAggSpec();
        if (aggSpecs != null) {
            for (int i = 0; i < aggSpecs.length; ++i) {
                for (int j = 0; j < aggSpecs[i].length; ++j) {
                    if (!aggSpecs[i][j].hasAggTypeForColumn(column, type)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public RowProjection getProjection() {
        return this.m_projection;
    }
}

