/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.model.dvt.util.transform;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.text.Collator;
import java.util.Comparator;
import java.util.Date;
import oracle.adf.model.dvt.util.transform.TransformException;
import oracle.adfinternal.model.dvt.util.transform.ComparatorInterface;
import oracle.adfinternal.model.dvt.util.transform.TransformRuntimeException;
import oracle.sql.CHAR;
import oracle.sql.DATE;
import oracle.sql.NUMBER;
import oracle.sql.TIMESTAMP;

public class CommonComparator
implements Comparator<Object> {
    private final int m_sortDir;
    private final boolean m_nullsFirst;
    private final Collator m_collator;

    public CommonComparator(int sortDir, boolean nullsFirst) {
        this.m_sortDir = sortDir;
        this.m_nullsFirst = nullsFirst;
        this.m_collator = Collator.getInstance();
    }

    @Override
    public int compare(Object val1, Object val2) {
        Object n1;
        Object d1;
        if (val1 == null && val2 == null) {
            return 0;
        }
        if (val1 == null) {
            return -1;
        }
        if (val2 == null) {
            return 1;
        }
        Object data1 = null;
        Object data2 = null;
        try {
            data1 = val1 instanceof ComparatorInterface ? ((ComparatorInterface)val1).getValue() : val1;
            data2 = val2 instanceof ComparatorInterface ? ((ComparatorInterface)val2).getValue() : val2;
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        if (data1 == null && data2 == null) {
            return 0;
        }
        if (data1 == null) {
            return this.m_nullsFirst ? -1 : 1;
        }
        if (data2 == null) {
            return this.m_nullsFirst ? 1 : -1;
        }
        if (this.m_sortDir == 1) {
            Object temp = data1;
            data1 = data2;
            data2 = temp;
        }
        if (data1 instanceof BigInteger && data2 instanceof BigInteger) {
            d1 = (BigInteger)data1;
            BigInteger d2 = (BigInteger)data2;
            int compVal = ((BigInteger)d1).compareTo(d2);
            return this._interpretCompVal(compVal);
        }
        if (data1 instanceof BigDecimal && data2 instanceof BigDecimal) {
            d1 = (BigDecimal)data1;
            BigDecimal d2 = (BigDecimal)data2;
            int compVal = ((BigDecimal)d1).compareTo(d2);
            return this._interpretCompVal(compVal);
        }
        if (data1 instanceof Number && data2 instanceof Number) {
            d1 = (Number)data1;
            Number d2 = (Number)data2;
            if (((Number)d1).doubleValue() > d2.doubleValue()) {
                return 1;
            }
            if (((Number)d1).doubleValue() < d2.doubleValue()) {
                return -1;
            }
            return 0;
        }
        if (data1 instanceof String && data2 instanceof String) {
            d1 = (String)data1;
            String d2 = (String)data2;
            int compVal = this.getCollator().compare((String)d1, d2);
            return this._interpretCompVal(compVal);
        }
        if (data1 instanceof Date && data2 instanceof Date) {
            d1 = (Date)data1;
            Date d2 = (Date)data2;
            int compVal = ((Date)d1).compareTo(d2);
            return this._interpretCompVal(compVal);
        }
        if (data1 instanceof NUMBER && data2 instanceof NUMBER) {
            n1 = (NUMBER)data1;
            NUMBER n2 = (NUMBER)data2;
            int compVal = n1.compareTo(n2);
            return this._interpretCompVal(compVal);
        }
        if (data1 instanceof DATE && data2 instanceof DATE) {
            n1 = (DATE)data1;
            DATE n2 = (DATE)data2;
            int compVal = n1.compareTo(n2);
            return this._interpretCompVal(compVal);
        }
        if (data1 instanceof TIMESTAMP && data2 instanceof TIMESTAMP) {
            try {
                n1 = (TIMESTAMP)data1;
                TIMESTAMP n2 = (TIMESTAMP)data2;
                int compVal = n1.timestampValue().compareTo(n2.timestampValue());
                return this._interpretCompVal(compVal);
            }
            catch (SQLException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
        }
        if (data1 instanceof CHAR && data2 instanceof CHAR) {
            try {
                n1 = ((CHAR)data1).getString();
                String n2 = ((CHAR)data2).getString();
                int compVal = ((String)n1).compareTo(n2);
                return this._interpretCompVal(compVal);
            }
            catch (SQLException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
        }
        return 0;
    }

    private Collator getCollator() {
        return this.m_collator;
    }

    private int _interpretCompVal(int compVal) {
        if (compVal > 0) {
            return 1;
        }
        if (compVal < 0) {
            return -1;
        }
        return 0;
    }
}

