/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.scrolling.scrollBox;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.EwtComponent;
import oracle.ewt.LookAndFeel;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.plaf.ScrollPaneUI;
import oracle.ewt.scrolling.MouseWheelScrolling;
import oracle.ewt.scrolling.MouseWheelUtils;
import oracle.ewt.scrolling.Scrollable;
import oracle.ewt.scrolling.ScrollableException;
import oracle.ewt.scrolling.scrollBox.EwtLWScrollbar;
import oracle.ewt.scrolling.scrollBox.ScrollBoxClipLayout;
import oracle.ewt.scrolling.scrollBox.ScrollBoxEventAdapter;
import oracle.ewt.scrolling.scrollBox.ScrollBoxLayout;

public class ScrollBox
extends EwtComponent
implements AdjustmentListener,
MouseWheelScrolling {
    public static final int DISPLAY_AS_NEEDED = 0;
    public static final int DISPLAY_ALWAYS = 1;
    public static final int DISPLAY_NEVER = 2;
    private Component _content;
    private Scrollable _scrollable;
    private Container _clip;
    private EwtLWScrollbar _hScroll = new EwtLWScrollbar(0);
    private EwtLWScrollbar _vScroll = new EwtLWScrollbar(1);
    private int _hDisplayPolicy;
    private int _vDisplayPolicy;
    private int _lastClipWidth;
    private boolean _wheelScrolling;
    private MouseWheelUtils _wheelUtils;

    public ScrollBox() {
        this(null);
    }

    public ScrollBox(Component component) {
        this(component, 1, 1);
    }

    public ScrollBox(Component component, int n, int n2) {
        this.setLayout(new ScrollBoxLayout());
        this._updateDisplayPolicy(n, this._hScroll);
        this._updateDisplayPolicy(n2, this._vScroll);
        ScrollBoxEventAdapter scrollBoxEventAdapter = new ScrollBoxEventAdapter(this);
        this._hScroll.addComponentListener(scrollBoxEventAdapter);
        this._vScroll.addComponentListener(scrollBoxEventAdapter);
        this._hScroll.addAdjustmentListener(this);
        this._vScroll.addAdjustmentListener(this);
        this.setContent(component);
        this.setWheelScrollingEnabled(true);
        this.setFill(NullPainter.getPainter());
    }

    public Object getUIClassID() {
        return "ScrollPaneUI";
    }

    public void addHAdjustmentListener(AdjustmentListener adjustmentListener) {
        this._hScroll.addAdjustmentListener(adjustmentListener);
    }

    public void addVAdjustmentListener(AdjustmentListener adjustmentListener) {
        this._vScroll.addAdjustmentListener(adjustmentListener);
    }

    public Component getContent() {
        return this._content;
    }

    public int getHLineIncrement() {
        return this._hScroll.getUnitIncrement();
    }

    public int getHPageIncrement() {
        return this._hScroll.getBlockIncrement();
    }

    public int getHDisplayPolicy() {
        return this._hDisplayPolicy;
    }

    public int getVDisplayPolicy() {
        return this._vDisplayPolicy;
    }

    public Point getScrollPosition() {
        Point point = null;
        if (this._scrollable != null) {
            point = this._scrollable.getCanvasOrigin();
        } else if (this._content != null) {
            point = this._content.getLocation();
        }
        if (point != null) {
            point.x = -point.x;
            point.y = -point.y;
        }
        return point;
    }

    public Dimension getContentSize() {
        Dimension dimension = null;
        if (this._scrollable != null) {
            dimension = this._scrollable.getCanvasSize();
        } else if (this._content != null) {
            dimension = this._content.getSize();
        }
        return dimension;
    }

    public int getVLineIncrement() {
        return this._vScroll.getUnitIncrement();
    }

    public int getVPageIncrement() {
        return this._vScroll.getBlockIncrement();
    }

    public Dimension getViewPortSize() {
        return this._clip != null ? this._clip.getSize() : (this._content != null ? this._content.getSize() : null);
    }

    public void removeHAdjustmentListener(AdjustmentListener adjustmentListener) {
        this._hScroll.removeAdjustmentListener(adjustmentListener);
    }

    public void removeVAdjustmentListener(AdjustmentListener adjustmentListener) {
        this._vScroll.removeAdjustmentListener(adjustmentListener);
    }

    public void setContent(Component component) {
        if (component == this._content) {
            return;
        }
        if (this._content != null) {
            Container container = this;
            if (this._clip != null) {
                container = this._clip;
                this.remove(this._clip);
                this._clip = null;
            }
            this.remove(this._content);
            this._content = null;
            if (this._scrollable != null) {
                this._hScroll.setScrollee(null);
                this._vScroll.setScrollee(null);
                this._scrollable = null;
            }
        }
        if (component == null) {
            return;
        }
        this._content = component;
        if (component instanceof Scrollable) {
            this.add(component, "Center", 0);
            this._scrollable = (Scrollable)((Object)component);
            if (this._scrollable.isHScrollable()) {
                this._hScroll.setScrollee(this._scrollable);
            }
            if (this._scrollable.isVScrollable()) {
                this._vScroll.setScrollee(this._scrollable);
            }
        } else {
            this._clip = new LWComponent(){

                protected AccessibleContext createAccessibleContext() {
                    return new ViewportAccess(this);
                }
            };
            this.add(this._clip, "Center", 0);
            this._clip.setLayout(new ScrollBoxClipLayout());
            this._clip.add("Content", component);
        }
    }

    public void setHLineIncrement(int n) {
        this._hScroll.setUnitIncrement(n);
    }

    public void setHDisplayPolicy(int n) {
        if (this._hDisplayPolicy != n) {
            this._updateDisplayPolicy(n, this._hScroll);
        }
    }

    public void setHPageIncrement(int n) {
        this._hScroll.setBlockIncrement(n);
    }

    public final void setScrollPosition(Point point) {
        this.setScrollPosition(point.x, point.y);
    }

    public void setScrollPosition(int n, int n2) throws ScrollableException {
        if (this._scrollable != null) {
            this._scrollable.setCanvasOrigin(-n, -n2);
        } else {
            if (!this.isValid() && this._clip != null) {
                this._configureScrollbars();
            }
            if (this._content != null) {
                this._content.setLocation(-n, -n2);
            }
            this._hScroll.setValue(n);
            this._vScroll.setValue(n2);
        }
    }

    public void setVDisplayPolicy(int n) {
        if (this._vDisplayPolicy != n) {
            this._updateDisplayPolicy(n, this._vScroll);
        }
    }

    public void setVLineIncrement(int n) {
        this._vScroll.setUnitIncrement(n);
    }

    public void setVPageIncrement(int n) {
        this._vScroll.setBlockIncrement(n);
    }

    public void setWheelScrollingEnabled(boolean bl) {
        if (bl != this._wheelScrolling) {
            this._wheelScrolling = bl;
            if (this._wheelUtils == null) {
                this._wheelUtils = new MouseWheelUtils();
            }
            if (bl) {
                this._wheelUtils.addMouseWheelListener(this);
            } else {
                this._wheelUtils.removeMouseWheelListener(this);
            }
        }
    }

    public boolean isWheelScrollingEnabled() {
        return MouseWheelUtils.isWheelScrollingEnabled() && this._wheelScrolling;
    }

    public boolean handleWheelScrolling(int n, int n2, int n3) {
        if (!this.isEnabled() || !this.isWheelScrollingEnabled() || n2 == 0) {
            return false;
        }
        EwtLWScrollbar ewtLWScrollbar = null;
        if (this._vScroll.isVisible()) {
            ewtLWScrollbar = this._vScroll;
        } else if (this._hScroll.isVisible()) {
            ewtLWScrollbar = this._hScroll;
        }
        if (ewtLWScrollbar == null) {
            return false;
        }
        int n4 = n == 1 ? ewtLWScrollbar.getBlockIncrement() : n2 * ewtLWScrollbar.getUnitIncrement();
        if (n3 < 0) {
            n4 = -n4;
        }
        ewtLWScrollbar.setScrollValue(ewtLWScrollbar.getValue() + n4);
        return true;
    }

    public Component getMouseWheelScrollingComponent() {
        return this;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this._scrollable != null || this._content == null) {
            return;
        }
        Adjustable adjustable = adjustmentEvent.getAdjustable();
        int n = adjustmentEvent.getValue();
        Point point = this._content.getLocation();
        if (adjustable == this._hScroll) {
            point.x = -n;
        } else if (adjustable == this._vScroll) {
            point.y = -n;
        } else {
            return;
        }
        this._content.setLocation(point.x, point.y);
    }

    public void doLayout() {
        if (ScrollBox.__isAutomaticAsNeeded(this)) {
            boolean bl;
            Dimension dimension = this.getSize();
            Insets insets = this.getInsets();
            dimension.width -= insets.left + insets.right;
            dimension.height -= insets.top + insets.bottom;
            Dimension dimension2 = this._content != null ? this._content.getPreferredSize() : new Dimension(0, 0);
            Dimension dimension3 = this._hScroll.getPreferredSize();
            Dimension dimension4 = this._vScroll.getPreferredSize();
            boolean bl2 = dimension2.width > dimension.width;
            boolean bl3 = bl = dimension2.height > dimension.height;
            if (bl2 != bl) {
                if (bl2) {
                    bl = dimension2.height > dimension.height - dimension3.height;
                } else {
                    bl2 = dimension2.width > dimension.width - dimension4.width;
                }
            }
            this._hScroll.setVisible(bl2);
            this._vScroll.setVisible(bl);
            if (this._clip != null) {
                this._clip.setSize(dimension.width - (bl ? dimension4.width : 0), dimension.height - (bl2 ? dimension3.height : 0));
            }
            if (this._content != null) {
                this._content.setSize(dimension2.width, dimension2.height);
            }
            this._configureScrollbars();
        }
        super.doLayout();
    }

    protected void validateTree() {
        if (ScrollBox.__isAutomaticAsNeeded(this)) {
            super.validateTree();
            return;
        }
        this._doValidateTree();
        if (this._forceVisibilityChanges()) {
            this._doValidateTree();
            if (this._forceVisibilityChanges()) {
                this._doValidateTree();
            }
        }
    }

    private void _doValidateTree() {
        super.validateTree();
        if (this._clip != null) {
            this._configureScrollbars();
        }
    }

    public boolean isChildClipped(Component component) {
        return this.isClippedBySibling();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._hScroll.setEnabled(bl);
        this._vScroll.setEnabled(bl);
    }

    public int getActualReadingDirection() {
        Component component;
        int n = this.getReadingDirection();
        if (n == 0 && (component = this.getContent()) instanceof LWComponent && (n = ((LWComponent)component).getReadingDirection()) != 0) {
            return n;
        }
        return super.getActualReadingDirection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n) {
        Component component = null;
        Object object = this.getTreeLock();
        synchronized (object) {
            component = this.getComponent(n);
        }
        super.remove(n);
        if (component != null && component == this.getContent()) {
            this.setContent(null);
        }
    }

    protected void paintCanvasInterior(Graphics graphics) {
        Component component = this.getContent();
        if (component != null) {
            Dimension dimension = this.getViewPortSize();
            Dimension dimension2 = this.getInnerSize();
            int n = dimension2.width - dimension.width;
            int n2 = dimension2.height - dimension.height;
            if (n > 0 || n2 > 0) {
                graphics.setColor(this.getUIDefaults().getColor(LookAndFeel.NORMAL_INTENSITY));
                int n3 = this.getActualReadingDirection();
                int n4 = 0;
                int n5 = dimension.width;
                if (n3 == 2) {
                    n4 = n;
                    n5 = 0;
                }
                if (n > 0) {
                    graphics.fillRect(n5, 0, n, dimension2.height);
                }
                if (n2 > 0) {
                    graphics.fillRect(n4, dimension.height, dimension2.width, n2);
                }
            }
        }
    }

    protected Object getPaintData(Object object) {
        if (object.equals("ContentBackgroundColor")) {
            Component component = this.getContent();
            if (component != null) {
                return component.getBackground();
            }
            return super.getBackground();
        }
        if (object.equals("HorizontalScrollBarHeight")) {
            int n = this._hScroll.isVisible() ? this._hScroll.getSize().height : 0;
            return IntegerUtils.getInteger((int)n);
        }
        if (object.equals("VerticalScrollBarWidth")) {
            int n = this._vScroll.isVisible() ? this._vScroll.getSize().width : 0;
            return IntegerUtils.getInteger((int)n);
        }
        return super.getPaintData(object);
    }

    protected void addImpl(Component component, Object object, int n) {
        if (component != this._hScroll && component != this._vScroll && component != this._clip && component != this._content) {
            this.setContent(component);
        } else {
            super.addImpl(component, object, n);
        }
    }

    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    private boolean _forceVisibilityChanges() {
        boolean bl = false;
        if (this.getHDisplayPolicy() == 0) {
            bl = this._hScroll._hideOrShowSelf();
        }
        boolean bl2 = false;
        if (this.getVDisplayPolicy() == 0) {
            bl2 = this._vScroll._hideOrShowSelf();
        }
        return bl || bl2;
    }

    private void _configureScrollbars() {
        if (this._scrollable != null || this._content == null) {
            return;
        }
        Dimension dimension = this._content.getSize();
        Dimension dimension2 = this._clip.getSize();
        int n = this._hScroll.getValue();
        int n2 = this._vScroll.getValue();
        int n3 = dimension.width - dimension2.width;
        int n4 = dimension.height - dimension2.height;
        int n5 = this.getActualReadingDirection();
        if (n5 == 2 && this._lastClipWidth != dimension2.width) {
            n = n3;
        }
        if (n3 < 0 && n5 != 2) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n5 == 2) {
            int n6 = this._lastClipWidth;
            if (n6 == 0) {
                n = n3;
            } else if (n6 != dimension2.width && (n -= dimension2.width - n6) < 0) {
                n = 0;
            }
        }
        if (n > n3 || n2 > n4) {
            if (n > n3) {
                n = n3;
            }
            if (n2 > n4) {
                n2 = n4;
            }
        }
        this._content.setLocation(-n, -n2);
        this._lastClipWidth = dimension2.width;
        this._hScroll.setValues(n, dimension2.width, 0, dimension.width);
        this._vScroll.setValues(n2, dimension2.height, 0, dimension.height);
    }

    private void _updateDisplayPolicy(int n, EwtLWScrollbar ewtLWScrollbar) {
        int n2 = ewtLWScrollbar.getOrientation();
        if (n == 2) {
            ewtLWScrollbar.setVisible(false);
            if (ewtLWScrollbar.getParent() != null) {
                this.remove(ewtLWScrollbar);
            }
        } else {
            if (ewtLWScrollbar.getParent() == null) {
                this.add((Component)ewtLWScrollbar, n2 == 0 ? "Hscroll" : "Vscroll");
            }
            if (n == 1) {
                ewtLWScrollbar.setVisible(true);
            }
        }
        boolean bl = n != 0;
        ewtLWScrollbar.setDisplayedAlways(bl);
        if (n2 == 0) {
            this._hDisplayPolicy = n;
        } else {
            this._vDisplayPolicy = n;
        }
    }

    private ScrollPaneUI _getScrollPaneUI() {
        return (ScrollPaneUI)this.getUI();
    }

    static boolean __isAutomaticAsNeeded(ScrollBox scrollBox) {
        return !(scrollBox.getContent() instanceof Scrollable) && 0 == scrollBox.getHDisplayPolicy() && 0 == scrollBox.getVDisplayPolicy() && 1 == scrollBox.getActualReadingDirection();
    }

    private static class ViewportAccess
    extends AccessibleLWComponent {
        public ViewportAccess(LWComponent lWComponent) {
            super(lWComponent);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.VIEWPORT;
        }
    }

    private class Access
    extends AccessibleLWComponent {
        public Access() {
            super(ScrollBox.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SCROLL_PANE;
        }
    }
}

