/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwMenu;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.event.tracking.MouseGrabProvider;
import oracle.ewt.event.tracking.TrackingUtils;
import oracle.ewt.lwAWT.lwMenu.BaseMIContainer;
import oracle.ewt.lwAWT.lwMenu.DragRedispatcher;
import oracle.ewt.lwAWT.lwMenu.LWMenu;
import oracle.ewt.lwAWT.lwMenu.LWMenuInvoker;
import oracle.ewt.lwAWT.lwMenu.LWMenuItem;
import oracle.ewt.lwAWT.lwMenu.LWPopupMenuEvent;
import oracle.ewt.lwAWT.lwMenu.LWPopupMenuListener;
import oracle.ewt.lwAWT.lwMenu.MenuUtils;
import oracle.ewt.lwAWT.lwMenu.PreferredColumnLayout;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.MenuItemUI;
import oracle.ewt.popup.NoPopupOwnerException;
import oracle.ewt.popup.PopupOwner;
import oracle.ewt.popup.PopupUtils;
import oracle.ewt.util.ComponentUtils;
import oracle.ewt.util.ImmInsets;

public class LWPopupMenu
extends BaseMIContainer {
    private static final int _CENTER = 0;
    private static final int _TO_LEFT = 1;
    private static final int _TO_RIGHT = 2;
    private static final int _LEFT = 3;
    private static final int _RIGHT = 4;
    private static final int _ABOVE_TOP = 1;
    private static final int _BELOW_BOTTOM = 2;
    private static final int _TOP = 3;
    private static final int _BOTTOM = 4;
    public static final int HORIZONTAL_CENTER = 0;
    public static final int TO_LEFT = 5;
    public static final int TO_RIGHT = 10;
    public static final int LEFT = 15;
    public static final int RIGHT = 20;
    public static final int VERTICAL_CENTER = 0;
    public static final int ABOVE_TOP = 1;
    public static final int BELOW_BOTTOM = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 4;
    private LWMenuInvoker _invoker;
    private ListenerManager _listeners;
    private MouseGrabProvider _mouseGrabProvider;
    private KeeperUpper _popdownCanceller;
    private boolean _isRoot;
    private boolean _ignoreRepaints;
    private static int[] _sLTRJustifications;
    private static int[] _sRTLJustifications;
    private static boolean _sConsumeGrabEvent;

    public static void setConsumeGrabEvent(boolean bl) {
        _sConsumeGrabEvent = bl;
    }

    public static boolean isConsumeGrabEvent() {
        return _sConsumeGrabEvent;
    }

    public void addPopupMenuListener(LWPopupMenuListener lWPopupMenuListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener(lWPopupMenuListener);
    }

    public int getOrientation() {
        return 0;
    }

    public void handleAccelerator(KeyEvent keyEvent) {
        Container container = this.getContent();
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!(component instanceof LWMenuItem)) continue;
            ((LWMenuItem)component).handleAccelerator(keyEvent);
            if (!keyEvent.isConsumed()) continue;
            return;
        }
    }

    public boolean isPoppedUp() {
        return this._invoker != null;
    }

    public void popdown() {
        if (this.isPoppedUp() && !this._isBeingRemoved()) {
            Object object;
            LWMenuItem lWMenuItem = this.getSelectedItem();
            if (lWMenuItem != null) {
                lWMenuItem.setSelected(false);
            }
            this._popdownMenus();
            this._removeGrab();
            if (this._isRoot) {
                this.removeMenuGrab();
                this._isRoot = false;
            }
            if (this._invoker instanceof CompInvoker) {
                object = this._invoker.getInvokerComponent();
                ((Component)object).removeMouseListener(DragRedispatcher.getInstance());
                ((Component)object).removeMouseMotionListener(DragRedispatcher.getInstance());
            }
            object = this._invoker;
            this._invoker = null;
            if (this.getPeer() != null) {
                PopupUtils.hidePopup(this);
            }
            this.processEvent(new LWPopupMenuEvent(this, 2001, (LWMenuInvoker)object));
        }
    }

    public final void popup(Component component, int n, int n2) {
        this.popup(new CompInvoker(component), new Rectangle(n, n2, 0, 0), this._getDefaultJustifications());
        component.addMouseListener(DragRedispatcher.getInstance());
        component.addMouseMotionListener(DragRedispatcher.getInstance());
    }

    public final void popup(Component component, int[] nArray, Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = component.getBounds();
            rectangle.y = 0;
            rectangle.x = 0;
        }
        this.popup(new CompInvoker(component), rectangle, nArray);
        component.addMouseListener(DragRedispatcher.getInstance());
        component.addMouseMotionListener(DragRedispatcher.getInstance());
    }

    public void popup(LWMenuInvoker lWMenuInvoker, Rectangle rectangle, int[] nArray) {
        this.processEvent(new LWPopupMenuEvent(this, 2002, lWMenuInvoker));
        if (this.isPoppedUp()) {
            this.popdown();
        }
        this._displayPopup(lWMenuInvoker, rectangle, nArray);
        this.processEvent(new LWPopupMenuEvent(this, 2000, lWMenuInvoker));
    }

    public void removePopupMenuListener(LWPopupMenuListener lWPopupMenuListener) {
        if (this._listeners != null) {
            this._listeners.removeListener(lWPopupMenuListener);
        }
    }

    public LWMenuInvoker getMenuInvoker() {
        return this._invoker;
    }

    public void removeNotify() {
        super.removeNotify();
        if (this._invoker != null) {
            Object object;
            this._invoker.dismissMenu();
            this._removeGrab();
            if (this._isRoot) {
                this.removeMenuGrab();
                this._isRoot = false;
            }
            if (this._invoker instanceof CompInvoker) {
                object = this._invoker.getInvokerComponent();
                ((Component)object).removeMouseListener(DragRedispatcher.getInstance());
                ((Component)object).removeMouseMotionListener(DragRedispatcher.getInstance());
            }
            object = this._invoker;
            this._invoker = null;
            this.processEvent(new LWPopupMenuEvent(this, 2001, (LWMenuInvoker)object));
        }
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (this.isVisible() && !this._ignoreRepaints) {
            super.repaint(l, n, n2, n3, n4);
        }
    }

    public Object getUIClassID() {
        return "PopupMenuUI";
    }

    public Dimension minimumSize() {
        Dimension dimension = this.getContent().getMinimumSize();
        return this.convertInnerToOuterSize(dimension.width, dimension.height);
    }

    public void processMenuKeyEvent(KeyEvent keyEvent) {
        LWMenuItem lWMenuItem = this.getSelectedItem();
        if (lWMenuItem != null) {
            lWMenuItem.processMenuKeyEvent(keyEvent);
            if (keyEvent.isConsumed()) {
                return;
            }
        }
        this.processKeyEvent(keyEvent);
        if (!keyEvent.isConsumed()) {
            this.__handleMnemonic(keyEvent);
        }
    }

    protected LayoutManager createContentLayout() {
        return PreferredColumnLayout.getInstance();
    }

    protected void dismissMenu() {
        this.popdown();
    }

    protected void processGrabbedMouseEvent(MouseEvent mouseEvent) {
        Component component;
        int n = mouseEvent.getID();
        if (n == 501) {
            Component component2 = (Component)mouseEvent.getSource();
            if (!MenuUtils.isMenuDescendent(component2, this)) {
                this.popdown();
                if (LWPopupMenu.isConsumeGrabEvent()) {
                    mouseEvent.consume();
                }
            }
        } else if (n == 502 && !MenuUtils.isMenuDescendent(component = ComponentUtils.getTargetComponentOutside((Component)mouseEvent.getSource(), new Point(mouseEvent.getX(), mouseEvent.getY())), this)) {
            this.popdown();
            if (LWPopupMenu.isConsumeGrabEvent()) {
                mouseEvent.consume();
            }
        }
    }

    protected void processPopupMenuEvent(LWPopupMenuEvent lWPopupMenuEvent) {
        Enumeration enumeration;
        if (this._listeners == null || (enumeration = this._listeners.getListeners()) == null) {
            return;
        }
        int n = lWPopupMenuEvent.getID();
        while (enumeration.hasMoreElements()) {
            LWPopupMenuListener lWPopupMenuListener = (LWPopupMenuListener)enumeration.nextElement();
            switch (n) {
                case 2000: {
                    lWPopupMenuListener.menuPoppedUp(lWPopupMenuEvent);
                    break;
                }
                case 2001: {
                    lWPopupMenuListener.menuPoppedDown(lWPopupMenuEvent);
                    break;
                }
                case 2002: {
                    lWPopupMenuListener.menuPoppingUp(lWPopupMenuEvent);
                }
            }
        }
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof LWPopupMenuEvent) {
            this.processPopupMenuEvent((LWPopupMenuEvent)aWTEvent);
        }
    }

    protected void addImpl(Component component, Object object, int n) {
        Container container = this.getContent();
        container.add(component, object, n);
    }

    protected void updateLocale(Locale locale, Locale locale2) {
        super.updateLocale(locale, locale2);
    }

    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    final void __cancelPopdown() {
        LWMenuInvoker lWMenuInvoker = this.getMenuInvoker();
        lWMenuInvoker.cancelDismissal();
    }

    private void _addGrab() {
        if (this._mouseGrabProvider == null) {
            this._mouseGrabProvider = TrackingUtils.getMouseGrabProvider(this);
            if (this._mouseGrabProvider != null) {
                this._popdownCanceller = new KeeperUpper();
                this._mouseGrabProvider.addMouseGrab(this._popdownCanceller);
            }
        }
    }

    private boolean _canMoveHorizontally(int n) {
        int n2 = n % 5;
        return n2 == 1 || n2 == 2;
    }

    private boolean _canMoveVertically(int n) {
        int n2 = n / 5;
        return n2 == 1 || n2 == 2;
    }

    private void _displayPopup(LWMenuInvoker lWMenuInvoker, Rectangle rectangle, int[] nArray) {
        Rectangle rectangle2;
        Component component = lWMenuInvoker.getInvokerComponent();
        PopupOwner popupOwner = PopupUtils.findBottomPopupOwner(component);
        if (popupOwner == null) {
            throw new NoPopupOwnerException();
        }
        popupOwner.addPopup(this);
        this._initConstraints();
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = null;
        Rectangle rectangle3 = new Rectangle(0, 0, 0, 0);
        Component component2 = (Component)((Object)popupOwner);
        Point point = ComponentUtils.translatePoint(component, component2, rectangle.x, rectangle.y);
        for (int i = 0; i < nArray.length; ++i) {
            rectangle2 = this._getBestBounds(popupOwner, new Rectangle(point.x, point.y, rectangle.width, rectangle.height), dimension, nArray[i]);
            if (rectangle2.width == dimension.width && rectangle2.height == dimension.height) {
                rectangle3 = rectangle2;
                break;
            }
            if (dimension2 == null) {
                dimension2 = this.getMinimumSize();
            }
            if (rectangle2.width < dimension2.width || rectangle2.width * rectangle2.height <= rectangle3.width * rectangle3.height) continue;
            rectangle3 = rectangle2;
        }
        if (rectangle3.width != dimension.width && dimension2 == null) {
            dimension2 = this.getMinimumSize();
        }
        if (rectangle3.width == dimension.width || rectangle3.width >= dimension2.width) {
            this._ignoreRepaints = true;
            popupOwner.setPopupBounds(this, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            this.validate();
            popupOwner.showPopup(this, rectangle3.x, rectangle3.y);
            this._ignoreRepaints = false;
            this._paintImmediate();
        } else {
            Insets insets;
            this._ignoreRepaints = true;
            rectangle2 = this._getVisibleBounds(component2);
            if (component2 instanceof Container && (insets = ((Container)component2).getInsets()) != null) {
                rectangle2.width -= insets.left + insets.right;
                rectangle2.height -= insets.top + insets.bottom;
                point.x += insets.left;
                point.y += insets.top;
            }
            if (dimension.width < rectangle2.width) {
                rectangle2.width = dimension.width;
            }
            if (dimension.height + 3 < rectangle2.height) {
                rectangle2.height = dimension.height + 3;
            }
            this._tweakConstraints(rectangle2.width);
            popupOwner.setPopupBounds(this, point.x, point.y, rectangle2.width, rectangle2.height);
            this.validate();
            popupOwner.showPopup(this, point.x, point.y);
            this._ignoreRepaints = false;
            this._paintImmediate();
        }
        this._invoker = lWMenuInvoker;
        this._addGrab();
        if (MenuUtils.getRootMenuItemContainer(this) == this) {
            this._isRoot = true;
            this.addMenuGrab();
        }
    }

    private Rectangle _getBestBounds(PopupOwner popupOwner, Rectangle rectangle, Dimension dimension, int n) {
        Object object;
        Rectangle rectangle2 = this._getVisibleBounds((Component)((Object)popupOwner));
        if (popupOwner instanceof Container && (object = ((Container)((Object)popupOwner)).getInsets()) != null) {
            rectangle2.width -= ((Insets)object).left + ((Insets)object).right;
            rectangle2.height -= ((Insets)object).top + ((Insets)object).bottom;
            rectangle2.x += ((Insets)object).left;
            rectangle2.y += ((Insets)object).top;
        }
        object = this._pinValues(n / 5, rectangle.x, dimension.width, rectangle.width, rectangle2.width, rectangle2.x, this._canMoveHorizontally(n));
        Object object2 = object[0];
        Object object3 = object[1];
        object = this._pinValues(n % 5, rectangle.y, dimension.height, rectangle.height, rectangle2.height, rectangle2.y, this._canMoveVertically(n));
        Object object4 = object[0];
        Object object5 = object[1];
        return new Rectangle((int)object2, (int)object4, (int)object3, (int)object5);
    }

    private int[] _getDefaultJustifications() {
        if (this.getActualReadingDirection() == 1) {
            if (_sLTRJustifications == null) {
                _sLTRJustifications = new int[]{18, 19, 23, 24};
            }
            return _sLTRJustifications;
        }
        if (_sRTLJustifications == null) {
            _sRTLJustifications = new int[]{23, 24, 18, 19};
        }
        return _sRTLJustifications;
    }

    private Rectangle _getVisibleBounds(Component component) {
        Rectangle rectangle = new Rectangle(component.getLocationOnScreen(), component.getSize());
        Rectangle rectangle2 = this._getScreenDimension();
        if (rectangle2 == null) {
            rectangle2 = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        }
        rectangle2 = rectangle2.intersection(rectangle);
        rectangle2.translate(-rectangle.x, -rectangle.y);
        return rectangle2;
    }

    private Rectangle _getScreenDimension() {
        try {
            Class<?> clazz = Class.forName("java.awt.GraphicsEnvironment");
            Object object = clazz.getDeclaredMethod("getLocalGraphicsEnvironment", null).invoke(null, (Object[])null);
            Object object2 = clazz.getMethod("getScreenDevices", null).invoke(object, (Object[])null);
            if (object2 == null) {
                return null;
            }
            int n = Array.getLength(object2);
            Class<?> clazz2 = Class.forName("java.awt.GraphicsDevice");
            Class<?> clazz3 = Class.forName("java.awt.GraphicsConfiguration");
            Rectangle rectangle = new Rectangle();
            for (int i = 0; i < n; ++i) {
                Object object3 = clazz2.getMethod("getDefaultConfiguration", null).invoke(Array.get(object2, i), (Object[])null);
                Rectangle rectangle2 = (Rectangle)clazz3.getMethod("getBounds", null).invoke(object3, (Object[])null);
                rectangle = rectangle.union(rectangle2);
            }
            return rectangle;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _initConstraints() {
        Container container = this.getContent();
        Object object = container.getTreeLock();
        synchronized (object) {
            LWMenuItem lWMenuItem;
            Component component;
            int n;
            int n2 = container.getComponentCount();
            int[] nArray = new int[n2];
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            for (n = 0; n < n2; ++n) {
                component = container.getComponent(n);
                if (!(component instanceof LWMenuItem)) continue;
                lWMenuItem = (LWMenuItem)component;
                MenuItemUI.MenuItemConstraints menuItemConstraints = lWMenuItem.__getMenuItemConstraints();
                n3 = menuItemConstraints.state > n3 ? menuItemConstraints.state : n3;
                n4 = menuItemConstraints.image > n4 ? menuItemConstraints.image : n4;
                n5 = menuItemConstraints.label > n5 ? menuItemConstraints.label : n5;
                n6 = menuItemConstraints.accelerator > n6 ? menuItemConstraints.accelerator : n6;
                n7 = menuItemConstraints.submenu > n7 ? menuItemConstraints.submenu : n7;
                nArray[n] = menuItemConstraints.height;
            }
            for (n = 0; n < n2; ++n) {
                component = container.getComponent(n);
                if (!(component instanceof LWMenuItem)) continue;
                lWMenuItem = (LWMenuItem)component;
                lWMenuItem.putClientProperty("_miConstraints", new MenuItemUI.MenuItemConstraints(n3, n4, n5, n6, n7, nArray[n]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _tweakConstraints(int n) {
        Container container = this.getContent();
        Object object = container.getTreeLock();
        synchronized (object) {
            int n2 = container.getComponentCount();
            for (int i = 0; i < n2; ++i) {
                Component component = container.getComponent(i);
                if (!(component instanceof LWMenuItem)) continue;
                LWMenuItem lWMenuItem = (LWMenuItem)component;
                MenuItemUI.MenuItemConstraints menuItemConstraints = (MenuItemUI.MenuItemConstraints)lWMenuItem.getClientProperty("_miConstraints");
                int n3 = menuItemConstraints.state + menuItemConstraints.image + menuItemConstraints.accelerator + menuItemConstraints.submenu;
                if (n3 + menuItemConstraints.label + 15 <= n) continue;
                int n4 = n - n3 - 15;
                if (n4 < 0) {
                    n4 = 10;
                }
                lWMenuItem.putClientProperty("_miConstraints", new MenuItemUI.MenuItemConstraints(menuItemConstraints.state, menuItemConstraints.image, n4, menuItemConstraints.accelerator, menuItemConstraints.submenu, menuItemConstraints.height));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _isBeingRemoved() {
        if (this.getPeer() == null) {
            return true;
        }
        Container container = this.getParent();
        Object object = this.getTreeLock();
        synchronized (object) {
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Component component = componentArray[i];
                if (component != null && component.getPeer() != null) continue;
                return true;
            }
        }
        return false;
    }

    private void _paintImmediate() {
        Object object;
        if (this.isBorderTransparent()) {
            object = this.getBorderPainter();
            if (object != null) {
                Dimension dimension = this.getSize();
                Graphics graphics = this.getGraphics();
                if (graphics != null) {
                    PaintContext paintContext = this.getPaintContext();
                    Painter painter = this.getFill();
                    ImmInsets immInsets = object.getFillInsets(paintContext);
                    object.paint(this.getBorderContext(), graphics, 0, 0, dimension.width, dimension.height);
                    painter.paint(paintContext, graphics, immInsets.left, immInsets.top, dimension.width - (immInsets.left + immInsets.right), dimension.height - (immInsets.top + immInsets.bottom));
                    graphics.dispose();
                }
            }
            this.paintImmediateInterior();
        } else {
            this.paintImmediate();
        }
        object = Toolkit.getDefaultToolkit();
        ((Toolkit)object).sync();
    }

    private int[] _pinValues(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        n2 -= n6;
        switch (n) {
            case 0: {
                int n7 = n2 + n4 / 2;
                n3 = Math.min(n3, 2 * Math.min(n7, n5 - n7));
                n2 = n7 - n3 / 2;
                break;
            }
            case 1: {
                n2 -= n3;
                break;
            }
            case 2: {
                n2 += n4;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                n2 += n4 - n3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal justification");
            }
        }
        if (n2 < 0) {
            if (!bl) {
                n3 += n2;
            }
            n2 = 0;
        }
        if (n2 + n3 > n5) {
            if (bl) {
                n2 = n3 > n5 ? 0 : n5 - n3;
            }
            n3 = n5 - n2;
        }
        int[] nArray = new int[]{n2 += n6, n3};
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _popdownMenus() {
        Container container = this.getContent();
        Object object = container.getTreeLock();
        synchronized (object) {
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (!(component instanceof LWMenu)) continue;
                ((LWMenu)component).setSubMenuDisplayed(false);
            }
        }
    }

    private void _removeGrab() {
        if (this._mouseGrabProvider != null) {
            this._mouseGrabProvider.removeMouseGrab(this._popdownCanceller);
            this._popdownCanceller = null;
            this._mouseGrabProvider = null;
        }
    }

    static {
        _sConsumeGrabEvent = true;
    }

    private class Access
    extends AccessibleLWComponent {
        public Access() {
            super(LWPopupMenu.this);
        }

        public int getAccessibleChildrenCount() {
            Component[] componentArray = LWPopupMenu.this.getContent().getComponents();
            int n = 0;
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof Accessible)) continue;
                ++n;
            }
            return n;
        }

        public Accessible getAccessibleChild(int n) {
            Component[] componentArray = LWPopupMenu.this.getContent().getComponents();
            int n2 = 0;
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof Accessible)) continue;
                if (n2 == n) {
                    Accessible accessible = (Accessible)((Object)componentArray[i]);
                    accessible.getAccessibleContext().setAccessibleParent(LWPopupMenu.this);
                    return accessible;
                }
                ++n2;
            }
            return null;
        }

        public Accessible getAccessibleParent() {
            Component component;
            if (this.accessibleParent != null) {
                return this.accessibleParent;
            }
            LWMenuInvoker lWMenuInvoker = LWPopupMenu.this._invoker;
            if (lWMenuInvoker instanceof CompInvoker && (component = lWMenuInvoker.getInvokerComponent()) instanceof Accessible) {
                return (Accessible)((Object)component);
            }
            if (lWMenuInvoker instanceof Accessible) {
                return (Accessible)((Object)lWMenuInvoker);
            }
            return super.getAccessibleParent();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.POPUP_MENU;
        }
    }

    private class CompInvoker
    implements LWMenuInvoker {
        private Component _comp;

        public CompInvoker(Component component) {
            this._comp = component;
        }

        public Component getInvokerComponent() {
            return this._comp;
        }

        public void dismissMenu() {
            LWPopupMenu.this.popdown();
        }

        public void cancelDismissal() {
        }
    }

    final class KeeperUpper
    extends MouseAdapter {
        KeeperUpper() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            for (Component component = (Component)mouseEvent.getSource(); component != null; component = component.getParent()) {
                if (component != LWPopupMenu.this) continue;
                LWPopupMenu.this.__cancelPopdown();
            }
        }
    }
}

