/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.peer.LightweightPeer;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import oracle.ewt.ColorScheme;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.UIManager;
import oracle.ewt.access.AccessibleComponentImpl;
import oracle.ewt.event.AnyEventListener;
import oracle.ewt.event.AnyEventMulticaster;
import oracle.ewt.help.HelpCapable;
import oracle.ewt.help.HelpProvider;
import oracle.ewt.lwAWT.BufferedPanel;
import oracle.ewt.lwAWT.DoubleBuffer;
import oracle.ewt.lwAWT.DoubleBufferer;
import oracle.ewt.lwAWT.FocusRoot;
import oracle.ewt.lwAWT.ImmediatePainter;
import oracle.ewt.lwAWT.KeyProcessor;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.SharedPainter;
import oracle.ewt.lwAWT.VComponentPaintContext;
import oracle.ewt.lwAWT.VirtualComponent;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.popup.PopupFrame;
import oracle.ewt.util.FocusUtils;
import oracle.ewt.util.ImmInsets;
import oracle.ewt.util.LocaleUtils;
import oracle.ewt.util.WindowUtils;

public class BufferedFrame
extends PopupFrame
implements ImmediatePainter,
DoubleBufferer,
HelpCapable,
VirtualComponent,
FocusRoot,
KeyProcessor,
Accessible {
    private static int _sInstanceCounter = 0;
    private SharedPainter _painter;
    private AnyEventListener _anyListener;
    private LookAndFeel _laf;
    private ColorScheme _colorScheme;
    private Object _helpBook;
    private String _helpTopic;
    private HelpProvider _helpProvider;
    private PaintContext _paintContext;
    private int _readingDirection = -1;
    private boolean _isReadingDirectionDefaulted = true;
    private boolean _isLocaleDefaulted = true;
    private Component _focusOwner;
    private KeyListener _postKeyListener;
    private transient AccessibleContext _accessibleContext;

    public BufferedFrame() {
        this._init();
    }

    public BufferedFrame(String string) {
        super(string);
        this._init();
    }

    public void setLookAndFeel(LookAndFeel lookAndFeel) {
        if (lookAndFeel == null) {
            lookAndFeel = UIManager.getLookAndFeel();
        }
        if (this._laf != lookAndFeel) {
            this._laf = lookAndFeel;
            if (this._colorScheme != null) {
                this._colorScheme = lookAndFeel.getColorScheme(this._colorScheme);
            }
            this._updateBackground(this.getUIDefaults());
        }
    }

    public LookAndFeel getLookAndFeel() {
        return this._laf;
    }

    public void setColorScheme(ColorScheme colorScheme) {
        this._colorScheme = colorScheme;
        this._updateBackground(this.getUIDefaults());
    }

    public ColorScheme getColorScheme() {
        return this._colorScheme;
    }

    public void setRootFocusOwner(Component component) {
        this._focusOwner = component;
    }

    public Component getRootFocusOwner() {
        return this._focusOwner;
    }

    public synchronized void addAnyEventListener(AnyEventListener anyEventListener) {
        this._anyListener = AnyEventMulticaster.add(this._anyListener, anyEventListener);
    }

    public synchronized void removeAnyEventListener(AnyEventListener anyEventListener) {
        this._anyListener = AnyEventMulticaster.remove(this._anyListener, anyEventListener);
    }

    public String getHelpTopic() {
        return this._helpTopic;
    }

    public void setHelpTopic(String string) {
        this._helpTopic = string;
    }

    public Object getHelpBook() {
        return this._helpBook;
    }

    public void setHelpBook(Object object) {
        this._helpBook = object;
    }

    public HelpProvider getHelpProvider() {
        HelpProvider helpProvider = this._helpProvider;
        return helpProvider == null ? LWComponent.getDefaultHelpProvider() : helpProvider;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this._helpProvider = helpProvider;
    }

    public void showHelp() {
        this._painter.showHelp();
    }

    public void setLocale(Locale locale) {
        Locale locale2 = LocaleUtils.getDefaultableLocale(this);
        Locale locale3 = locale;
        if (locale == null) {
            this._isLocaleDefaulted = true;
            locale3 = Locale.getDefault();
        } else {
            this._isLocaleDefaulted = false;
        }
        if (!locale3.equals(locale2)) {
            this.updateLocale(locale3, locale2);
        } else {
            super.setLocale(locale);
        }
    }

    public void setReadingDirection(int n) {
        this._setReadingDirection(n, true);
    }

    public int getReadingDirection() {
        if (this._isReadingDirectionDefaulted) {
            return 0;
        }
        return this._readingDirection;
    }

    public int getActualReadingDirection() {
        return this._readingDirection;
    }

    public void setFill(Painter painter) {
        this._painter.setFill(painter);
    }

    public Painter getFill() {
        return this._painter.getFill();
    }

    public BorderPainter getBorderPainter() {
        return null;
    }

    public boolean isTransparent() {
        return false;
    }

    public boolean isPaintPropagationRequired() {
        return false;
    }

    public Insets insets() {
        Insets insets = super.insets();
        Insets insets2 = (Insets)insets.clone();
        BorderPainter borderPainter = this.getBorderPainter();
        ImmInsets immInsets = borderPainter != null ? borderPainter.getInsets(this.getPaintContext()) : ImmInsets.getEmptyInsets();
        insets2.top += immInsets.top;
        insets2.left += immInsets.left;
        insets2.bottom += immInsets.bottom;
        insets2.right += immInsets.right;
        return insets2;
    }

    public final Insets getInsets() {
        return this.insets();
    }

    public final ImmInsets getBorderInsets() {
        return new ImmInsets(this.getInsets());
    }

    public void freezeRepaints() {
        this._painter.freezeRepaints();
    }

    public void unfreezeRepaints() {
        this._painter.unfreezeRepaints(this.getDoubleBuffer());
    }

    public void paintImmediate(int n, int n2, int n3, int n4) {
        this._painter.paintImmediate(n, n2, n3, n4, this.getDoubleBuffer());
    }

    public void paintImmediateUnclipped(int n, int n2, int n3, int n4) {
        this.paintImmediate(n, n2, n3, n4);
    }

    public boolean isChildClipped(Component component) {
        return this._painter.isChildClipped(component);
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (this._painter != null && this._painter.repaint(n, n2, n3, n4)) {
            super.repaint(l, n, n2, n3, n4);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.isShowing()) {
            this._painter.paint(graphics, this.getDoubleBuffer(), this);
        }
    }

    public void paintInterior(Graphics graphics) {
    }

    public UIDefaults getUIDefaults() {
        return this._laf.getDefaults(this.getPaintContext());
    }

    public AccessibleContext getAccessibleContext() {
        if (this._accessibleContext == null) {
            this._accessibleContext = new Access();
        }
        return this._accessibleContext;
    }

    public boolean isActive() {
        return WindowUtils.getWindow(this) == WindowUtils.getActiveWindow();
    }

    public PaintContext getPaintContext() {
        if (this._paintContext == null) {
            this._paintContext = new VComponentPaintContext(this);
        }
        return this._paintContext;
    }

    public PaintContext getBorderContext() {
        return this.getPaintContext();
    }

    public void postProcessKey(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        KeyListener keyListener = this._postKeyListener;
        if (keyListener != null) {
            switch (keyEvent.getID()) {
                case 401: {
                    keyListener.keyPressed(keyEvent);
                    break;
                }
                case 402: {
                    keyListener.keyReleased(keyEvent);
                    break;
                }
                case 400: {
                    keyListener.keyTyped(keyEvent);
                }
            }
        }
    }

    public void addPostKeyListener(KeyListener keyListener) {
        this._postKeyListener = AWTEventMulticaster.add(this._postKeyListener, keyListener);
    }

    public void removePostKeyListener(KeyListener keyListener) {
        this._postKeyListener = AWTEventMulticaster.remove(this._postKeyListener, keyListener);
    }

    public void invalidate() {
        if (this._painter != null) {
            this._painter.clearClipCache();
        }
        super.invalidate();
    }

    public void doLayout() {
        this._painter.clearClipCache();
        super.doLayout();
    }

    public void reshape(int n, int n2, int n3, int n4) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (n3 > dimension.width) {
            n3 = dimension.width;
        }
        if (n4 > dimension.height) {
            n4 = dimension.height;
        }
        Dimension dimension2 = null;
        if (this._painter != null && (this.getFill().getRepaintFlags(this.getPaintContext()) & 0x80) != 0) {
            dimension2 = this.getSize();
        }
        super.reshape(n, n2, n3, n4);
        if (dimension2 != null && (dimension2.width != n3 || dimension2.height != n4)) {
            this.repaint();
        }
    }

    public void removeNotify() {
        LWComponent._loseFocusIfChild(this);
        super.removeNotify();
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            this.getDoubleBuffer().flush();
            LWComponent._flushDoubleBuffer(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n) {
        Component component;
        Object object = this.getTreeLock();
        synchronized (object) {
            component = this.getComponent(n);
            if (!(component.getPeer() instanceof LightweightPeer)) {
                component = null;
            }
            super.remove(n);
            this._painter.remove(n);
        }
        if (component != null && component.isVisible()) {
            object = component.getBounds();
            this.repaint(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Rectangle rectangle;
        Object object = this.getTreeLock();
        synchronized (object) {
            rectangle = LWComponent._getLWChildBounds(this);
            super.removeAll();
            this._painter.removeAll();
        }
        if (rectangle != null) {
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addImpl(Component component, Object object, int n) {
        Object object2 = this.getTreeLock();
        synchronized (object2) {
            super.addImpl(component, object, n);
            this._painter.add(component, n);
        }
        if (component.getPeer() instanceof LightweightPeer && component.isVisible()) {
            component.repaint();
        }
    }

    protected void updateLocale(Locale locale, Locale locale2) {
        super.setLocale(locale);
        if (this._isReadingDirectionDefaulted) {
            this._setReadingDirection(0, false);
        }
        this._painter.propagateLocale(locale, locale2);
    }

    protected final void processEvent(AWTEvent aWTEvent) {
        Component component;
        AnyEventListener anyEventListener = this._anyListener;
        if (anyEventListener != null) {
            anyEventListener.processEventStart(aWTEvent);
        }
        this.processEventImpl(aWTEvent);
        if (aWTEvent instanceof KeyEvent && ((component = this.getFocusOwner()) == this || !(component instanceof LWComponent))) {
            LWComponent.__postProcessKeyInWindow((KeyEvent)aWTEvent);
        }
        if (anyEventListener != null) {
            anyEventListener.processEventEnd(aWTEvent);
        }
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        super.processEvent(aWTEvent);
    }

    protected DoubleBuffer getDoubleBuffer() {
        return BufferedPanel._getDoubleBuffer();
    }

    protected String getDefaultName() {
        return this.getBaseClassName() + _sInstanceCounter++;
    }

    protected String getBaseClassName() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    private void _updateBackground(UIDefaults uIDefaults) {
        this.setBackground(uIDefaults.getColor(LookAndFeel.WINDOW));
    }

    private void _init() {
        this._laf = UIManager.getLookAndFeel();
        this._colorScheme = this._laf.getDefaultColorScheme();
        this.setName(this.getDefaultName());
        UIDefaults uIDefaults = this.getUIDefaults();
        this._updateBackground(uIDefaults);
        this._painter = new SharedPainter(this, uIDefaults.getPainter(LookAndFeel.BACKGROUND_PAINTER));
        this.setReadingDirection(0);
        this.setLocale(null);
        WindowUtils.registerWindow(this);
        this.enableEvents(8L);
    }

    public void setTitle(String string) {
        String string2 = this.getTitle();
        super.setTitle(string);
        AccessibleContext accessibleContext = this._accessibleContext;
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleName", string2, string);
        }
    }

    public void dispose() {
        super.dispose();
        WindowUtils.unregisterWindow(this);
    }

    private void _setReadingDirection(int n, boolean bl) {
        if (n == 0) {
            this._isReadingDirectionDefaulted = true;
            Container container = this.getParent();
            n = this._isLocaleDefaulted && container instanceof VirtualComponent ? ((VirtualComponent)((Object)container)).getActualReadingDirection() : LocaleUtils.getReadingDirectionForLocale(LocaleUtils.getDefaultableLocale(this));
        } else {
            this._isReadingDirectionDefaulted = false;
        }
        if (n != this._readingDirection) {
            this._readingDirection = n;
            if (bl) {
                this._painter.propagateReadingDirection(n);
            }
        }
    }

    private class Access
    extends AccessibleComponentImpl {
        public Access() {
            super(BufferedFrame.this);
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (BufferedFrame.this.getTitle() == null) {
                return super.getAccessibleName();
            }
            return BufferedFrame.this.getTitle();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.FRAME;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (BufferedFrame.this.isResizable()) {
                accessibleStateSet.add(AccessibleState.RESIZABLE);
            }
            if (BufferedFrame.this.isActive()) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
            }
            return accessibleStateSet;
        }
    }
}

