/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.grid;

import oracle.ewt.grid.Cell;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridSelection;

public class SingleSelection
implements GridSelection {
    private Grid _grid;
    private int _column = -1;
    private int _row = -1;

    public void setParent(Grid grid) {
        this._grid = grid;
        this._row = -1;
        this._column = -1;
    }

    public Grid getParent() {
        return this._grid;
    }

    public void rowsAdded(int n, int n2) {
        if (this._row == -1 || this._row < n) {
            return;
        }
        this._row += n2;
    }

    public void rowsRemoved(int n, int n2) {
        if (this._row == -1 || this._row < n) {
            return;
        }
        if (this._row < n + n2) {
            this._row = -1;
            this._column = -1;
        } else {
            this._row -= n2;
        }
    }

    public void columnsAdded(int n, int n2) {
        if (this._column == -1 || this._column < n) {
            return;
        }
        this._column += n2;
    }

    public void columnsRemoved(int n, int n2) {
        if (this._column == -1 || this._column < n) {
            return;
        }
        if (this._column < n + n2) {
            this._row = -1;
            this._column = -1;
        } else {
            this._column -= n2;
        }
    }

    public void selectAll() {
        this.deselectAll();
        this.setColumnSelected(0, true);
    }

    public void deselectAll() {
        if (this._column != -1 && this._row != -1) {
            this.setCellSelected(this._column, this._row, false);
        } else if (this._column != -1) {
            this.setColumnSelected(this._column, false);
        } else if (this._row != -1) {
            this.setRowSelected(this._row, false);
        }
    }

    public boolean isSomethingSelected() {
        return this._column != -1 || this._row != -1;
    }

    public void setColumnSelected(int n, boolean bl) {
        if (this.isColumnSelected(n) == bl) {
            return;
        }
        if (bl) {
            if (this._grid.fireCancelableColumnEvent(n, 2009)) {
                return;
            }
            this.deselectAll();
            this._column = n;
            this._grid.fireColumnEvent(n, 2010);
        } else {
            if (this._grid.fireCancelableColumnEvent(n, 2011)) {
                return;
            }
            this._column = -1;
            this._grid.fireColumnEvent(n, 2012);
        }
        this._grid.paintColumn(n);
    }

    public boolean isColumnSelected(int n) {
        return n == this._column && this._row == -1;
    }

    public int[] getSelectedColumns() {
        if (this._column == -1 || this._row != -1) {
            return null;
        }
        int[] nArray = new int[]{this._column};
        return nArray;
    }

    public void setRowSelected(int n, boolean bl) {
        if (this.isRowSelected(n) == bl) {
            return;
        }
        if (bl) {
            if (this._grid.fireCancelableRowEvent(n, 2005)) {
                return;
            }
            this.deselectAll();
            this._row = n;
            this._grid.fireRowEvent(n, 2006);
        } else {
            if (this._grid.fireCancelableRowEvent(n, 2007)) {
                return;
            }
            this._row = -1;
            this._grid.fireRowEvent(n, 2008);
        }
        this._grid.paintRow(n);
    }

    public boolean isRowSelected(int n) {
        return n == this._row && this._column == -1;
    }

    public int[] getSelectedRows() {
        if (this._row == -1 || this._column != -1) {
            return null;
        }
        int[] nArray = new int[]{this._row};
        return nArray;
    }

    public void setCellSelected(int n, int n2, boolean bl) {
        if (this.isCellSelected(n, n2) == bl) {
            return;
        }
        if (bl) {
            if (this._grid.fireCancelableCellEvent(n, n2, 2001)) {
                return;
            }
            this.deselectAll();
            this._column = n;
            this._row = n2;
            this._grid.fireCellEvent(n, n2, 2002);
        } else {
            if (this._grid.fireCancelableCellEvent(n, n2, 2003)) {
                return;
            }
            this._column = -1;
            this._row = -1;
            this._grid.fireCellEvent(n, n2, 2004);
        }
        this._grid.paintCell(n, n2);
    }

    public boolean isCellSelected(int n, int n2) {
        return n2 == this._row && this._column == n;
    }

    public Cell[] getSelectedCells() {
        if (this._column == -1 || this._row == -1) {
            return null;
        }
        Cell[] cellArray = new Cell[]{new Cell(this._column, this._row)};
        return cellArray;
    }

    public void selectCellRange(int n, int n2, int n3, int n4) {
        this.setCellSelected(n, n2, true);
    }

    public void addCellToSelection(int n, int n2) {
        this.setCellSelected(n, n2, true);
    }

    public void removeCellFromSelection(int n, int n2) {
        this.setCellSelected(n, n2, false);
    }
}

