/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.font;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.ewt.button.ButtonBar;
import oracle.ewt.button.PushButton;
import oracle.ewt.font.FontBar;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextArea;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.util.LocaleUtils;
import oracle.ewt.util.StringUtils;

class InternalFontPane
extends LWContainer
implements PropertyChangeListener {
    private FontBar _fontBar = new FontBar();
    private LWLabel _sampleLabel = new LWLabel();
    private LWTextArea _sampleText = new LWTextArea();
    private PushButton _okButton;
    private PushButton _cancelButton;
    private static final String _SAMPLE_KEY = "SAMPLE";
    private static final String _TEXT_KEY = "TEXT";
    private static final String _OK_KEY = "OK";
    private static final String _CANCEL_KEY = "CANCEL";

    public InternalFontPane() {
        this._sampleLabel.setLabelFor(this._sampleText);
        this._sampleText.setRows(3);
        LWContainer lWContainer = new LWContainer();
        lWContainer.setLayout(new BorderLayout());
        lWContainer.add("North", this._sampleLabel);
        lWContainer.add("Center", this._sampleText);
        this._okButton = new PushButton();
        this._okButton.setDefault(true);
        this._cancelButton = new PushButton();
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.setAlignment(2);
        buttonBar.add(this._okButton);
        buttonBar.add(this._cancelButton);
        this.setLayout(new BorderLayout());
        this.add("North", this._fontBar);
        this.add("Center", lWContainer);
        this.add("South", buttonBar);
        this.setBorderPainter(new FixedBorderPainter(null, 5, 5, 5, 5, true, false));
        lWContainer.setBorderPainter(new FixedBorderPainter(null, 5, 0, 5, 0, true, false));
        this._fontBar.addPropertyChangeListener(this);
    }

    public PushButton getCancelButton() {
        return this._cancelButton;
    }

    public FontBar getFontBar() {
        return this._fontBar;
    }

    public PushButton getOKButton() {
        return this._okButton;
    }

    public void postProcessKey(KeyEvent keyEvent) {
        super.postProcessKey(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 27) {
            this._cancelButton.simulatePush();
            keyEvent.consume();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Font font;
        if (propertyChangeEvent.getPropertyName().equals("_selectedFont") && (font = (Font)propertyChangeEvent.getNewValue()) != null) {
            this._sampleText.setFont(font);
        }
    }

    protected void updateLocale(Locale locale, Locale locale2) {
        super.updateLocale(locale, locale2);
        this._loadMessages(locale);
    }

    private void _loadMessages(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.ewt.font.resource.FontBundle", LocaleUtils.getTranslationLocale(locale));
        this._sampleLabel.setText(resourceBundle.getString(_SAMPLE_KEY));
        this._sampleText.setText(resourceBundle.getString(_TEXT_KEY));
        this._loadButtonLabel(this._okButton, resourceBundle.getString(_OK_KEY));
        this._loadButtonLabel(this._cancelButton, resourceBundle.getString(_CANCEL_KEY));
    }

    private void _loadButtonLabel(PushButton pushButton, String string) {
        int n = StringUtils.getMnemonicIndex(string);
        if (n != -1) {
            string = StringUtils.stripMnemonic(string);
        }
        pushButton.setLabel(string);
        pushButton.setMnemonicIndex(n);
    }
}

