/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.usages;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.ide.util.Assert;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ideimpl.usages.ServerLocation;
import oracle.ideimpl.usages.ServerLocations;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;

public final class FileSender {
    private static final FileSender _instance = new FileSender();
    private List<ServerLocation> _uploadServers;

    private FileSender() {
    }

    public static FileSender getInstance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean logToServer(File ... logFiles) {
        if (logFiles == null || logFiles.length == 0) {
            return false;
        }
        List<ServerLocation> servers = this.getUsageServers();
        if (servers.isEmpty()) {
            return false;
        }
        boolean success = false;
        DefaultHttpClient httpClient = null;
        try {
            MultipartEntity m = new MultipartEntity();
            for (File file : logFiles) {
                FileBody body = new FileBody(file);
                m.addPart(body.getFilename(), (ContentBody)body);
            }
            httpClient = new DefaultHttpClient();
            FileSender.maybeConfigureProxySettings(httpClient);
            httpClient.getParams().setParameter("http.useragent", (Object)"Usage Tracker");
            httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler());
            Iterator<ServerLocation> serverIterator = servers.iterator();
            while (!success && serverIterator.hasNext()) {
                ServerLocation server = serverIterator.next();
                HttpPost post = new HttpPost(server.getUrl());
                post.setEntity((HttpEntity)m);
                HttpResponse response = httpClient.execute((HttpUriRequest)post);
                if (response.getStatusLine().getStatusCode() == 200) {
                    success = true;
                    continue;
                }
                serverIterator.remove();
                Assert.println((String)response.getStatusLine().getReasonPhrase());
            }
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
        finally {
            if (httpClient != null) {
                httpClient.getConnectionManager().shutdown();
            }
        }
        return success;
    }

    private static void maybeConfigureProxySettings(DefaultHttpClient client) {
        ProxyOptions options = ProxyOptions.getProxyOptions();
        if (options.getUseProxy().booleanValue()) {
            String host = options.getProxyHost();
            int port = Integer.parseInt(options.getProxyPort());
            HttpHost proxy = new HttpHost(host, port);
            client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            if (options.getUseProxyAuthentication().booleanValue()) {
                AuthScope authScope = new AuthScope(host, port);
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(options.getProxyUserName(), new String(options.getProxyPassword()));
                client.getCredentialsProvider().setCredentials(authScope, (Credentials)credentials);
            }
        }
    }

    private List<ServerLocation> getUsageServers() {
        if (this._uploadServers == null || this._uploadServers.size() == 0) {
            this._uploadServers = new ArrayList<ServerLocation>(ServerLocations.getServers());
        }
        return this._uploadServers;
    }
}

