/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.share.config;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.platform.AdfServerPlatformSupport;
import oracle.adf.share.platform.AdfServerPlatformSupportFactory;
import oracle.jrf.ApplicationIdentifier;
import oracle.jrf.PortabilityLayerException;

public class JRFApplicationHelper {
    private static final Logger logger = Logger.getLogger(JRFApplicationHelper.class.getName());

    private JRFApplicationHelper() {
    }

    public static String getMDSInstanceAppName() throws PortabilityLayerException {
        String appName;
        AdfServerPlatformSupportFactory factory = new AdfServerPlatformSupportFactory();
        AdfServerPlatformSupport inst = factory.getSupportInstance();
        ApplicationIdentifier id = inst.getApplicationIdentifier();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("ApplicationIdentifier=[applicationName=" + id.getApplicationName() + ", deploymentName=" + id.getDeploymentName() + ", displayName=" + id.getDisplayName() + ", partitionName=" + id.getPartitionName() + ", runtimeName=" + id.getRuntimeName() + ", version=" + id.getVersion() + "]");
        }
        if ((appName = id.getApplicationName().trim()) != null && appName.length() > 0) {
            String version = id.getVersion();
            if (version != null && version.length() > 0) {
                return appName + "#" + version.trim();
            }
            return appName;
        }
        return null;
    }
}

