/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import oracle.adf.share.codesharing.audit.annotation.CodeSharingSafe;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.platform.mt.MTHelper;
import oracle.adf.share.security.ADFSecurityRuntimeException;
import oracle.adf.share.security.ADFSecurityUtil;
import oracle.adf.share.security.TenantInfo;

public class TenantService {
    @CodeSharingSafe(value="MutableStaticField")
    private static TenantInfo tenantInfoProvider;
    private static final ADFLogger logger;
    private static final String ORACLE_SHARED_IDM_TENANTNAME = "oracle.sharedidm.tenantname";
    private static final String JPS_TENANT_INFO = "oracle.adf.share.security.providers.jps.JpsTenantInfo";
    private static final String FALLBACK_TENANT_INFO = "oracle.adf.share.security.FallbackTenantInfo";
    private static final String PLATFORM_TENANT_INFO = "oracle.adfinternal.share.mt.PlatformTenantInfo";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TenantInfo getInstance() {
        if (tenantInfoProvider != null) return tenantInfoProvider;
        Class<TenantService> clazz = TenantService.class;
        synchronized (TenantService.class) {
            if (tenantInfoProvider != null) return tenantInfoProvider;
            tenantInfoProvider = MTHelper.getMultitenancyEnabled() ? TenantService.create(PLATFORM_TENANT_INFO) : (TenantService.isSharedIdmEnabled() ? TenantService.create(JPS_TENANT_INFO) : TenantService.create(FALLBACK_TENANT_INFO));
            // ** MonitorExit[var0] (shouldn't be in output)
            return tenantInfoProvider;
        }
    }

    static TenantInfo create(String clsName) {
        TenantInfo info = null;
        try {
            Class cls = ClassUtils.forName((String)clsName, TenantService.class);
            Constructor ctor = cls.getConstructor(new Class[0]);
            info = (TenantInfo)ctor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new ADFSecurityRuntimeException("EXC_UNEXPECTED_ERROR", ex);
        }
        return info;
    }

    public static boolean isSharedIdmEnabled() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean(TenantService.ORACLE_SHARED_IDM_TENANTNAME);
            }
        });
    }

    static {
        logger = ADFSecurityUtil.getADFLogger();
    }
}

