/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.config;

import java.util.HashMap;
import oracle.adf.share.logging.ADFLogger;

public class ADFConfigParsingContext {
    private static final String CONTEXT = "_context";
    private static final String APPNAME = "_appname";
    private static final String FILENAME = "_filename";
    private static final String REPARSE = "_reparse";
    private static final String FILEPATH = "_filepath";
    private HashMap mDefaultMap = new HashMap(10);
    private static final ADFLogger logger = ADFLogger.createADFLogger((String)"oracle.adf.share.config.ADFConfig");

    ADFConfigParsingContext(String applicationName, Object ctx, String filename) {
        this.mDefaultMap.put(APPNAME, applicationName);
        this.mDefaultMap.put(CONTEXT, ctx);
        this.mDefaultMap.put(FILENAME, filename);
        if (logger.isFine()) {
            logger.fine(this.mDefaultMap.toString());
        }
    }

    public ADFConfigParsingContext(String applicationName, Object ctx, String filename, String filePath, boolean reparse) {
        this.mDefaultMap.put(APPNAME, applicationName);
        this.mDefaultMap.put(CONTEXT, ctx);
        this.mDefaultMap.put(FILENAME, filename);
        this.mDefaultMap.put(FILEPATH, filePath);
        if (reparse) {
            this.mDefaultMap.put(REPARSE, Boolean.TRUE);
        } else {
            this.mDefaultMap.put(REPARSE, Boolean.FALSE);
        }
        if (logger.isFine()) {
            logger.fine(this.mDefaultMap.toString());
        }
    }

    ADFConfigParsingContext(String applicationName, Object ctx, String filename, String filePath) {
        this(applicationName, ctx, filename, filePath, false);
    }

    public ADFLogger getLogger() {
        return logger;
    }

    public Object getContext() {
        return this.mDefaultMap.get(CONTEXT);
    }

    public String getApplicationName() {
        return (String)this.mDefaultMap.get(APPNAME);
    }

    public boolean isReparse() {
        if (((Boolean)this.mDefaultMap.get(REPARSE)).booleanValue()) {
            return Boolean.TRUE;
        }
        return false;
    }

    public String getConfigFilename() {
        return (String)this.mDefaultMap.get(FILENAME);
    }

    public String getConfigFilePath() {
        return (String)this.mDefaultMap.get(FILEPATH);
    }
}

