/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.templates;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.templates.TemplateRegistration;
import org.netbeans.api.templates.TemplateRegistrations;
import org.openide.WizardDescriptor;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class TemplateProcessor
extends LayerGeneratingProcessor {
    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(Arrays.asList(TemplateRegistration.class.getCanonicalName(), TemplateRegistrations.class.getCanonicalName()));
    }

    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws LayerGenerationException {
        if (roundEnv.processingOver()) {
            return false;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(TemplateRegistration.class)) {
            TemplateRegistration r = element.getAnnotation(TemplateRegistration.class);
            if (r == null) continue;
            this.process(element, r);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(TemplateRegistrations.class)) {
            TemplateRegistrations rr = element.getAnnotation(TemplateRegistrations.class);
            if (rr == null) continue;
            for (TemplateRegistration t : rr.value()) {
                this.process(element, t);
            }
        }
        return false;
    }

    private void process(Element e, TemplateRegistration t) throws LayerGenerationException {
        String basename;
        LayerBuilder builder = this.layer(new Element[]{e});
        if (!t.id().isEmpty()) {
            if (t.content().length > 0) {
                throw new LayerGenerationException("Cannot specify both id and content", e, this.processingEnv, (Annotation)t);
            }
            basename = t.id();
        } else if (t.content().length > 0) {
            basename = TemplateProcessor.basename(t.content()[0]);
        } else if (e.getKind() == ElementKind.CLASS) {
            basename = ((TypeElement)e).getQualifiedName().toString().replace('.', '-');
        } else if (e.getKind() == ElementKind.METHOD) {
            basename = ((TypeElement)e.getEnclosingElement()).getQualifiedName().toString().replace('.', '-') + '-' + e.getSimpleName();
        } else {
            throw new LayerGenerationException("cannot use @Template on a package without specifying content", e, this.processingEnv, (Annotation)t);
        }
        String folder = "Templates/" + t.folder() + '/';
        LayerBuilder.File f = builder.file(folder + basename);
        if (e.getKind() != ElementKind.PACKAGE) {
            f.instanceAttribute("instantiatingIterator", WizardDescriptor.InstantiatingIterator.class);
        }
        f.write();
    }

    private static String basename(String relativeResource) {
        return relativeResource.replaceFirst(".+/", "").replaceFirst("[.]template$", "");
    }
}

