/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.ssh.SshSupportResources;
import oracle.dbtools.raptor.ssh.core.Client;
import oracle.dbtools.raptor.ssh.core.HostDescriptor;
import oracle.dbtools.raptor.ssh.core.Store;
import oracle.dbtools.raptor.ssh.core.TunnelDescriptor;
import oracle.dbtools.raptor.ssh.ui.SSHDefinitionPanel;
import oracle.dbtools.raptor.ssh.ui.TunnelDefinitionPanel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;

public abstract class HostDefinitionPanel
extends SSHDefinitionPanel {
    static final String NAMES_KEY = "SSHDefinition.Names";
    static final String DESC_KEY = "SSHDefinition.HostDescriptor";
    private JTextField mFldName = new JTextField();
    private JTextField mFldHost = new JTextField();
    private WholeNumberField mFldPort = new WholeNumberField(22, 5);
    private JTextField mFldUser = new JTextField();
    private JCheckBox mChkKeyfile = new JCheckBox();
    private URLFileChooser.URLFileChooserPanel mPnlKeyfile = HostDefinitionPanel.createChooserPanel();

    protected static boolean runDialog(String string, HostDefinitionPanel hostDefinitionPanel, Namespace namespace) {
        TDialogLauncher tDialogLauncher = new TDialogLauncher((Component)Ide.getMainWindow(), string, (Traversable)hostDefinitionPanel, namespace);
        tDialogLauncher.setPackDialog(true);
        JEWTDialog jEWTDialog = tDialogLauncher.initDialog();
        jEWTDialog.setInitialFocus(hostDefinitionPanel.getInitialFocusComponent());
        jEWTDialog.getAccessibleContext().setAccessibleName(string);
        return tDialogLauncher.showDialog();
    }

    private static Namespace createNamespace(String string) {
        Namespace namespace = new Namespace();
        Store store = Client.getInstance().getStore();
        HashSet hashSet = new HashSet(store.listHosts());
        if (string != null) {
            hashSet.remove(string);
        }
        namespace.put(NAMES_KEY, hashSet);
        return namespace;
    }

    public static void createHostDefinition(Client client) {
        HostDescriptor hostDescriptor;
        Namespace namespace = HostDefinitionPanel.createNamespace(null);
        namespace.put("Tunnel.Type", (Object)TunnelDescriptor.Type.REMOTE);
        if (HostDefinitionPanel.runDialog(SshSupportResources.getString("SSH_TITLE_NEW"), new CreateHostDefinitionPanel(), namespace) && (hostDescriptor = (HostDescriptor)namespace.get(DESC_KEY)) != null) {
            client.getStore().addHost(hostDescriptor);
            TunnelDescriptor tunnelDescriptor = (TunnelDescriptor)namespace.get("SSHDefinition.TunnelDescriptor");
            if (tunnelDescriptor != null) {
                client.getStore().addTunnel(hostDescriptor, tunnelDescriptor);
            }
        }
    }

    public static void editHostDefinition(Client client, HostDescriptor hostDescriptor) {
        HostDescriptor hostDescriptor2;
        Namespace namespace = HostDefinitionPanel.createNamespace(hostDescriptor.getName());
        namespace.put(DESC_KEY, (Object)hostDescriptor);
        if (HostDefinitionPanel.runDialog(SshSupportResources.getString("SSH_TITLE_EDIT"), new EditHostDefinitionPanel(), namespace) && (hostDescriptor2 = (HostDescriptor)namespace.get(DESC_KEY)) != null && ModelUtil.areDifferent((Object)hostDescriptor, (Object)hostDescriptor2)) {
            client.getStore().updateHost(hostDescriptor, hostDescriptor2);
        }
    }

    private static URLFileChooser.URLFileChooserPanel createChooserPanel() {
        URLFileChooser.URLFileChooserPanel uRLFileChooserPanel = URLFileChooser.createURLFileChooserPanel((int)0, null, (String)SshSupportResources.getString("SSH_TITLE_KEYFILE"), (boolean)false, (boolean)true);
        uRLFileChooserPanel.setPathContext(HostDefinitionPanel.class.getName() + ".mPnlKeyFile");
        uRLFileChooserPanel.clearChooseableURLFilters();
        uRLFileChooserPanel.addChooseableURLFilter(URLFileChooser.ALL_FILES_FILTER);
        uRLFileChooserPanel.setSelectionScope(0);
        return uRLFileChooserPanel;
    }

    protected HostDefinitionPanel() {
    }

    public final String getHelpID() {
        return "f1_sshconnectiondialog_html";
    }

    protected final Component createComponent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.mFldName, (String)"Name");
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)0, (int)0, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        jPanel.add((Component)this.mFldName, LayoutControl.GBC.gbc((int)1, (int)0, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.mFldHost, (String)SshSupportResources.getString("SSH_LABEL_HOST"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)1, (int)0, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel.add((Component)this.mFldHost, LayoutControl.GBC.gbc((int)1, (int)1, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.mFldPort, (String)SshSupportResources.getString("SSH_LABEL_PORT"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)3, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP));
        jPanel.add((Component)this.mFldPort, LayoutControl.GBC.gbc((int)4, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.mFldUser, (String)SshSupportResources.getString("SSH_LABEL_USERNAME"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel.add((Component)this.mFldUser, LayoutControl.GBC.gbc((int)1, (int)2, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        JComponent jComponent = new JPanel(new GridBagLayout());
        this.mChkKeyfile.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                HostDefinitionPanel.this.toggleKeyfileState(itemEvent.getStateChange() == 1);
            }
        });
        this.toggleKeyfileState(this.mChkKeyfile.isSelected());
        ResourceUtils.resButton((AbstractButton)this.mChkKeyfile, (String)SshSupportResources.getString("SSH_OPTION_KEYFILE"));
        jComponent.add((Component)this.mChkKeyfile, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jComponent.add((Component)this.mPnlKeyfile, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jComponent, LayoutControl.GBC.gbc((int)0, (int)3, (int)5, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jComponent = this.createSubPanel();
        if (jComponent != null) {
            jPanel.add((Component)LayoutControl.GBC.createSubPanel((Component)jComponent), LayoutControl.GBC.gbc((int)0, (int)4, (int)5, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        }
        return jPanel;
    }

    public final Component getInitialFocusComponent() {
        return this.mFldName;
    }

    public void onEntry(TraversableContext traversableContext) {
        String string = SshSupportResources.getString("DEFAULT_NAME");
        String string2 = "localhost";
        int n = 22;
        String string3 = "";
        URL uRL = null;
        HostDescriptor hostDescriptor = (HostDescriptor)traversableContext.get(DESC_KEY);
        if (hostDescriptor != null) {
            string = hostDescriptor.getName();
            string2 = hostDescriptor.getHostname();
            int n2 = hostDescriptor.getPort();
            if (n2 > 0) {
                n = n2;
            }
            string3 = hostDescriptor.getUsername();
            uRL = hostDescriptor.getKeyfile();
        }
        this.mFldName.setText(string);
        this.mFldHost.setText(string2);
        this.mFldPort.setNumber((Number)n);
        this.mFldUser.setText(string3);
        if (uRL != null) {
            this.mChkKeyfile.setSelected(true);
            this.mPnlKeyfile.setSelectedURL(uRL);
        } else {
            this.mChkKeyfile.setSelected(false);
            this.mPnlKeyfile.setSelectedURL(null);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        InetAddress inetAddress;
        Set set = (Set)traversableContext.get(NAMES_KEY);
        String string = this.mFldName.getText();
        String string2 = this.mFldHost.getText();
        Number number = this.mFldPort.getNumber();
        int n = number != null ? number.intValue() : -1;
        String string3 = this.mFldUser.getText();
        URL uRL = null;
        if (!ModelUtil.hasLength((String)string)) {
            throw new TraversalException(SshSupportResources.getString("TUNNEL_ERROR_NAME"));
        }
        if (set.contains(string)) {
            throw new TraversalException(SshSupportResources.format("TUNNEL_ERROR_DUPLICATE_NAME", string));
        }
        if (!ModelUtil.hasLength((String)string2)) {
            throw new TraversalException(SshSupportResources.getString("SSH_ERROR_HOST"));
        }
        try {
            inetAddress = InetAddress.getByName(string2);
        }
        catch (UnknownHostException unknownHostException) {
            throw new TraversalException(SshSupportResources.format("SSH_ERROR_UNKOWN_HOST", string2));
        }
        if (n <= 0 || n > 65535) {
            throw new TraversalException(SshSupportResources.get("SSH_ERROR_PORT"));
        }
        if (!ModelUtil.hasLength((String)string3)) {
            throw new TraversalException(SshSupportResources.get("SSH_ERROR_USERNAME"));
        }
        if (this.mChkKeyfile.isSelected()) {
            uRL = this.mPnlKeyfile.getSelectedURL();
            if (uRL == null) {
                throw new TraversalException(SshSupportResources.getString("SSH_ERROR_MISSING_KEYFILE"));
            }
            if (!URLFileSystem.exists((URL)uRL) || !URLFileSystem.isRegularFile((URL)uRL)) {
                throw new TraversalException(SshSupportResources.format("SSH_ERROR_BAD_KEYFILE", URLFileSystem.getPlatformPathName((URL)uRL)));
            }
        }
        inetAddress = new HostDescriptor.Builder(string).username(string3).hostname(string2).port(n).keyfile(uRL);
        HostDescriptor hostDescriptor = inetAddress.getDescriptor();
        traversableContext.put(DESC_KEY, (Object)hostDescriptor);
    }

    private void toggleKeyfileState(boolean bl) {
        this.mPnlKeyfile.setEnabled(bl);
    }

    protected JComponent createSubPanel() {
        return null;
    }

    private static class EditHostDefinitionPanel
    extends HostDefinitionPanel {
        private EditHostDefinitionPanel() {
        }
    }

    private static class CreateHostDefinitionPanel
    extends HostDefinitionPanel {
        private JCheckBox mChkTunnel = new JCheckBox();
        private TunnelDefinitionPanel mPnlTunnel = TunnelDefinitionPanel.createTunnelDefinitionPanel(TunnelDescriptor.Type.LOCAL);

        private CreateHostDefinitionPanel() {
        }

        @Override
        public void onExit(TraversableContext traversableContext) throws TraversalException {
            super.onExit(traversableContext);
            if (this.mChkTunnel.isSelected()) {
                TunnelDescriptor tunnelDescriptor = this.mPnlTunnel.commit(TunnelDescriptor.Type.LOCAL, Collections.emptySet());
                traversableContext.put("SSHDefinition.TunnelDescriptor", (Object)tunnelDescriptor);
            }
        }

        @Override
        public void onEntry(TraversableContext traversableContext) {
            super.onEntry(traversableContext);
            this.mChkTunnel.setSelected(traversableContext.get("SSHDefinition.TunnelDescriptor") != null);
            this.mPnlTunnel.onEntry(traversableContext);
        }

        @Override
        protected JComponent createSubPanel() {
            JPanel jPanel = new JPanel(new GridBagLayout());
            ResourceUtils.resButton((AbstractButton)this.mChkTunnel, (String)SshSupportResources.getString("SSH_ADD_REMOTE_FORWARD"));
            this.mChkTunnel.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    mPnlTunnel.setEnabled(mChkTunnel.isSelected());
                }
            });
            this.mPnlTunnel.setEnabled(false);
            jPanel.add((Component)this.mChkTunnel, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
            jPanel.add(this.mPnlTunnel.getComponent(), LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
            return jPanel;
        }
    }
}

