/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.navigator;

import com.jcraft.jsch.JSchException;
import java.awt.Component;
import oracle.dbtools.raptor.ssh.SshSupportResources;
import oracle.dbtools.raptor.ssh.core.Client;
import oracle.dbtools.raptor.ssh.core.HostDescriptor;
import oracle.dbtools.raptor.ssh.core.TunnelDescriptor;
import oracle.dbtools.raptor.ssh.navigator.SshBaseElement;
import oracle.dbtools.raptor.ssh.navigator.SshHostElement;
import oracle.dbtools.raptor.ssh.navigator.SshTunnelElement;
import oracle.dbtools.raptor.ssh.ui.HostDefinitionPanel;
import oracle.dbtools.raptor.ssh.ui.TunnelDefinitionPanel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.explorer.IconOverlayCoordinator;
import oracle.ide.explorer.IconOverlayRegistry;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

class SshController
implements Controller {
    static final int NEW_HOST_ID = Ide.findOrCreateCmdID((String)"SshNavigator.NEW_HOST");
    static final int NEW_LOCAL_TUNNEL_ID = Ide.findOrCreateCmdID((String)"SshNavigator.NEW_LOCAL_TUNNEL");
    static final int NEW_REMOTE_TUNNEL_ID = Ide.findOrCreateCmdID((String)"SshNavigator.NEW_REMOTE_TUNNEL");
    static final int REMOVE_ID = Ide.findOrCreateCmdID((String)"SshNavigator.REMOVE");
    static final int TEST_ID = Ide.findOrCreateCmdID((String)"SshNavigator.TEST");
    static final int CONNECT_ID = Ide.findOrCreateCmdID((String)"SshNavigator.CONNECT");
    static final int DISCONNECT_ID = Ide.findOrCreateCmdID((String)"SshNavigator.DISCONNECT");
    private Client sshClient = Client.getInstance();

    SshController() {
    }

    public static void updateOverlays(Element element) {
        IconOverlayCoordinator iconOverlayCoordinator = IconOverlayRegistry.lookupOverlayCoordinator((String)"oracle.sqldeveloper.ssh");
        if (iconOverlayCoordinator != null) {
            IconOverlayTracker iconOverlayTracker = iconOverlayCoordinator.getOverlayTracker();
            iconOverlayTracker.validateOverlay(element);
            iconOverlayTracker.repaintOverlays();
        }
    }

    private static void reportException(JSchException jSchException, String string, String string2) {
        Throwable throwable = SshController.unravelException(jSchException);
        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)throwable, (String)string, (String)string2, null);
    }

    private static Throwable unravelException(JSchException jSchException) {
        Throwable throwable;
        Object object = jSchException;
        while (object instanceof JSchException && (throwable = object.getCause()) != null) {
            object = throwable;
        }
        return object;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == NEW_HOST_ID) {
            HostDefinitionPanel.createHostDefinition(this.sshClient);
            return true;
        }
        if (n == NEW_LOCAL_TUNNEL_ID) {
            SshBaseElement sshBaseElement = this.getContextSelection(context);
            if (sshBaseElement instanceof SshHostElement) {
                SshHostElement sshHostElement = (SshHostElement)sshBaseElement;
                HostDescriptor hostDescriptor = sshHostElement.getHost();
                TunnelDefinitionPanel.createTunnelDefinition(this.sshClient, hostDescriptor, TunnelDescriptor.Type.LOCAL);
            }
            return true;
        }
        if (n == NEW_REMOTE_TUNNEL_ID) {
            SshBaseElement sshBaseElement = this.getContextSelection(context);
            if (sshBaseElement instanceof SshHostElement) {
                SshHostElement sshHostElement = (SshHostElement)sshBaseElement;
                HostDescriptor hostDescriptor = sshHostElement.getHost();
                TunnelDefinitionPanel.createTunnelDefinition(this.sshClient, hostDescriptor, TunnelDescriptor.Type.REMOTE);
            }
            return true;
        }
        if (n == 56) {
            SshBaseElement sshBaseElement = this.getContextSelection(context);
            if (sshBaseElement instanceof SshHostElement) {
                SshHostElement sshHostElement = (SshHostElement)sshBaseElement;
                HostDescriptor hostDescriptor = sshHostElement.getHost();
                HostDefinitionPanel.editHostDefinition(this.sshClient, hostDescriptor);
            } else if (sshBaseElement instanceof SshTunnelElement) {
                SshTunnelElement sshTunnelElement = (SshTunnelElement)sshBaseElement;
                TunnelDescriptor tunnelDescriptor = sshTunnelElement.getTunnel();
                HostDescriptor hostDescriptor = tunnelDescriptor.getHost();
                TunnelDefinitionPanel.editTunnelDefinition(this.sshClient, hostDescriptor, tunnelDescriptor);
            }
            return true;
        }
        if (n == TEST_ID) {
            SshBaseElement sshBaseElement = this.getContextSelection(context);
            if (sshBaseElement instanceof SshHostElement) {
                SshHostElement sshHostElement = (SshHostElement)sshBaseElement;
                HostDescriptor hostDescriptor = sshHostElement.getHost();
                try {
                    this.sshClient.testConnection(hostDescriptor);
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)SshSupportResources.getString("TEST_MSG_SUCCESS"), (String)SshSupportResources.getString("TEST_TITLE"), null);
                }
                catch (JSchException jSchException) {
                    SshController.reportException(jSchException, SshSupportResources.getString("CONNECT_TITLE"), SshSupportResources.getString("CONNECT_FAILURE"));
                }
            }
            return true;
        }
        if (n == CONNECT_ID) {
            SshBaseElement sshBaseElement = this.getContextSelection(context);
            if (sshBaseElement instanceof SshHostElement) {
                SshHostElement sshHostElement = (SshHostElement)sshBaseElement;
                HostDescriptor hostDescriptor = sshHostElement.getHost();
                try {
                    this.sshClient.openConnection(hostDescriptor);
                }
                catch (JSchException jSchException) {
                    SshController.reportException(jSchException, SshSupportResources.getString("CONNECT_TITLE"), SshSupportResources.getString("CONNECT_FAILURE"));
                }
            } else if (sshBaseElement instanceof SshTunnelElement) {
                SshTunnelElement sshTunnelElement = (SshTunnelElement)sshBaseElement;
                TunnelDescriptor tunnelDescriptor = sshTunnelElement.getTunnel();
                try {
                    this.sshClient.openTunnel(tunnelDescriptor);
                }
                catch (JSchException jSchException) {
                    SshController.reportException(jSchException, SshSupportResources.getString("TUNNEL_CONNECT_TITLE"), SshSupportResources.getString("TUNNEL_CONNECT_FAILURE"));
                }
            }
            return true;
        }
        if (n == DISCONNECT_ID) {
            SshBaseElement sshBaseElement = this.getContextSelection(context);
            if (sshBaseElement instanceof SshHostElement) {
                SshHostElement sshHostElement = (SshHostElement)sshBaseElement;
                HostDescriptor hostDescriptor = sshHostElement.getHost();
                this.sshClient.closeConnection(hostDescriptor);
            } else if (sshBaseElement instanceof SshTunnelElement) {
                SshTunnelElement sshTunnelElement = (SshTunnelElement)sshBaseElement;
                TunnelDescriptor tunnelDescriptor = sshTunnelElement.getTunnel();
                try {
                    this.sshClient.closeTunnel(tunnelDescriptor);
                }
                catch (JSchException jSchException) {
                    SshController.reportException(jSchException, SshSupportResources.getString("TUNNEL_CONNECT_TITLE"), SshSupportResources.getString("TUNNEL_DISCONNECT_FAILURE"));
                }
            }
            return true;
        }
        if (n == REMOVE_ID) {
            SshBaseElement sshBaseElement = this.getContextSelection(context);
            if (sshBaseElement instanceof SshHostElement) {
                SshHostElement sshHostElement = (SshHostElement)sshBaseElement;
                HostDescriptor hostDescriptor = sshHostElement.getHost();
                if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)SshSupportResources.format("HOST_REMOVE_MESSAGE", hostDescriptor.getName()), (String)SshSupportResources.getString("HOST_REMOVE_TITLE"), null, (boolean)true)) {
                    this.sshClient.getStore().removeHost(hostDescriptor.getName());
                }
            } else if (sshBaseElement instanceof SshTunnelElement) {
                SshTunnelElement sshTunnelElement = (SshTunnelElement)sshBaseElement;
                TunnelDescriptor tunnelDescriptor = sshTunnelElement.getTunnel();
                if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)SshSupportResources.format("TUNNEL_REMOVE_MESSAGE", tunnelDescriptor.getName()), (String)SshSupportResources.getString("TUNNEL_REMOVE_TITLE"), null, (boolean)true)) {
                    this.sshClient.getStore().removeTunnel(tunnelDescriptor.getHost(), tunnelDescriptor.getName());
                }
            }
            return true;
        }
        return false;
    }

    private SshBaseElement getContextSelection(Context context) {
        SshBaseElement sshBaseElement = null;
        Element[] elementArray = context.getSelection();
        if (elementArray != null && elementArray.length == 1 && elementArray[0] instanceof SshBaseElement) {
            sshBaseElement = (SshBaseElement)elementArray[0];
        }
        return sshBaseElement;
    }

    public boolean update(IdeAction ideAction, Context context) {
        View view;
        ViewId viewId;
        int n;
        Element element = null;
        boolean bl = false;
        Element[] elementArray = context.getSelection();
        if (elementArray != null && elementArray.length > 0) {
            element = elementArray[0];
            boolean bl2 = bl = elementArray.length == 1;
        }
        if ((n = ideAction.getCommandId()) == NEW_HOST_ID || n == NEW_LOCAL_TUNNEL_ID || n == NEW_REMOTE_TUNNEL_ID || n == REMOVE_ID || n == TEST_ID) {
            return true;
        }
        if (n == CONNECT_ID) {
            boolean bl3 = false;
            if (element instanceof SshHostElement) {
                HostDescriptor hostDescriptor = ((SshHostElement)element).getHost();
                bl3 = !this.sshClient.isConnectionOpen(hostDescriptor);
            } else if (element instanceof SshTunnelElement) {
                TunnelDescriptor tunnelDescriptor = ((SshTunnelElement)element).getTunnel();
                bl3 = !this.sshClient.isTunnelOpen(tunnelDescriptor);
            }
            ideAction.setEnabled(bl3);
            return true;
        }
        if (n == DISCONNECT_ID) {
            boolean bl4 = false;
            if (element instanceof SshHostElement) {
                HostDescriptor hostDescriptor = ((SshHostElement)element).getHost();
                bl4 = this.sshClient.isConnectionOpen(hostDescriptor);
            } else if (element instanceof SshTunnelElement) {
                TunnelDescriptor tunnelDescriptor = ((SshTunnelElement)element).getTunnel();
                bl4 = this.sshClient.isTunnelOpen(tunnelDescriptor);
            }
            ideAction.setEnabled(bl4);
            return true;
        }
        if (n == 56 && "SshNavigatorWindow".equals((viewId = new ViewId((view = context.getView()).getId())).getType())) {
            if (bl && (element instanceof SshHostElement || element instanceof SshTunnelElement)) {
                ideAction.setEnabled(true);
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        return false;
    }
}

