/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer.model;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectPlSqlNode;
import oracle.ide.explorer.ExplorerWindow;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ideimpl.db.explorer.model.BaseFolder;
import oracle.ideimpl.db.explorer.model.DBExplorerElement;
import oracle.ideimpl.db.explorer.model.DBObjectFolder;
import oracle.ideimpl.db.explorer.model.ExplorerModelHelper;
import oracle.ideimpl.db.explorer.model.PlSqlFragmentElement;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;

public class DBObjectFolderFactory {
    public static Element createRootFolder(DBObjectNode newNode, Context context) {
        return new SimpleRoot(newNode, context);
    }

    public static void update(Element elem) {
        if (elem instanceof DBExplorerElement) {
            ((DBExplorerElement)elem).reset();
        }
    }

    public static void setErrors(final Element root, final List<Element> errors) {
        if (root instanceof BaseFolder) {
            if (SwingUtilities.isEventDispatchThread()) {
                ((BaseFolder)root).setErrors(errors);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((BaseFolder)root).setErrors(errors);
                    }
                });
            }
        }
    }

    public static boolean canGoToDeclaration(Context context) {
        Element elem;
        Element[] sel;
        Node node;
        boolean retval = false;
        if (context.getView() instanceof ExplorerWindow && (node = context.getNode()) instanceof DBObjectNode && !DBObjectNodeUtil.isOnlineNode((Object)node) && (sel = context.getSelection()) != null && sel.length == 1 && (elem = sel[0]) instanceof DBObjectNode) {
            DBEditorFactory fac = DBEditorFactoryRegistry.getEditFactory((DBObjectNode)((DBObjectNode)node));
            retval = fac != null;
        }
        return retval;
    }

    public static void handleGoToDeclaration(Context context) {
        DBEditorFactory factory;
        Node node = context.getNode();
        Element elem = context.getElement();
        if (node instanceof DBObjectNode && elem instanceof DBObjectNode && (factory = DBEditorFactoryRegistry.getEditFactory((DBObjectNode)((DBObjectNode)node))) != null) {
            DBEditorConfig config = DBEditorConfig.newEditConfig((DBObjectNode)((DBObjectNode)node));
            DBObject obj = ((DBObjectNode)elem).getDBObject();
            if (obj.getParent() != null) {
                config.setChildObject(obj);
            }
            factory.launchDialog(config);
        }
    }

    private static class SimpleRoot
    extends BaseFolder {
        private DBObjectNode m_node;
        private Context m_context;
        private DBObjectFolder m_root;

        public SimpleRoot(DBObjectNode newNode, Context context) {
            this.m_node = newNode;
            this.m_context = context;
            this.setHelper(new ExplorerModelHelper(context));
        }

        @Override
        protected List<Element> createChildren(List<Element> existing) {
            ArrayList<Element> l = new ArrayList<Element>();
            if (this.m_root == null) {
                this.m_root = this.m_node instanceof DBObjectPlSqlNode ? new PlSqlFragmentElement(this.m_node) : new DBObjectFolder(this.m_node);
            } else {
                this.m_root.setDBObjectNode(this.m_node);
            }
            this.m_root.setContext(this.m_context);
            if (this.m_root != null) {
                l.add(this.m_root);
            }
            return l;
        }

        public String getShortLabel() {
            return "root";
        }

        public String getLongLabel() {
            return this.m_node.getLongLabel();
        }

        public Icon getIcon() {
            return this.m_node.getIcon();
        }

        public String getToolTipText() {
            return this.m_node.getToolTipText();
        }

        @Override
        public Object getKey() {
            return this.m_node.getURL();
        }

        @Override
        protected DBObjectProvider useDBRunnable() {
            if (this.m_root != null) {
                return this.m_root.useDBRunnable();
            }
            return super.useDBRunnable();
        }
    }
}

