/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer.model;

import java.net.URL;
import javax.swing.Icon;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ideimpl.db.explorer.model.ExplorerModelHelper;
import oracle.ideimpl.db.explorer.model.ObjectFolder;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;

class DBObjectFolder
extends ObjectFolder<DBObject>
implements DBObjectNode {
    private DBObjectNode m_node;

    public DBObjectFolder(DBObject obj, DBObjectProvider pro, String propName) {
        super(obj, pro, propName);
    }

    public DBObjectFolder(DBObjectNode node) {
        super(null, DBObjectNodeUtil.findProvider((Object)node), null);
        this.m_node = node;
    }

    @Override
    protected DBObjectProvider useDBRunnable() {
        DBObject cachedObj;
        DBObjectProvider retval = null;
        DBObjectProvider pro = this.getProvider();
        if (pro instanceof Database && ((cachedObj = (DBObject)super.getObject()) == null || DBUtil.needsBuilding((DBObject)DBUtil.getSystemObject((DBObject)cachedObj)))) {
            retval = pro;
        }
        return retval;
    }

    void setDBObjectNode(DBObjectNode node) {
        if (this.m_node != null) {
            this.m_node = node;
            this.setObject(null);
        }
    }

    public String getObjectType() {
        String retval = this.m_node == null ? this.getObject().getType() : DBObjectNodeUtil.normalizeType((DBObjectTypeNode)this.m_node);
        return retval;
    }

    public DBObject getDBObject() {
        return this.getObject();
    }

    public String getObjectName() {
        String retval = this.m_node == null ? this.getObject().getName() : this.m_node.getObjectName();
        return retval;
    }

    public Object getProviderIdentifier() {
        DBObjectProvider pro = this.getProvider();
        return pro == null ? null : pro.getProviderIdentifier();
    }

    public String getProviderType() {
        DBObjectProvider pro = this.getProvider();
        return pro == null ? null : pro.getProviderType();
    }

    public String getSchemaName() {
        Schema s;
        String retval = this.m_node == null ? ((s = DBUtil.getSchema((DBObject)this.getObject())) == null ? null : s.getName()) : DBObjectNodeUtil.getSchemaName((DBObjectTypeNode)this.m_node);
        return retval;
    }

    public void init(DBObject obj, DBObjectProvider pro) {
    }

    public URL getURL() {
        return null;
    }

    public void setURL(URL url) {
    }

    @Override
    public Object getKey() {
        return ExplorerModelHelper.getKeyForObject(this.getObject(), this.getPropertyName());
    }

    @Override
    protected DBObject getObject() {
        DBObject retval = (DBObject)super.getObject();
        if (retval == null && this.m_node != null && (retval = this.m_node.getDBObject()) != null) {
            this.setObject(retval);
        }
        return retval;
    }

    @Override
    protected Icon createIcon() {
        Icon retval = this.m_node == null ? super.createIcon() : this.m_node.getIcon();
        return retval;
    }

    @Override
    protected String createLabel() {
        String retval = this.m_node == null ? super.createLabel() : this.m_node.getShortLabel();
        return retval;
    }

    @Override
    public boolean mayHaveChildren() {
        return true;
    }
}

