/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.HistoryComparator;
import oracle.dbtools.raptor.utils.HistoryItem;
import oracle.ide.Ide;

public class History {
    TreeSet past = new TreeSet(new HistoryComparator());
    private int maxHistorySize = 100;
    private String historyFileName = Ide.getProductHomeDirectory() + "history.ser";

    public History() {
        this.intialize();
    }

    public synchronized int getMaxHistorySize() {
        return this.maxHistorySize;
    }

    public synchronized void setMaxHistorySize(int n) {
        this.maxHistorySize = n;
    }

    public synchronized void update(HistoryItem historyItem) {
        if (!this.past.contains(historyItem)) {
            this.past.add(historyItem);
        }
        if (this.past.size() > this.getMaxHistorySize()) {
            Object object = this.findOldest(this.past);
            this.past.remove(object);
        }
        if (historyItem.getClass().toString().endsWith("SQLHistoryItem")) {
            this.serialize(historyItem);
        }
    }

    private Object findOldest(TreeSet treeSet) {
        Iterator iterator = treeSet.iterator();
        HistoryItem historyItem = null;
        Date date = null;
        HistoryItem historyItem2 = null;
        Date date2 = null;
        if (iterator != null) {
            historyItem = (HistoryItem)iterator.next();
            date = historyItem.getTimestamp();
        }
        while (iterator.hasNext()) {
            historyItem2 = (HistoryItem)iterator.next();
            date2 = historyItem2.getTimestamp();
            if (!date2.before(date)) continue;
            historyItem = historyItem2;
            date = date2;
        }
        return historyItem;
    }

    private void serialize(HistoryItem historyItem) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(this.historyFileName));
            objectOutputStream.writeObject(this.past);
            objectOutputStream.close();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void intialize() {
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.historyFileName);
            objectInputStream = new ObjectInputStream(fileInputStream);
            this.past = (TreeSet)objectInputStream.readObject();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            try {
                objectInputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public List asList() {
        return Arrays.asList(this.past.toArray());
    }

    public String[] getHistory() {
        String[] stringArray = new String[this.past.size()];
        int n = 0;
        for (HistoryItem historyItem : this.past) {
            stringArray[n++] = historyItem.getData().toString();
        }
        return stringArray;
    }
}

