/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.controls;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.controls.TableActionControlPanel;

public class GenericTableActionControl<T>
extends ActionControl {
    private TableActionControlPanel _ui;
    private JTable _table;
    private TableActionControlModel<T> _model;
    private int _visibleRows;
    private RowFactory<T> _rowFactory;
    private TablePanelController tablePanelController = new TablePanelController();
    private boolean showShuttleButtons = false;
    private int buttonMask = 0;

    public GenericTableActionControl(Class<? extends T> clazz, String string, List<String> list, List<Row<T>> list2, int n) {
        this(clazz, string, null, null, list, list2, n);
    }

    public GenericTableActionControl(Class<? extends T> clazz, String string, String string2, List<String> list, List<Row<T>> list2, int n) {
        this(clazz, string, string2, null, list, list2, n);
    }

    public GenericTableActionControl(Class<? extends T> clazz, String string, String string2, RowFactory<T> rowFactory, List<String> list, List<Row<T>> list2, int n) {
        this(clazz, string, string2, rowFactory, list, null, list2, n, false);
    }

    public GenericTableActionControl(Class<? extends T> clazz, String string, String string2, RowFactory<T> rowFactory, List<String> list, List<Class<? extends T>> list2, List<Row<T>> list3, int n, boolean bl) {
        super(string, string2);
        this._rowFactory = rowFactory;
        this._visibleRows = n;
        this.showShuttleButtons = bl;
        this._model = new TableActionControlModel<T>(clazz, list, list2, list3);
        this._ui = new TableActionControlPanel(this._model, this.tablePanelController, n);
        this.setSpringVertical(true);
        this.setFillVertical(true);
        this._ui.setName("tableActionControlUI");
        this._table = this._ui.getTable();
        this._table.setColumnSelectionAllowed(true);
        this._table.setRowSelectionAllowed(true);
        this._table.setSelectionMode(0);
        if (bl) {
            this.buttonMask = 60;
        }
        if (this._rowFactory != null) {
            this.buttonMask |= 3;
        }
        this._ui.setButtons(this.buttonMask);
    }

    public RowFactory<T> getRowFactory() {
        return this._rowFactory;
    }

    public void setRows(List<Row<T>> list) {
        this._model.setRows(list);
    }

    @Override
    public ActionControl.Value getValue() {
        ActionControl.Value value = new ActionControl.Value();
        List<String> list = this._model.getColumnNames();
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Row<T> row : this._model.getRows()) {
                arrayList.add(row.getValue(i) != null ? row.getValue(i).toString() : null);
            }
            value.addList(string, arrayList);
        }
        return value;
    }

    @Override
    public TableActionControlPanel getUI() {
        return this._ui;
    }

    @Override
    public void setEditable(boolean bl) {
        this._ui.setEnabled(bl);
    }

    @Override
    public void enableUI(boolean bl) {
        this.setEditable(bl);
    }

    public void setShowShuttleButtons(boolean bl) {
        this.showShuttleButtons = bl;
        this.buttonMask = bl ? (this.buttonMask |= 0x3C) : (this.buttonMask &= 0xFFFFFFC3);
        this._ui.setButtons(this.buttonMask);
    }

    public boolean isShowShuttleButtons() {
        return this.showShuttleButtons;
    }

    public int getButtonMask() {
        return this.buttonMask;
    }

    public void setTitle(String string) {
        this._ui.setTitle(string);
    }

    public void moveSelectionToFirst() {
        Row<T> row = null;
        int n = this._table.getSelectedRow();
        int n2 = this._table.getSelectedColumn();
        if (n > 0) {
            List<Row<T>> list = this._model.getRows();
            row = list.get(n);
            this._model.removeRow(row);
            this._model.addRow(0, row);
            this._table.changeSelection(0, n2, false, false);
        }
    }

    public void moveSelectionToPrevious() {
        Row<T> row = null;
        int n = this._table.getSelectedRow();
        int n2 = this._table.getSelectedColumn();
        if (n > 0) {
            List<Row<T>> list = this._model.getRows();
            row = list.get(n);
            this._model.removeRow(row);
            this._model.addRow(n - 1, row);
            this._table.changeSelection(n - 1, n2, false, false);
        }
    }

    public void moveSelectionToNext() {
        Row<T> row = null;
        int n = this._table.getSelectedRow();
        int n2 = this._table.getSelectedColumn();
        List<Row<T>> list = this._model.getRows();
        if (n >= 0 && n < list.size() - 1) {
            row = list.get(n);
            this._model.removeRow(row);
            this._model.addRow(n + 1, row);
            this._table.changeSelection(n + 1, n2, false, false);
        }
    }

    public void moveSelectionToLast() {
        Row<T> row = null;
        int n = this._table.getSelectedRow();
        int n2 = this._table.getSelectedColumn();
        List<Row<T>> list = this._model.getRows();
        if (n >= 0 && n < list.size() - 1) {
            row = list.get(n);
            this._model.removeRow(row);
            this._model.addRow(list.size(), row);
            this._table.changeSelection(list.size() - 1, n2, false, false);
        }
    }

    public static class TableActionControlModel<T>
    extends AbstractTableModel {
        private final Class<? extends T> _baseClass;
        private List<String> _columnNames;
        private List<Class<? extends T>> _columnClasses;
        private transient ArrayList<Row<T>> _rows;
        private CellFormat _cellFormat;

        public TableActionControlModel(Class<? extends T> clazz, List<String> list, List<Class<? extends T>> list2, List<Row<T>> list3) {
            this._baseClass = clazz;
            this._columnNames = list;
            this._rows = new ArrayList<Row<T>>(list3);
            this._columnClasses = new ArrayList<Class<? extends T>>(this._columnNames.size());
            int n = 0;
            if (list2 != null) {
                for (int i = 0; n < this._columnNames.size() && i < list2.size(); ++n, ++i) {
                    this._columnClasses.add(list2.get(i));
                }
            }
            while (n < this._columnNames.size()) {
                this._columnClasses.add(this._baseClass);
                ++n;
            }
        }

        public TableActionControlModel(Class<? extends T> clazz, List<String> list, List<Row<T>> list2) {
            this(clazz, list, null, list2);
            this._columnNames = list;
            this._rows = new ArrayList<Row<T>>(list2);
        }

        public void setCellFormat(CellFormat cellFormat) {
            this._cellFormat = cellFormat;
        }

        public List<String> getColumnNames() {
            return this._columnNames;
        }

        public List<Row<T>> getRows() {
            return this._rows;
        }

        public void addRow(Row<T> row) {
            this._rows.add(row);
            this.fireTableDataChanged();
        }

        public void addRow(int n, Row<T> row) {
            this._rows.add(n, row);
            this.fireTableDataChanged();
        }

        public void removeRow(Row<T> row) {
            this._rows.remove(row);
            this.fireTableDataChanged();
        }

        public void removeRow(int n) {
            this._rows.remove(n);
            this.fireTableDataChanged();
        }

        public void setRows(List<Row<T>> list) {
            this._rows = new ArrayList<Row<T>>(list);
            this.fireTableStructureChanged();
        }

        public Class<? extends T> getColumnClass(int n) {
            return this._columnClasses.get(n);
        }

        @Override
        public String getColumnName(int n) {
            return this._columnNames.get(n);
        }

        @Override
        public int getColumnCount() {
            return this._columnNames.size();
        }

        @Override
        public int getRowCount() {
            return this._rows.size();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return this._rows.get(n).isValueEditable(n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (this._cellFormat != null) {
                object = this._cellFormat.format(object, n2);
            }
            this._rows.get(n).setValue(n2, this.getColumnClass(n2).cast(object));
            this.fireTableCellUpdated(n, n2);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this._rows.get(n).getValue(n2);
        }
    }

    protected class TablePanelController
    implements TableActionControlPanel.TableActionControlPanelController {
        protected TablePanelController() {
        }

        @Override
        public void addButtonPressed(ActionEvent actionEvent) {
            Row row = null;
            int n = GenericTableActionControl.this._table.getSelectedRow();
            if (n >= 0) {
                row = GenericTableActionControl.this._model.getRows().get(n);
            }
            Row row2 = GenericTableActionControl.this._rowFactory.createRow(n, GenericTableActionControl.this._model);
            if (n >= 0) {
                GenericTableActionControl.this._model.addRow(n + 1, row2);
            } else {
                GenericTableActionControl.this._model.addRow(row2);
            }
        }

        @Override
        public void removeButtonPressed(ActionEvent actionEvent) {
            int n = GenericTableActionControl.this._table.getSelectedRow();
            if (n >= 0) {
                GenericTableActionControl.this._model.removeRow(n);
            }
        }

        @Override
        public void firstButtonPressed(ActionEvent actionEvent) {
            GenericTableActionControl.this.moveSelectionToFirst();
        }

        @Override
        public void previousButtonPressed(ActionEvent actionEvent) {
            GenericTableActionControl.this.moveSelectionToPrevious();
        }

        @Override
        public void nextButtonPressed(ActionEvent actionEvent) {
            GenericTableActionControl.this.moveSelectionToNext();
        }

        @Override
        public void lastButtonPressed(ActionEvent actionEvent) {
            GenericTableActionControl.this.moveSelectionToLast();
        }
    }

    public static interface CellFormat<T> {
        public T format(Object var1, int var2);
    }

    public static interface Row<T> {
        public T getValue(int var1);

        public boolean isValueEditable(int var1);

        public void setValue(int var1, T var2);
    }

    public static interface RowFactory<T> {
        public Row<T> createRow(int var1, TableActionControlModel<T> var2);
    }
}

