/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.actions;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.sql.Connection;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.db.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.db.xml.AbstractItemInstance;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.raptor.ui.actions.ActionContext;
import oracle.dbtools.raptor.ui.actions.SQLScriptProcessor;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.actions.ScriptProcessorContext;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.Debug;
import oracle.dbtools.util.Indenter;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.util.IdeUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;

public abstract class AbstractActionDialog
extends AbstractMenuAction
implements LayoutControl {
    private String _args;
    private BasicEditorPane _scriptEditor;
    private CustomTabbedPane _tabbed;
    private boolean _scriptEditingEnabled = true;
    private ScriptProcessor _scriptProcessor;
    private static final Indenter INDENTER = new Indenter();
    private static final String DFT_SYMBOL = "abstract-action-dialog";
    public static final int MAX_INITIAL_WIDTH = 1024;
    public static final int MAX_INITIAL_HEIGHT = 768;

    protected String getConnectionName(DBObject dBObject) {
        return dBObject.getConnectionName();
    }

    protected String getConnectionName() {
        return this.getConnectionName(this.getDBObject());
    }

    protected Connection getConnection(String string) throws DBException {
        return Connections.getInstance().getConnection(string);
    }

    protected Properties getConnectionInfo(String string) {
        return Connections.getInstance().getConnectionInfo(string);
    }

    protected DialogType getDialogType() {
        return DialogType.TASK;
    }

    protected void doAction(ActionContext actionContext) throws Exception {
    }

    @Override
    public void launch() {
        final long l = System.currentTimeMillis();
        Ide.getWaitCursor().show(1000);
        DialogType dialogType = this.getDialogType();
        try {
            final String string = this.getConnectionName();
            final Connection connection = this.getConnection(string);
            final Properties properties = this.getConnectionInfo(string);
            JComponent jComponent = this.createPanel(connection);
            if (jComponent == null) {
                return;
            }
            final ScriptProcessor scriptProcessor = this.getScriptProcessor();
            int n = 0;
            n = dialogType != DialogType.VIEW ? 10 : 16;
            String string2 = this.getHelpId();
            if (string2 != null && jComponent instanceof JComponent) {
                n |= 4;
                HelpSystem.getHelpSystem().registerTopic((JComponent)((JPanel)jComponent), string2);
            }
            final JEWTDialog jEWTDialog = this.createJEWTDialog(jComponent, this.getTitle(), n);
            if (dialogType == DialogType.ACTION) {
                jEWTDialog.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            AbstractActionDialog.this.doAction(new ScriptProcessorContextImpl((Component)jEWTDialog, connection, string, properties, null));
                        }
                        catch (Exception exception) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        }
                        jEWTDialog.closeDialog(false);
                    }
                });
            } else if (dialogType == DialogType.TASK) {
                jEWTDialog.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RaptorTask<Void> raptorTask = new RaptorTask<Void>(UiResources.getString("PERFORM_ACTION"), true, IRaptorTaskRunMode.MODAL){

                            protected Void doWork() throws TaskException {
                                if (AbstractActionDialog.this.isCloseOnError()) {
                                    jEWTDialog.closeDialog(false);
                                } else {
                                    jEWTDialog.setEnabled(false);
                                    jEWTDialog.setModalityType(Dialog.ModalityType.MODELESS);
                                }
                                try {
                                    if (AbstractActionDialog.this.allowApplyScript()) {
                                        scriptProcessor.processScript(new ScriptProcessorContextImpl((Component)jEWTDialog, connection, string, properties, AbstractActionDialog.this.getScriptForProcessing()));
                                        AbstractActionDialog.this.onCommandComplete();
                                        String string = scriptProcessor.getSuccessMessage();
                                        this.setMessage(string);
                                    }
                                    if (!AbstractActionDialog.this.isCloseOnError()) {
                                        jEWTDialog.closeDialog(false);
                                    }
                                }
                                catch (Exception exception) {
                                    String string = scriptProcessor.getFailureMessage(exception);
                                    this.setMessage(string);
                                    throw new TaskException((Throwable)exception);
                                }
                                return null;
                            }
                        };
                        raptorTask.setCancellable(scriptProcessor.isCancellable());
                        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                            public void taskScheduled(RaptorTaskEvent raptorTaskEvent) {
                            }

                            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                                Runnable runnable = new Runnable(){

                                    @Override
                                    public void run() {
                                        scriptProcessor.cancel();
                                        jEWTDialog.closeDialog(true);
                                    }
                                };
                                SwingUtilities.invokeLater(runnable);
                            }

                            public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                                Runnable runnable = new Runnable(){

                                    @Override
                                    public void run() {
                                        String string;
                                        if (!AbstractActionDialog.this.isCloseOnError()) {
                                            jEWTDialog.setEnabled(true);
                                            jEWTDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
                                            jEWTDialog.setVisible(true);
                                        }
                                        if ((string = raptorTaskEvent.getTaskDescriptor().getMessage()) != null) {
                                            MessageDialog.error((Component)jEWTDialog, (Object)raptorTaskEvent.getTaskDescriptor().getMessage(), (String)UiResources.getString("ERROR_TITLE"), null);
                                        }
                                    }
                                };
                                SwingUtilities.invokeLater(runnable);
                            }

                            public void taskFinished(final RaptorTaskEvent raptorTaskEvent) {
                                Runnable runnable = new Runnable(){

                                    @Override
                                    public void run() {
                                        String string = raptorTaskEvent.getTaskDescriptor().getMessage();
                                        if (string != null) {
                                            MessageDialog.information((Component)Ide.getMainWindow(), (Object)raptorTaskEvent.getTaskDescriptor().getMessage(), (String)UiResources.getString("SUCCESS_TITLE"), null);
                                        }
                                    }
                                };
                                SwingUtilities.invokeLater(runnable);
                            }
                        });
                        DBObject dBObject = AbstractActionDialog.this.getDBObject();
                        ObjectAction objectAction = AbstractActionDialog.this.getObjectAction();
                        if (null == objectAction) {
                            objectAction = new ObjectAction();
                            objectAction.setReloadParent(true);
                        }
                        ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback(objectAction, dBObject);
                        IRaptorTaskListener iRaptorTaskListener = ObjectActionController.getRaptorTaskListener(objectActionPostProcess);
                        raptorTask.getDescriptor().addListener(iRaptorTaskListener);
                        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
                    }
                });
            }
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
            jEWTDialog.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    jEWTDialog.removeWindowListener((WindowListener)this);
                    Ide.getWaitCursor().hide();
                    long l2 = System.currentTimeMillis() - l;
                    String string = "\"" + jEWTDialog.getTitle() + "\" Dialog launch time = " + l2 + "ms";
                    oracle.dbtools.util.Logger.info(this.getClass(), (String)string);
                    if (Debug.DEBUG) {
                        AbstractActionDialog.this.logSizes((Component)jEWTDialog);
                    }
                }
            });
            this.setBlockOACRefresh(true);
            this.initializeValues(jEWTDialog);
            jEWTDialog.setVisible(true);
        }
        catch (DBException dBException) {
            Ide.getWaitCursor().hide();
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)(UiResources.getString("ACCESS_ERROR") + "\n- " + dBException.getLocalizedMessage()), (String)UiResources.getString("ERROR_TITLE"), null);
        }
        catch (Exception exception) {
            Ide.getWaitCursor().hide();
            this.setDBObject(null);
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void invoke(DBObject dBObject) {
        final long l = System.currentTimeMillis();
        Ide.getWaitCursor().show(1000);
        try {
            String string = this.getConnectionName();
            Connection connection = this.getConnection(string);
            Component component = this.createSimplePanel(connection);
            String string2 = this.getHelpId();
            int n = 10;
            if (string2 != null && component instanceof JComponent) {
                n |= 4;
                HelpSystem.getHelpSystem().registerTopic((JComponent)((JPanel)component), string2);
            }
            final JEWTDialog jEWTDialog = this.createJEWTDialog(component, this.getTitle(), n);
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
            jEWTDialog.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    System.out.println("dlg.ActionEvent.getActionCommand()=" + actionEvent.getActionCommand());
                    AbstractActionDialog.this.processDialogOnApply(jEWTDialog);
                    jEWTDialog.closeDialog(true);
                }
            });
            jEWTDialog.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    jEWTDialog.removeWindowListener((WindowListener)this);
                    Ide.getWaitCursor().hide();
                    long l2 = System.currentTimeMillis() - l;
                    String string = "\"" + jEWTDialog.getTitle() + "\" Dialog launch time = " + l2 + "ms";
                    oracle.dbtools.util.Logger.info(this.getClass(), (String)string);
                    if (Debug.DEBUG) {
                        AbstractActionDialog.this.logSizes((Component)jEWTDialog);
                    }
                }
            });
            this.setBlockOACRefresh(true);
            this.initializeValues(jEWTDialog);
            jEWTDialog.setVisible(true);
        }
        catch (DBException dBException) {
            Ide.getWaitCursor().hide();
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)(UiResources.getString("ACCESS_ERROR") + "\n- " + dBException.getLocalizedMessage()), (String)UiResources.getString("ERROR_TITLE"), null);
        }
        catch (Exception exception) {
            Ide.getWaitCursor().hide();
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void logSizes(Component component) {
        StringBuilder stringBuilder = new StringBuilder();
        INDENTER.setIndentStrings("|--", "+--");
        AbstractActionDialog.captureSizes(stringBuilder, component, 0);
        oracle.dbtools.util.Logger.info(this.getClass(), (String)stringBuilder.toString());
    }

    private static void captureSizes(StringBuilder stringBuilder, Component component, int n) {
        String string = INDENTER.getIndent(n);
        stringBuilder.append(string).append(component.getClass().getSimpleName()).append('[').append("name=").append(component.getName()).append(",width=").append(component.getWidth()).append(",height").append(component.getHeight());
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            ++n;
            if (componentArray != null && componentArray.length > 0) {
                stringBuilder.append('\n');
                for (Component component2 : componentArray) {
                    AbstractActionDialog.captureSizes(stringBuilder, component2, n);
                }
                stringBuilder.append(string);
            }
        }
        stringBuilder.append("]\n");
    }

    private JEWTDialog createJEWTDialog(Component component, String string, int n) {
        DialogHeader dialogHeader;
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        JEWTDialog jEWTDialog = ideMainWindow instanceof Dialog ? new JEWTDialog((Dialog)ideMainWindow, string, n) : new JEWTDialog((Frame)ideMainWindow, string, n);
        jEWTDialog.setName(DFT_SYMBOL);
        jEWTDialog.setContent(component);
        jEWTDialog.setResizable(true);
        if (component instanceof JComponent && (dialogHeader = (DialogHeader)((JComponent)component).getClientProperty("dialogHeader")) != null) {
            jEWTDialog.setDialogHeader((Component)dialogHeader);
        }
        jEWTDialog.setMaximumInitialSize(1024, 768);
        jEWTDialog.pack();
        return jEWTDialog;
    }

    public void setScriptEditingEnabled(boolean bl) {
        this._scriptEditingEnabled = bl;
        if (this._scriptEditor != null) {
            this._scriptEditor.setEditable(this._scriptEditingEnabled);
        }
    }

    public boolean isScriptEditingEnabled() {
        return this._scriptEditingEnabled;
    }

    @Override
    public void setArgs(String string) {
        this._args = string;
    }

    public String getArgs() {
        return this._args;
    }

    public CustomTabbedPane getTabbedPane() {
        return this._tabbed;
    }

    public String getProperty(String string) {
        AbstractItemInstance abstractItemInstance;
        Object object;
        ObjectNode objectNode;
        DBObjectInstance dBObjectInstance;
        String string2 = null;
        Node node = this.getDBObject().getNode();
        if (node instanceof ObjectNode && (dBObjectInstance = (objectNode = (ObjectNode)node).getNodeInstance()) instanceof AbstractItemInstance && (object = (abstractItemInstance = (AbstractItemInstance)((Object)dBObjectInstance)).getProperty(string)) instanceof String) {
            string2 = (String)object;
        }
        return string2;
    }

    public String getDBObjectSchemaName() {
        return DBURLFormatHelper.getSchema(this.getDBObject().getURL());
    }

    public String getDBObjectName() {
        return DBURLFormatHelper.getName(this.getDBObject().getURL());
    }

    public String getDbObjectType() {
        return DBURLFormatHelper.getBaseType(this.getDBObject().getURL());
    }

    public String getDBObjectChildName() {
        return DBURLFormatHelper.getChildName(this.getDBObject().getURL());
    }

    protected void showErrorDialog(String string) {
        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)UiResources.getString("ERROR_TITLE"), null);
    }

    protected String getObjectName() {
        String string = this.getDBObjectChildName();
        if (string == null) {
            string = this.getDBObjectName();
        }
        return string;
    }

    protected String getQuery(Connection connection, String string) {
        return Utils.getQuery(this.getClass(), connection, string);
    }

    protected abstract JComponent createEditPane(Connection var1);

    protected boolean shouldScrollEditPane() {
        return true;
    }

    protected abstract String getEditPaneTitle();

    protected JComponent[] createAdditionalPanes(Connection connection) {
        return null;
    }

    protected String[] getAdditionalPaneTitles() {
        return null;
    }

    protected boolean isCloseOnError() {
        return false;
    }

    protected String getHelpId() {
        return null;
    }

    protected abstract String getTitle();

    protected abstract String getScript();

    protected boolean allowApplyScript() {
        return true;
    }

    protected ScriptProcessor createScriptProcessor() {
        return new SQLScriptProcessor();
    }

    protected void onCommandComplete() {
    }

    protected String getScriptProcessorParameter(String string) {
        return null;
    }

    private String getScriptForProcessing() {
        String string = null;
        if (this._scriptEditor != null) {
            int n = this._tabbed.getNumberOfTabs();
            string = this._tabbed.getSelectedIndex() == n - 1 ? this._scriptEditor.getText() : this.getScript();
        }
        return string;
    }

    private JComponent createPanel(Connection connection) {
        Object object;
        this._tabbed = new CustomTabbedPane();
        JComponent jComponent = this.createEditPane(connection);
        if (jComponent == null) {
            return null;
        }
        this._tabbed.addTab(null, this.getEditPaneTitle(), (Component)this.makeTabPanel(jComponent, this.shouldScrollEditPane()));
        JComponent[] jComponentArray = this.createAdditionalPanes(connection);
        if (jComponentArray != null) {
            object = this.getAdditionalPaneTitles();
            for (int i = 0; i < jComponentArray.length; ++i) {
                this._tabbed.addTab(null, object[i], (Component)this.makeTabPanel(jComponentArray[i]));
            }
        }
        if ((object = this.createScriptPane()) != null) {
            this._tabbed.addTab(null, this.getScriptProcessor().getScriptEditorTabName(), (Component)object);
            this._tabbed.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (AbstractActionDialog.this._tabbed.getSelectedIndex() == AbstractActionDialog.this._tabbed.getNumberOfTabs() - 1) {
                        SwingUtilities.invokeLater(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                String string = AbstractActionDialog.this.getScript();
                                AbstractActionDialog.this._scriptEditor.setEditable(true);
                                try {
                                    AbstractActionDialog.this._scriptEditor.setText(string);
                                    JScrollPane jScrollPane = (JScrollPane)AbstractActionDialog.this._scriptEditor.getParent().getParent();
                                    JViewport jViewport = jScrollPane.getViewport();
                                    jScrollPane.setViewport(null);
                                    jScrollPane.setViewport(jViewport);
                                }
                                finally {
                                    AbstractActionDialog.this._scriptEditor.setEditable(AbstractActionDialog.this._scriptEditingEnabled);
                                }
                            }
                        });
                    }
                }
            });
        }
        this.setComponentPreferredSize((Component)this._tabbed);
        return this._tabbed;
    }

    private Component createSimplePanel(Connection connection) {
        JComponent jComponent = this.createEditPane(connection);
        if (jComponent != null) {
            this.makeTabPanel(jComponent);
        }
        this.setComponentPreferredSize(jComponent);
        return jComponent;
    }

    private JComponent makeTabPanel(Component component) {
        return this.makeTabPanel(component, true);
    }

    private JComponent makeTabPanel(Component component, boolean bl) {
        this.setComponentPreferredSize(component);
        JComponent jComponent = new JPanel(new GridBagLayout());
        jComponent.add(component, LayoutControl.GBC.TAB_PANEL);
        if (bl) {
            jComponent = new JScrollPane(jComponent);
        } else {
            Border border = new JScrollPane().getBorder();
            jComponent.setBorder(border);
        }
        return jComponent;
    }

    protected ScriptProcessor getScriptProcessor() {
        if (this.getDialogType() == DialogType.TASK && this._scriptProcessor == null) {
            this._scriptProcessor = this.createScriptProcessor();
        }
        return this._scriptProcessor;
    }

    private JScrollPane createScriptPane() {
        JScrollPane jScrollPane = null;
        ScriptProcessor scriptProcessor = this.getScriptProcessor();
        if (scriptProcessor != null) {
            this._scriptEditor = this.getScriptProcessor().getEditorPane();
            if (this._scriptEditor != null) {
                this._scriptEditor.setEditable(this._scriptEditingEnabled);
                jScrollPane = new JScrollPane((Component)this._scriptEditor, 22, 32);
            }
        }
        return jScrollPane;
    }

    private void setComponentPreferredSize(Component component) {
        Dimension dimension = component.getPreferredSize();
        if (dimension.width < 375) {
            dimension.width = 375;
        }
        if (dimension.height < 275) {
            dimension.height = 275;
        }
        component.setPreferredSize(dimension);
        component.setSize(component.getPreferredSize());
    }

    protected void initializeValues(JEWTDialog jEWTDialog) {
    }

    protected void processDialogOnApply(JEWTDialog jEWTDialog) {
    }

    class ScriptProcessorContextImpl
    implements ScriptProcessorContext {
        private Component _parent;
        private Connection _connection;
        private String _cName;
        private Properties _connectionProperties;
        private String _script;

        ScriptProcessorContextImpl(Component component, Connection connection, String string, Properties properties, String string2) {
            this._parent = component;
            this._connection = connection;
            this._cName = string;
            this._connectionProperties = properties;
            this._script = string2;
        }

        @Override
        public Component getParent() {
            return this._parent;
        }

        @Override
        public String getConnectionName() {
            return this._cName;
        }

        @Override
        public Connection getConnection() {
            return this._connection;
        }

        @Override
        public Properties getConnectionProperties() {
            return this._connectionProperties;
        }

        @Override
        public String getActionTitle() {
            return AbstractActionDialog.this.getTitle();
        }

        @Override
        public String getScript() {
            return this._script;
        }

        @Override
        public String getParameter(String string) {
            return AbstractActionDialog.this.getScriptProcessorParameter(string);
        }
    }

    protected static enum DialogType {
        VIEW,
        ACTION,
        TASK;

    }
}

