/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.structure;

import java.awt.Component;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.EquippedWithParser;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.dbtools.raptor.plsql.structure.OutlinePanel;
import oracle.dbtools.raptor.plsql.structure.OutlineWindow;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.DockableView;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.view.View;

public class OutlineMenu
implements Controller,
ContextMenuListener {
    public static String QUICK_OUTLINE = Messages.getString("QuickOutline");
    private static int cmdOutline = Ide.findOrCreateCmdID((String)"oracle.dbtools.raptor.plsql.structure.OUTLINE");
    private IdeAction actionOutline = null;
    private static OutlineMenu _instance;

    public static OutlineMenu getInstance() {
        if (_instance == null) {
            _instance = new OutlineMenu();
        }
        return _instance;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        OutlineWindow outlineWindow = OutlineWindow.getInstance();
        DockUtil.showDockableWindow((DockableView)outlineWindow);
        View view = context.getView();
        ((OutlinePanel)outlineWindow.getGUI()).buildNewOutlineTree(view);
        return true;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context;
        Context context2 = context = contextMenu == null ? null : contextMenu.getContext();
        if (context == null) {
            return;
        }
        Node node = context.getNode();
        View view = context.getView();
        if (node instanceof PlSqlNode || node instanceof TextNode && view instanceof EquippedWithParser) {
            String string = node.getShortLabel();
            if (string != null && string.toLowerCase().startsWith("anon_block")) {
                return;
            }
            this.createAction();
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.actionOutline));
        }
    }

    private void createAction() {
        if (this.actionOutline == null) {
            this.actionOutline = IdeAction.get((int)cmdOutline, null, (String)QUICK_OUTLINE, null, null, null, null, (boolean)true);
            this.actionOutline.addController((Controller)this);
        }
    }

    public static void init() {
        if (!RaptorExtensionConstants.isStandAlone()) {
            return;
        }
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)OutlineMenu.getInstance());
    }
}

