/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.awt.Component;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.sqldialog.IObjectActionListener;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.dbtools.raptor.editors.DBEditorController;
import oracle.dbtools.raptor.editors.IStatusMessageProvider;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.oviewer.Messages;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.AsynchronousEditor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.UpdateMessage;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.javatools.db.Database;
import oracle.javatools.icons.OracleIcons;

public abstract class AsynchronousViewerEditor
extends AsynchronousEditor
implements Controller,
IStatusMessageProvider {
    private Component _panel;
    protected Toolbar _toolbar;
    private boolean _visible;
    private boolean _inSync;
    private boolean _pinEnabled = true;
    private IdeAction pinAction;
    private IdeAction _toolbarAction;
    private boolean _initActions = false;
    private String _lastStatusbarMessage = "";
    private ToggleToolButton _pinToggle;
    static final int PIN_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"VE_Pin_Editor");
    protected ViewerObjectActionListener m_actionListener = new ViewerObjectActionListener();
    private LoaderTaskManager m_taskManager = new LoaderTaskManager();
    private boolean m_contentModelLoaded;
    private NodeListener m_nl = new NodeListener(){

        public void nodeWillClose(NodeEvent nodeEvent) {
            AsynchronousViewerEditor.this.cleanUp();
            nodeEvent.getNode().removeNodeListener((NodeListener)this);
        }
    };

    protected abstract JComponent createViewerUI();

    protected abstract void updateContent(boolean var1);

    protected abstract void cleanUp();

    public abstract Object getPrintable();

    public AsynchronousViewerEditor() {
        this.pinAction = IdeAction.findOrCreate((int)PIN_EDITOR_CMD_ID, null, (String)IdeArb.getString((int)28), null, null, (Icon)OracleIcons.getIcon((String)"pin.png"), null, (boolean)true).newLocalAction((View)this);
        this.pinAction.addController((Controller)this);
        Log.status((String)"");
        this.addViewListener(new ViewListener(){

            public void viewActivated(ViewEvent viewEvent) {
            }

            public void viewClosed(ViewEvent viewEvent) {
            }

            public void viewDeactivated(ViewEvent viewEvent) {
                AsynchronousViewerEditor.this._lastStatusbarMessage = Ide.getStatusBar().getText();
            }
        });
        ObjectActionController.addListener(this.m_actionListener);
    }

    protected void openImpl(boolean bl) {
        if (bl) {
            // empty if block
        }
    }

    protected Component getGUIComponent() {
        return this._panel;
    }

    protected final void getEditorContent(Context context) {
        try {
            this.getEditorContentImpl(context, this.m_taskManager);
        }
        catch (Throwable throwable) {
            Logger.severe(this.getClass(), (Throwable)throwable);
            this.m_taskManager.informFailed();
        }
    }

    protected void getEditorContentImpl(Context context, LoaderTaskManager loaderTaskManager) {
        this.setGUIComponent(this.oldGetGUI());
        this.updateContent(true);
        loaderTaskManager.informFinished();
    }

    protected void setGUIComponent(Component component) {
        this._panel = component;
    }

    protected boolean isContentModelLoaded() {
        return this.m_contentModelLoaded;
    }

    protected void setContentModelLoaded(boolean bl) {
        this.m_contentModelLoaded = bl;
    }

    protected void doSetContext(Context context) {
    }

    protected void closeImpl(boolean bl) {
        this.m_taskManager.cancel();
        this.oldClose();
        super.closeImpl(bl);
    }

    protected void shownImpl(boolean bl) {
        if (bl) {
            this.oldEditorShown();
        } else {
            this.m_taskManager.resume();
        }
        super.shownImpl(bl);
    }

    protected void hiddenImpl(boolean bl) {
        if (bl) {
            this.oldEditorHidden();
        } else {
            this.m_taskManager.pause();
        }
        super.hiddenImpl(bl);
    }

    public void oldOpen() {
        this.getGUI();
    }

    public Component oldGetGUI() {
        JComponent jComponent = (JComponent)this.getGUIComponent();
        if (jComponent == null) {
            jComponent = this.createViewerUI();
            UIUtils.addIdeKeyBindings((JComponent)jComponent, (int)1, (String)"oracle/dbtools/raptor/oviewer/base/accelerators.xml");
            UIUtils.setupAccelerators((Toolbar)this.getToolbar());
        }
        this.checkPin();
        return jComponent;
    }

    public void checkPin() {
        AsynchronousViewerEditor.invokeLaterAfterRepaint((Runnable)new Runnable(){

            @Override
            public void run() {
                AsynchronousViewerEditor.this.pinAction.setState(((ViewerNode)AsynchronousViewerEditor.this.getContext().getNode()).getPinned());
                if (!((ViewerNode)AsynchronousViewerEditor.this.getContext().getNode()).getPinned()) {
                    AsynchronousViewerEditor.this._pinToggle.setIcon(OracleIcons.getIcon((String)"pin.png"));
                } else {
                    AsynchronousViewerEditor.this._pinToggle.setIcon(RaptorImagesArb.getIcon("PINNED"));
                }
            }
        });
    }

    public void addMenuButton() {
        if (this._toolbarAction == null) {
            JPopupMenu jPopupMenu;
            this._toolbarAction = XMLBasedObjectAction.getInstance().getIdeAction().newLocalAction((View)this);
            if (this.getContext().getNode() instanceof ViewerNode && (jPopupMenu = XMLBasedObjectAction.getInstance().getMenu(((ViewerNode)this.getContext().getNode()).getDBObject())).getComponentCount() > 0) {
                ToolButton toolButton = ((Toolbar)this.getFixedTopMargin()).add((ToggleAction)this._toolbarAction);
                toolButton.setName(this._toolbarAction.getValue("Name").toString());
                toolButton.setText(Messages.getString("ViewerEditor.3"));
                toolButton.setIcon(OracleIcons.getIcon((String)"extras/dropdown.png"));
                toolButton.setToolTipText(Messages.getString("ViewerEditor.4"));
                this._toolbarAction.putValue("BUTTON", (Object)toolButton);
            }
        }
    }

    public void update(Object object, final UpdateMessage updateMessage) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateImpl(updateMessage);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AsynchronousViewerEditor.this.updateImpl(updateMessage);
                }
            });
        }
    }

    void updateImpl(UpdateMessage updateMessage) {
        int n = updateMessage.getMessageID();
        if (n == ViewerNode.RELATION_NODE_CHANGED_MESSAGE_ID) {
            this.whenDbNodeChanged();
        } else if (n == ViewerNode.RELATION_NODE_MODIFIED_MESSAGE_ID || n == UpdateMessage.OBJECT_RELOADED) {
            if (this.isVisible()) {
                this.updateContent(true);
            } else {
                this._inSync = false;
            }
        }
    }

    public Component getFixedTopMargin() {
        return this.getToolbar();
    }

    public Toolbar getToolbar() {
        if (this._toolbar == null) {
            this._toolbar = new Toolbar();
            if (this._pinEnabled) {
                this._pinToggle = this._toolbar.addToggleButton((ToggleAction)this.pinAction);
                this._pinToggle.setName(IdeArb.getString((int)28));
            }
        }
        return this._toolbar;
    }

    public void oldEditorShown() {
        this.whenVisibilityChanges(true);
    }

    public void oldEditorHidden() {
        this.whenVisibilityChanges(false);
    }

    public boolean isVisible() {
        return this._visible;
    }

    private void whenVisibilityChanges(boolean bl) {
        this._visible = bl;
        if (this._visible) {
            if (!this._inSync) {
                this.whenDbNodeChanged();
            }
            if (this._pinEnabled) {
                ViewerNode viewerNode = (ViewerNode)this.getContext().getNode();
                this.pinAction.setState(viewerNode.getPinned());
                if (!viewerNode.getPinned()) {
                    this._pinToggle.setIcon(OracleIcons.getIcon((String)"pin.png"));
                } else {
                    this._pinToggle.setIcon(RaptorImagesArb.getIcon("PINNED"));
                }
            }
            if (!this._initActions) {
                this.addMenuButton();
                this._initActions = true;
            }
            AsynchronousViewerEditor.updateToolbarActions((Toolbar)this._toolbar);
        }
    }

    protected void whenDbNodeChanged() {
        Context context = this.getContext();
        Node node = context.getNode();
        if (this.isVisible() && node instanceof ViewerNode) {
            node.addNodeListener(this.m_nl);
            ViewerNode viewerNode = this.getViewerNode();
            Node node2 = viewerNode.getBaseNode();
            context.setSelection(new Element[]{node2});
            this.addDbObjectListener();
            this.updateContent(!this._inSync);
            this._inSync = true;
            Database database = ((ViewerNode)node).getDatabase();
            if (database != null) {
                context.setProperty("Connections.db_name", (Object)Connections.getInstance().getConnectionName(database));
            }
        } else {
            this._inSync = false;
        }
    }

    public ViewerNode getViewerNode() {
        return this.getViewerNode(this.getContext());
    }

    private ViewerNode getViewerNode(Context context) {
        if (context.getNode() instanceof ViewerNode) {
            return (ViewerNode)context.getNode();
        }
        return null;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == PIN_EDITOR_CMD_ID) {
            ideAction.setEnabled(true);
            if (context.getNode() instanceof ViewerNode) {
                this.checkPin();
            }
            return true;
        }
        return false;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == PIN_EDITOR_CMD_ID && this._pinEnabled) {
            ViewerNode viewerNode;
            viewerNode.setPinned(!(viewerNode = (ViewerNode)context.getNode()).getPinned());
            if (!viewerNode.getPinned()) {
                this._pinToggle.setIcon(OracleIcons.getIcon((String)"pin.png"));
            } else {
                this._pinToggle.setIcon(RaptorImagesArb.getIcon("PINNED"));
            }
            View.updateToolbarActions((Toolbar)context.getView().getToolbar());
            return true;
        }
        return false;
    }

    public boolean isPinEnabled() {
        return this._pinEnabled;
    }

    public void setPinEnabled(boolean bl) {
        this._pinEnabled = bl;
    }

    public void oldClose() {
        ObjectActionController.removeListener(this.m_actionListener);
        this.cleanUp();
    }

    public Controller getController() {
        return DBEditorController.getInstance();
    }

    @Override
    public String getStatusMessage() {
        return this._lastStatusbarMessage;
    }

    protected void addDbObjectListener() {
        DBObject dBObject;
        boolean bl;
        ViewerNode viewerNode = this.getViewerNode();
        if (viewerNode == null || !(bl = Connections.getInstance().isOracle(Connections.getInstance().getConnectionName(viewerNode.getDatabase()))) || (dBObject = new DBObject((Element)viewerNode)) != null) {
            // empty if block
        }
    }

    protected void switchEditorGUI(Component component) {
        super.switchEditorGUI(component);
        EditorManager.getEditorManager().refreshEditorUI((Editor)this);
        this.firePropertyChangeEvent("horizontal_block_increment", null, null);
        this.firePropertyChangeEvent("horizontal_unit_increment", null, null);
        this.firePropertyChangeEvent("vertical_block_increment", null, null);
        this.firePropertyChangeEvent("vertical_unit_increment", null, null);
    }

    protected void activateImpl(boolean bl) {
    }

    private class ViewerObjectActionListener
    implements IObjectActionListener {
        private ViewerObjectActionListener() {
        }

        @Override
        public void notify(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
        }

        @Override
        public void reload(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
        }

        @Override
        public void reloadParent(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
        }

        @Override
        public void removedFromParent(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
        }
    }

    public class LoaderTaskManager {
        private RaptorTask<?> m_task;
        private IRaptorTaskListener m_listener;

        public void setTask(RaptorTask<?> raptorTask) {
            this.m_task = raptorTask;
            if (this.m_task != null) {
                this.m_task.getDescriptor().addListener(this.getTaskListener());
            }
        }

        void cancel() {
            if (this.m_task != null) {
                this.m_task.requestCancel();
            }
        }

        void pause() {
            if (this.m_task != null) {
                this.m_task.requestPause();
            }
        }

        void resume() {
            if (this.m_task != null) {
                this.m_task.resume();
            }
        }

        private IRaptorTaskListener getTaskListener() {
            if (null == this.m_listener) {
                this.m_listener = new RaptorTaskAdapter(){

                    public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                        LoaderTaskManager.this.informCanceled();
                    }

                    public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                        LoaderTaskManager.this.informFailed();
                    }

                    public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                        LoaderTaskManager.this.informFinished();
                    }
                };
            }
            return this.m_listener;
        }

        public void informCanceled() {
            this.reset();
        }

        public void informFailed() {
            this.reset();
        }

        public void informFinished() {
            AsynchronousViewerEditor.this._inSync = true;
            AsynchronousViewerEditor.this.setContentModelLoaded(true);
            this.reset();
        }

        private void reset() {
            if (this.m_task != null) {
                this.m_task.getDescriptor().removeListener(this.getTaskListener());
            }
            this.m_task = null;
        }
    }
}

