/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.navigator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.core.NavigatorContext;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.onsd.OnsdBrowserResources;
import oracle.dbtools.raptor.onsd.actions.OnsdNewTable;
import oracle.dbtools.raptor.onsd.connection.NSConnection;
import oracle.dbtools.raptor.onsd.connection.NSConnectionEvent;
import oracle.dbtools.raptor.onsd.connection.NSConnections;
import oracle.dbtools.raptor.onsd.connection.NSConnectionsAdapter;
import oracle.dbtools.raptor.onsd.connection.OnsdConnectionType;
import oracle.dbtools.raptor.onsd.connection.OnsdTask;
import oracle.dbtools.raptor.onsd.connection.ui.ConnectionEditor;
import oracle.dbtools.raptor.onsd.navigator.ExceptionDialogRunnable;
import oracle.dbtools.raptor.onsd.navigator.OnsdConnection;
import oracle.dbtools.raptor.onsd.navigator.OnsdFolder;
import oracle.dbtools.raptor.onsd.navigator.OnsdObject;
import oracle.dbtools.raptor.onsd.navigator.OnsdTable;
import oracle.dbtools.raptor.sftp.SftpUtil;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;
import oracle.kv.KVStore;

public class OnsdController
implements Controller {
    private static final String NEW_ONSD_CONN_CMD = "Onsd.NewOnsdConnection";
    public static final int NEW_ONSD_CONN_CMD_ID = Ide.findOrCreateCmdID((String)"Onsd.NewOnsdConnection");
    private static final String CONNECT_CMD = "Onsd.CONNECT";
    public static final int CONNECT_CMD_ID = Ide.findOrCreateCmdID((String)"Onsd.CONNECT");
    private static final String DISCONNECT_CMD = "Onsd.DISCONNECT";
    public static final int DISCONNECT_CMD_ID = Ide.findOrCreateCmdID((String)"Onsd.DISCONNECT");
    private static final String OPEN_OBJECT_CMD = "DatabaseNavigator.OpenObject";
    public static final int OPEN_OBJECT_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.OpenObject");
    private static final String NEW_OBJECT_CMD = "DatabaseNavigator.NewObject";
    public static final int NEW_OBJECT_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.NewObject");
    private static final String STATUS_CMD = "Onsd.DEPLOY_STATUS";
    public static final int STATUS_CMD_ID = Ide.findOrCreateCmdID((String)"Onsd.DEPLOY_STATUS");
    private static final String LOG_CMD = "Onsd.DELETE_LOG";
    public static final int LOG_CMD_ID = Ide.findOrCreateCmdID((String)"Onsd.DELETE_LOG");
    private static final String DELETE_CMD = "Onsd.DELETE_DEPLOY";
    public static final int DELETE_CMD_ID = Ide.findOrCreateCmdID((String)"Onsd.DELETE_DEPLOY");
    private static OnsdController s_instance;

    static boolean isCancel(Throwable throwable) {
        return false;
    }

    public static Controller getInstance() {
        if (s_instance == null) {
            s_instance = new OnsdController();
        }
        return s_instance;
    }

    private OnsdController() {
        NSConnections.getInstance().addListener(new NSConnectionsAdapter(){

            @Override
            public void connectionAdded(NSConnectionEvent nSConnectionEvent) {
            }
        });
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        boolean bl = false;
        Element element = context.getElement();
        int n = ideAction.getCommandId();
        if (n == STATUS_CMD_ID) {
            if (element instanceof OnsdObject) {
                String string = ((OnsdObject)element).getConnectionName();
                String string2 = ((OnsdObject)element).getName();
                SftpUtil sftpUtil = new SftpUtil();
                sftpUtil.updateDeploymentStatus(string, string2, "APPROVED");
                this.refreshEditors((OnsdObject)element);
                bl = true;
            }
        } else if (n == DELETE_CMD_ID) {
            if (element instanceof OnsdTable) {
                this.dropTable((OnsdTable)element);
                this.closeEditors((OnsdObject)element);
                bl = true;
            } else if (element instanceof OnsdObject) {
                String string = ((OnsdObject)element).getConnectionName();
                String string3 = ((OnsdObject)element).getName();
                SftpUtil sftpUtil = new SftpUtil();
                sftpUtil.updateDeploymentStatus(string, string3, "DELETED");
                this.updateParent(context);
                this.closeEditors((OnsdObject)element);
                bl = true;
            }
        } else if (n == NEW_ONSD_CONN_CMD_ID) {
            String string = this.createConnection();
            bl = true;
        } else if (n == 56) {
            if (element instanceof OnsdConnection) {
                this.editConnection(((OnsdConnection)element).getQualifiedConnectionName());
                bl = true;
            }
        } else if (n == 20) {
            for (Element element2 : context.getSelection()) {
                if (!(element2 instanceof OnsdConnection)) continue;
                this.deleteConnection((OnsdConnection)element2, true);
                bl = true;
            }
        } else if (n == CONNECT_CMD_ID) {
            if (element instanceof OnsdConnection) {
                this.openConnection((OnsdConnection)element, context);
                bl = true;
            }
        } else if (n == DISCONNECT_CMD_ID) {
            if (element instanceof OnsdConnection) {
                this.closeConnection((OnsdConnection)element);
                bl = true;
            }
        } else if (n == NEW_OBJECT_CMD_ID && element instanceof OnsdFolder) {
            try {
                DBObject dBObject = new DBObject(context.getElement());
                OnsdNewTable onsdNewTable = new OnsdNewTable();
                onsdNewTable.setDBObject(dBObject);
                onsdNewTable.launch();
            }
            catch (Exception exception) {
                // empty catch block
            }
            bl = true;
        }
        return bl;
    }

    private void updateParent(Context context) {
        NavigatorTreeNode navigatorTreeNode = this.findTreeNode(context);
        if (navigatorTreeNode != null) {
            NavigatorTreeNode navigatorTreeNode2 = navigatorTreeNode.findAncestorTreeNode(OnsdFolder.class, false);
            NavigatorTree navigatorTree = ((NavigatorWindow)context.getView()).getTree();
            navigatorTree.refresh(navigatorTreeNode2);
        }
    }

    private void closeEditors(OnsdObject onsdObject) {
        List list = EditorManager.getEditorManager().getAllEditors();
        ArrayList<Editor> arrayList = new ArrayList<Editor>();
        for (Editor editor : list) {
            Context context = editor.getContext();
            Node node = context != null ? context.getNode() : null;
            if (!node.getURL().getPath().contains(onsdObject.getURL().getPath())) continue;
            arrayList.add(editor);
        }
        EditorManager.getEditorManager().closeEditors(arrayList);
    }

    private void refreshEditors(OnsdObject onsdObject) {
        List list = EditorManager.getEditorManager().getAllEditors();
        for (Editor editor : list) {
            Context context = editor.getContext();
            Node node = context != null ? context.getNode() : null;
            if (!node.getURL().getPath().contains(onsdObject.getURL().getPath())) continue;
            editor.update(null, new UpdateMessage(UpdateMessage.OBJECT_RELOADED, null));
        }
    }

    private NavigatorTreeNode findTreeNode(Context context) {
        Element element;
        Element[] elementArray;
        NavigatorTreeNode navigatorTreeNode = null;
        View view = context.getView();
        if (view instanceof NavigatorWindow && (navigatorTreeNode = NavigatorContext.getSingleNavigatorTreeNodeFromContext(context)) == null && (elementArray = context.getSelection()) != null && elementArray.length == 1 && (element = elementArray[0]) != null) {
            NavigatorTree navigatorTree = ((NavigatorWindow)view).getTree();
            navigatorTreeNode = navigatorTree.findTreeNode(element, navigatorTree.getRoot());
        }
        return navigatorTreeNode;
    }

    private void openConnection(final OnsdConnection onsdConnection, final Context context) {
        OnsdTask<Void> onsdTask = new OnsdTask<Void>(OnsdBrowserResources.getString("TASK_ONSD_CONNECT"), true, IRaptorTaskRunMode.TASKVIEWER){

            @Override
            protected String getConnectionName() {
                return onsdConnection.getQualifiedConnectionName();
            }

            protected Void doWork() throws TaskException {
                try {
                    onsdConnection.getConnection();
                }
                catch (IOException iOException) {
                    Logger.warn(OnsdController.class, (Throwable)iOException);
                    throw new TaskException((Throwable)iOException);
                }
                return null;
            }
        };
        onsdTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                Throwable throwable = raptorTaskEvent.getThrowable();
                if (!OnsdController.isCancel(throwable)) {
                    ExceptionDialogRunnable exceptionDialogRunnable = new ExceptionDialogRunnable(DatabaseNavigatorResources.getString("CONNECTION_FILTER_CONNECT_ERROR"), throwable);
                    if (SwingUtilities.isEventDispatchThread()) {
                        exceptionDialogRunnable.run();
                    } else {
                        try {
                            SwingUtilities.invokeLater(exceptionDialogRunnable);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                NavigatorTreeNode[] navigatorTreeNodeArray = NavigatorContext.getNavigatorNodesFromContext(context);
                if (navigatorTreeNodeArray.length == 1) {
                    NavigatorTreeNode navigatorTreeNode = navigatorTreeNodeArray[0];
                    NavigatorTree navigatorTree = navigatorTreeNode.getOwningNavigatorTree();
                    navigatorTree.expand(navigatorTreeNode, false);
                }
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)onsdTask);
    }

    private String createConnection() {
        return ConnectionEditor.getInstance().createConnection(OnsdConnectionType.getInstance());
    }

    private void editConnection(String string) {
        ConnectionEditor.getInstance().editConnection(string, OnsdConnectionType.getInstance());
    }

    private void deleteConnection(OnsdConnection onsdConnection, boolean bl) {
        String string;
        String string2 = onsdConnection.getQualifiedConnectionName();
        if (bl && !MessageDialog.confirm(null, (Object)(string = DatabaseNavigatorResources.format("MGR_CONFIRM_DEL", string2)), (String)DatabaseNavigatorResources.getString("MGR_CONFIRM_TITLE"), null, (boolean)true)) {
            return;
        }
        if (this.closeConnection(onsdConnection)) {
            NSConnections.getInstance().removeConnection(string2);
        }
    }

    private boolean closeConnection(OnsdConnection onsdConnection) {
        String string = onsdConnection.getQualifiedConnectionName();
        return NSConnections.getInstance().closeConnection(string);
    }

    private boolean dropTable(OnsdTable onsdTable) {
        try {
            String string = onsdTable.getConnectionName();
            NSConnection nSConnection = NSConnections.getInstance().getConnection(string, false);
            KVStore kVStore = nSConnection.getStore();
            kVStore.getTableAPI().executeSync("DROP TABLE " + onsdTable.getName());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean update(IdeAction ideAction, Context context) {
        Element element = context.getElement();
        boolean bl = context.getSelection().length == 1;
        int n = ideAction.getCommandId();
        if (n == NEW_ONSD_CONN_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        if (n == OPEN_OBJECT_CMD_ID) {
            ideAction.setEnabled(bl);
            return true;
        }
        if (element instanceof OnsdTable) {
            if (n == DELETE_CMD_ID) {
                ideAction.setEnabled(bl);
                return true;
            }
        } else if (element instanceof OnsdObject) {
            if (((OnsdObject)element).getTypeName().equals("DEPLOYMENTS")) {
                if (n == STATUS_CMD_ID) {
                    ideAction.setEnabled(bl);
                    return true;
                }
                if (n == LOG_CMD_ID) {
                    ideAction.setEnabled(bl);
                    return true;
                }
                if (n == DELETE_CMD_ID) {
                    ideAction.setEnabled(bl);
                    return true;
                }
            }
        } else if (n == 20) {
            if (element instanceof OnsdConnection) {
                ideAction.setEnabled(bl);
                return true;
            }
        } else {
            if (n == CONNECT_CMD_ID) {
                if (element instanceof OnsdConnection) {
                    ideAction.setEnabled(bl && !((OnsdConnection)element).isConnectionOpen());
                }
                return true;
            }
            if (n == DISCONNECT_CMD_ID) {
                if (element instanceof OnsdConnection) {
                    ideAction.setEnabled(bl && ((OnsdConnection)element).isConnectionOpen());
                }
                return true;
            }
            if (n == 56) {
                if (element instanceof OnsdConnection) {
                    ideAction.setEnabled(bl);
                    return true;
                }
            } else if (n == NEW_OBJECT_CMD_ID) {
                if (element instanceof OnsdFolder) {
                    ideAction.setEnabled(bl);
                }
                return true;
            }
        }
        return false;
    }
}

