/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.navigator;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.ConnectionOwner;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.onsd.OnsdBrowserResources;
import oracle.dbtools.raptor.onsd.connection.NSConnectionEvent;
import oracle.dbtools.raptor.onsd.connection.NSConnections;
import oracle.dbtools.raptor.onsd.connection.NSConnectionsListener;
import oracle.dbtools.raptor.onsd.navigator.OnsdConnection;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public class OnsdConnections
extends DefaultContainer
implements ConnectionOwner,
NSConnectionsListener {
    private static OnsdConnections INSTANCE;

    public static synchronized OnsdConnections getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new OnsdConnections();
        }
        return INSTANCE;
    }

    public static OnsdConnection getConnectionNode(String string, boolean bl) {
        OnsdConnection onsdConnection = null;
        URL uRL = DBURLFormatHelper.getURL("sqldev.onsd", string);
        onsdConnection = bl ? OnsdConnection.findOrCreateConnectionNode(uRL) : OnsdConnection.findConnectionNode(uRL);
        return onsdConnection;
    }

    private OnsdConnections() {
    }

    @Override
    public int compareTo(ConnectionOwner connectionOwner) {
        return connectionOwner == this ? 0 : 1;
    }

    @Override
    public Object getKey() {
        return this.getShortLabel();
    }

    public String getShortLabel() {
        return OnsdBrowserResources.getString("ONSD_CONNECTIONS_NODE");
    }

    public Icon getIcon() {
        return OnsdBrowserResources.getIcon("ONSD_CONNS_ICON");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openImpl() throws IOException {
        NSConnections nSConnections = NSConnections.getInstance();
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            for (String string : nSConnections.listConnections()) {
                OnsdConnection onsdConnection = OnsdConnections.getConnectionNode(string, true);
                if (onsdConnection == null) continue;
                this._children.add(onsdConnection);
            }
        }
        nSConnections.addListener(this);
    }

    protected void closeImpl() throws IOException {
        NSConnections.getInstance().removeListener(this);
    }

    public void markDirty(boolean bl) {
    }

    @Override
    public void connectionAdded(NSConnectionEvent nSConnectionEvent) {
        String string = nSConnectionEvent.getConnectionName();
        OnsdConnection onsdConnection = OnsdConnections.getConnectionNode(string, true);
        if (onsdConnection != null) {
            this.add(onsdConnection, true);
        }
    }

    @Override
    public void connectionRemoved(NSConnectionEvent nSConnectionEvent) {
        String string = nSConnectionEvent.getConnectionName();
        OnsdConnection onsdConnection = OnsdConnections.getConnectionNode(string, false);
        if (onsdConnection != null) {
            this.remove(onsdConnection, true);
        }
    }

    @Override
    public void connectionModified(NSConnectionEvent nSConnectionEvent) {
    }

    @Override
    public void connectionOpened(NSConnectionEvent nSConnectionEvent) {
        String string = nSConnectionEvent.getConnectionName();
        OnsdConnection onsdConnection = OnsdConnections.getConnectionNode(string, false);
        if (onsdConnection != null && onsdConnection.openConnection()) {
            UpdateMessage.fireObjectOpened((Subject)onsdConnection);
        }
    }

    @Override
    public void connectionClosed(NSConnectionEvent nSConnectionEvent) {
        String string = nSConnectionEvent.getConnectionName();
        OnsdConnection onsdConnection = OnsdConnections.getConnectionNode(string, false);
        if (onsdConnection != null && onsdConnection.isConnectionOpen()) {
            onsdConnection.forgetConnection();
            UpdateMessage.fireObjectClosed((Subject)onsdConnection);
        }
    }
}

