/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.navigator;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.model.AsynchronousNavigatorTreeNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.onsd.OnsdBrowserResources;
import oracle.dbtools.raptor.onsd.connection.OnsdTask;
import oracle.dbtools.raptor.onsd.navigator.OnsdConnection;
import oracle.dbtools.raptor.onsd.navigator.OnsdController;
import oracle.dbtools.raptor.onsd.navigator.OnsdFolder;
import oracle.dbtools.raptor.onsd.navigator.OnsdObjectType;
import oracle.dbtools.util.Logger;
import oracle.ide.model.Element;

public class ConnectionTreeNode
extends AsynchronousNavigatorTreeNode {
    @Override
    protected RaptorTask<Collection<Element>> getLoadingTask() {
        return new LoadTask((OnsdConnection)this.getElement());
    }

    private OnsdFolder createFolder(URL uRL, OnsdObjectType onsdObjectType) {
        OnsdFolder onsdFolder = new OnsdFolder(uRL);
        onsdFolder.setObjectType(onsdObjectType);
        return onsdFolder;
    }

    private class LoadTask
    extends OnsdTask<Collection<Element>> {
        private OnsdConnection m_owner;
        private String m_cName;

        LoadTask(OnsdConnection onsdConnection) {
            super(OnsdBrowserResources.getString("TASK_ONSD_CONNECT"), true, IRaptorTaskRunMode.TASKVIEWER);
            ConnectionTreeNode.this.setComparator(null);
            this.m_owner = onsdConnection;
            this.m_cName = this.m_owner.getQualifiedConnectionName();
        }

        @Override
        protected String getConnectionName() {
            return this.m_cName;
        }

        protected Collection<Element> doWork() throws TaskException {
            List<Object> list = null;
            try {
                this.m_owner.getConnection();
                URL uRL = this.m_owner.getURL();
                list = new ArrayList<Element>();
                URL uRL2 = DBURLFormatHelper.getURL(uRL, "TABLE");
                OnsdFolder onsdFolder = ConnectionTreeNode.this.createFolder(uRL2, new OnsdObjectType("TABLE"));
                onsdFolder.setConnectionName(this.m_owner.getQualifiedConnectionName());
                list.add((Element)onsdFolder);
                if (list == null) {
                    list = Collections.emptyList();
                }
                return list;
            }
            catch (IOException iOException) {
                Logger.warn(OnsdController.class, (Throwable)iOException);
                throw new TaskException((Throwable)iOException);
            }
        }
    }
}

