/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.controls.cellrenderer;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.raptor.onsd.OnsdUtil;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;

public class DefaultOnsdTableCellRenderer
implements TableCellRenderer {
    private TableCellRenderer delegateRenderer = null;
    private FieldDef.Type type;

    public DefaultOnsdTableCellRenderer(FieldDef.Type type) {
        this.type = type;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (this.delegateRenderer == null) {
            this.delegateRenderer = jTable.getDefaultRenderer(this.getDelegateClass());
        }
        return this.delegateRenderer.getTableCellRendererComponent(jTable, this.getJavaValue(object), bl, bl2, n, n2);
    }

    protected Object getJavaValue(Object object) {
        if (object instanceof FieldValue) {
            FieldValue fieldValue = (FieldValue)object;
            if (fieldValue.isNull()) {
                return null;
            }
            switch (fieldValue.getType()) {
                case BOOLEAN: {
                    return fieldValue.asBoolean().get();
                }
                case DOUBLE: {
                    return fieldValue.asDouble().get();
                }
                case ENUM: {
                    return fieldValue.asEnum().get();
                }
                case FLOAT: {
                    return Float.valueOf(fieldValue.asFloat().get());
                }
                case INTEGER: {
                    return fieldValue.asInteger().get();
                }
                case LONG: {
                    return fieldValue.asLong().get();
                }
                case STRING: {
                    return fieldValue.asString().get();
                }
            }
            return fieldValue;
        }
        return object;
    }

    protected Class<?> getDelegateClass() {
        return OnsdUtil.getInstance().getJavaFieldClass(this.type);
    }
}

