/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.actions;

import java.awt.Component;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.raptor.onsd.OnsdBrowserResources;
import oracle.dbtools.raptor.onsd.actions.OnsdColumnTable;
import oracle.dbtools.raptor.onsd.connection.NSConnection;
import oracle.dbtools.raptor.onsd.connection.NSConnections;
import oracle.dbtools.raptor.onsd.jdbc.NoSQLConnection;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.SQLScriptProcessor;
import oracle.dbtools.raptor.ui.controls.GenericTableActionControl;
import oracle.dbtools.raptor.ui.controls.TableActionControlPanel;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.javatools.db.DBException;
import oracle.kv.KVStore;

public class OnsdNewTable
extends ActionDialog {
    private DataTypeCellEditor dataTypeCellEditor = new DataTypeCellEditor();

    @Override
    protected Connection getConnection(String string) throws DBException {
        try {
            NSConnection nSConnection = NSConnections.getInstance().getConnection(string, true);
            return new NoSQLConnection(nSConnection);
        }
        catch (Exception exception) {
            throw new DBException((Throwable)exception);
        }
    }

    @Override
    protected String getEditPaneTitle() {
        return OnsdBrowserResources.getString("TABLE_TITLE");
    }

    @Override
    protected List<ActionControl> createControls(Connection connection) {
        NSConnection nSConnection = ((NoSQLConnection)connection).getDelegate();
        KVStore kVStore = nSConnection.getStore();
        Map map = kVStore.getTableAPI().getTables();
        int n = 1;
        String string = "TABLE_" + n;
        while (map.get(string) != null) {
            string = "TABLE_" + ++n;
        }
        OnsdColumnTable.ColumnRowFactory columnRowFactory = OnsdColumnTable.createRowFactory();
        ArrayList<OnsdColumnTable.ColumnRow> arrayList = new ArrayList<OnsdColumnTable.ColumnRow>();
        arrayList.add((OnsdColumnTable.ColumnRow)columnRowFactory.createRow(-1, (GenericTableActionControl.TableActionControlModel)null));
        ArrayList<ActionControl> arrayList2 = new ArrayList<ActionControl>();
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl("NAME", OnsdBrowserResources.getString("NAME_LABEL") + ":", string);
        TextBoxActionControl textBoxActionControl2 = new TextBoxActionControl("COMMENT", OnsdBrowserResources.getString("COMMENT_LABEL") + ":", "");
        OnsdColumnTable onsdColumnTable = new OnsdColumnTable("COLUMNS", OnsdBrowserResources.getString("COLUMNS_LABEL") + ":", columnRowFactory, arrayList, 5);
        TableActionControlPanel tableActionControlPanel = onsdColumnTable.getUI();
        JTable jTable = tableActionControlPanel.getTable();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(2);
        tableColumn.setCellEditor(this.dataTypeCellEditor);
        arrayList2.add(textBoxActionControl);
        arrayList2.add(textBoxActionControl2);
        arrayList2.add(onsdColumnTable);
        SQLScriptProcessor sQLScriptProcessor = (SQLScriptProcessor)this.getScriptProcessor();
        sQLScriptProcessor.setScriptEditorTabName("DDL_TAB");
        return arrayList2;
    }

    @Override
    protected String getTitle() {
        return "New Table";
    }

    @Override
    protected String getScript(ActionDialog.Values values) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE TABLE ");
        stringBuilder.append(values.get("NAME"));
        stringBuilder.append(" (");
        List<String> list = values.getList("COLUMNS", OnsdBrowserResources.getString("PK_LABEL"));
        List<String> list2 = values.getList("COLUMNS", OnsdBrowserResources.getString("NAME_LABEL"));
        List<String> list3 = values.getList("COLUMNS", OnsdBrowserResources.getString("DATA_TYPE_LABEL"));
        List<String> list4 = values.getList("COLUMNS", OnsdBrowserResources.getString("LENGTH_LABEL"));
        List<String> list5 = values.getList("COLUMNS", OnsdBrowserResources.getString("NULLABLE_LABEL"));
        List<String> list6 = values.getList("COLUMNS", OnsdBrowserResources.getString("DEFAULT_LABEL"));
        List<String> list7 = values.getList("COLUMNS", OnsdBrowserResources.getString("COMMENT_LABEL"));
        if (list2 != null) {
            String string;
            Iterator<String> iterator = list.iterator();
            Iterator<String> iterator2 = list2.iterator();
            Iterator<String> iterator3 = list3.iterator();
            Iterator<String> iterator4 = list4.iterator();
            Iterator<String> iterator5 = list5.iterator();
            Iterator<String> iterator6 = list6.iterator();
            Iterator<String> iterator7 = list7.iterator();
            StringBuilder stringBuilder2 = new StringBuilder();
            int n = 0;
            int n2 = 0;
            while (iterator2.hasNext()) {
                string = iterator.next();
                String string2 = iterator2.next();
                String string3 = iterator3.next();
                String string4 = iterator4.next();
                String string5 = iterator5.next();
                String string6 = iterator6.next();
                String string7 = iterator7.next();
                if (n2 != 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("\n    ");
                stringBuilder.append(string2);
                stringBuilder.append(" ");
                stringBuilder.append(string3);
                if (string4.length() > 0) {
                    stringBuilder.append("(");
                    stringBuilder.append(string4);
                    stringBuilder.append(")");
                }
                if (string6.length() > 0) {
                    stringBuilder.append(" DEFAULT ");
                    stringBuilder.append(string6);
                }
                if (!Boolean.parseBoolean(string5)) {
                    stringBuilder.append(" NOT NULL");
                }
                if (string7.length() > 0) {
                    stringBuilder.append(" COMMENT \"");
                    stringBuilder.append(string7);
                    stringBuilder.append("\"");
                }
                if (Boolean.parseBoolean(string)) {
                    if (n != 0) {
                        stringBuilder2.append(",");
                    }
                    stringBuilder2.append(string2);
                    ++n;
                }
                ++n2;
            }
            if (n > 0) {
                stringBuilder.append(",");
                stringBuilder.append("\n    ");
                stringBuilder.append("PRIMARY KEY (");
                stringBuilder.append(stringBuilder2.toString());
                stringBuilder.append(")");
            }
            if ((string = values.get("COMMENT")).length() > 0) {
                if (n2 > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("\n    ");
                stringBuilder.append("COMMENT \"");
                stringBuilder.append(string);
                stringBuilder.append("\"");
            }
        }
        stringBuilder.append("\n)");
        return stringBuilder.toString();
    }

    private class DataTypeCellEditor
    extends DefaultCellEditor {
        private JComboBox comboBox;

        public DataTypeCellEditor() {
            super(new JComboBox());
            this.comboBox = (JComboBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            OnsdColumnTable.DATATYPE[] dATATYPEArray = OnsdColumnTable.DATATYPE.values();
            this.comboBox.setModel(new DefaultComboBoxModel<OnsdColumnTable.DATATYPE>(dATATYPEArray));
            this.comboBox.setEditable(true);
            this.comboBox.setSelectedItem(object);
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }
    }
}

