/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.folders.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import oracle.dbtools.raptor.navigator.Databases;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.folders.DatabasesFolder;
import oracle.dbtools.raptor.navigator.folders.DatabasesTreeNode;
import oracle.dbtools.raptor.navigator.folders.dnd.ConnectionDragHelper;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.util.Logger;
import oracle.ide.model.Element;
import oracle.ide.util.dnd.DropHelper;

public class ConnectionDropHelper
implements DropHelper {
    public boolean canTransferData(Object object, DataFlavor[] dataFlavorArray, int n) {
        NavigatorTreeNode navigatorTreeNode;
        return n == 2 && Arrays.asList(dataFlavorArray).contains(ConnectionDragHelper.CONN_NODE_FLAVOR) && (navigatorTreeNode = (NavigatorTreeNode)object).findAncestorTreeNode(Databases.class, false) != null;
    }

    public float getWeight() {
        return 10.0f;
    }

    public boolean transferData(Object object, Transferable[] transferableArray, int n) {
        NavigatorTreeNode navigatorTreeNode;
        NavigatorTreeNode navigatorTreeNode2 = (NavigatorTreeNode)object;
        DatabaseConnection databaseConnection = this.getConnectionNode(transferableArray);
        if (databaseConnection != null && (navigatorTreeNode = navigatorTreeNode2.findAncestorTreeNode(Databases.class, false)) instanceof DatabasesTreeNode) {
            DatabasesTreeNode databasesTreeNode = (DatabasesTreeNode)navigatorTreeNode;
            DatabasesFolder databasesFolder = navigatorTreeNode2.findAncestorElement(DatabasesFolder.class, false);
            if (databasesFolder == null) {
                databasesTreeNode.updateFolder(databasesTreeNode.getOwningNavigatorTree(), null, new Element[]{databaseConnection});
            } else {
                databasesTreeNode.updateFolder(databasesTreeNode.getOwningNavigatorTree(), databasesFolder.getName(), new Element[]{databaseConnection});
            }
            return true;
        }
        return false;
    }

    private DatabaseConnection getConnectionNode(Transferable[] transferableArray) {
        for (Transferable transferable : transferableArray) {
            if (!transferable.isDataFlavorSupported(ConnectionDragHelper.CONN_NODE_FLAVOR)) continue;
            try {
                return (DatabaseConnection)transferable.getTransferData(ConnectionDragHelper.CONN_NODE_FLAVOR);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                Logger.warn(this.getClass(), (Throwable)unsupportedFlavorException);
            }
            catch (IOException iOException) {
                Logger.warn(this.getClass(), (Throwable)iOException);
            }
        }
        return null;
    }
}

