/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.folders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.dbtools.raptor.utils.RaptorHashStructureAdapter;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;

public class DatabasesFolderCache
extends RaptorHashStructureAdapter {
    private static final String DATA_KEY = "DatabaseFoldersCache";
    static final String FOLDERS_KEY = "Folders";

    public static DatabasesFolderCache getInstance(PropertyStorage propertyStorage) {
        return new DatabasesFolderCache(DatabasesFolderCache.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
    }

    private DatabasesFolderCache(HashStructure hashStructure) {
        super(hashStructure);
    }

    protected String getRootKey() {
        return FOLDERS_KEY;
    }

    public Set<String> getFolders(String string) {
        HashStructure hashStructure = this.getRootHash().getHashStructure(string);
        if (hashStructure != null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (String string2 : hashStructure.keySet()) {
                hashSet.add(DatabasesFolderCache.decode((String)string2));
            }
            return hashSet;
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getConnectionNames(String string, String string2) {
        ListStructure listStructure;
        HashStructure hashStructure = this.getRootHash().getHashStructure(string);
        if (hashStructure != null && (listStructure = hashStructure.getListStructure(DatabasesFolderCache.encode((String)string2))) != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Object object = listStructure.iteratorLock();
            synchronized (object) {
                Iterator iterator = listStructure.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(DatabasesFolderCache.decode((String)((String)iterator.next())));
                }
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public void addFolder(String string, String string2) {
        this.getRootHash().getOrCreateHashStructure(string).putListStructure(DatabasesFolderCache.encode((String)string2), ListStructure.newInstance());
    }

    public void removeFolder(String string, String string2) {
        this.getRootHash().getOrCreateHashStructure(string).remove(DatabasesFolderCache.encode((String)string2));
    }

    public void renameFolder(String string, String string2, String string3) {
        String string4;
        ListStructure listStructure;
        HashStructure hashStructure = this.getRootHash().getHashStructure(string);
        if (hashStructure != null && (listStructure = hashStructure.getListStructure(string4 = DatabasesFolderCache.encode((String)string2))) != null) {
            hashStructure.remove(string4);
            hashStructure.putListStructure(DatabasesFolderCache.encode((String)string3), listStructure);
        }
    }

    public void addConnection(String string, String string2, String string3) {
        String string4;
        ListStructure listStructure = this.getConnectionList(string, string2);
        if (listStructure != null && !listStructure.contains((Object)(string4 = DatabasesFolderCache.encode((String)string3)))) {
            listStructure.add((Object)string4);
        }
    }

    private ListStructure getConnectionList(String string, String string2) {
        String string3 = DatabasesFolderCache.encode((String)string2);
        HashStructure hashStructure = this.getRootHash().getOrCreateHashStructure(string);
        ListStructure listStructure = hashStructure.getListStructure(string3);
        if (listStructure == null) {
            listStructure = ListStructure.newInstance();
            hashStructure.putListStructure(string3, listStructure);
        }
        return listStructure;
    }

    public void removeConnection(String string, String string2, String string3) {
        ListStructure listStructure = this.getConnectionList(string, string2);
        if (listStructure != null) {
            listStructure.remove((Object)DatabasesFolderCache.encode((String)string3));
        }
    }
}

