/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.xml;

import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.db.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorDescriptor;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorXmlElements;
import oracle.dbtools.raptor.navigator.db.xml.XmlFolderOwner;
import oracle.dbtools.raptor.navigator.db.xml.XmlNavigatorUtils;
import oracle.dbtools.raptor.query.ObjectQueries;
import oracle.ide.model.Element;
import oracle.xml.parser.v2.XMLNode;

public class XmlFolderImpl
implements DatabaseFolder,
NavigatorXmlElements {
    private XmlFolderOwner m_type;
    private String m_labelKey;
    private String m_label;
    private String m_iconKey;
    private String m_iconPath;
    private Icon m_icon;
    private ObjectQueries m_queries;
    private boolean m_currentSchemaOnly;
    private boolean m_singleClickOpen;
    private NavigatorDescriptor m_desc;
    private String m_override;
    private double m_weight = Double.NEGATIVE_INFINITY;
    private double m_relWeight;
    private boolean m_ignoreComparator;

    static boolean parseIgnoreComparator(XMLNode xMLNode) {
        return Boolean.parseBoolean(XmlNavigatorUtils.getAttributeValue("", "ignoreComparator", xMLNode));
    }

    public XmlFolderImpl(XmlFolderOwner xmlFolderOwner, NavigatorDescriptor navigatorDescriptor, XMLNode xMLNode) {
        this.m_type = xmlFolderOwner;
        this.m_desc = navigatorDescriptor;
        this.m_labelKey = XmlNavigatorUtils.getAttributeValue("label", "RSKEY", xMLNode);
        this.m_iconKey = XmlNavigatorUtils.getAttributeValue("icon", "RSKEY", xMLNode);
        if (this.m_iconKey == null) {
            this.m_iconPath = XmlNavigatorUtils.getAttributeValue("icon", "PATH", xMLNode);
        }
        this.m_queries = new ObjectQueries(XmlNavigatorUtils.getSingleElement("queries", xMLNode));
        this.m_currentSchemaOnly = Boolean.parseBoolean(XmlNavigatorUtils.getAttributeValue("", "currentSchemaOnly", xMLNode));
        this.m_singleClickOpen = Boolean.parseBoolean(XmlNavigatorUtils.getAttributeValue("", "singleClickOpen", xMLNode));
        String string = XmlNavigatorUtils.getAttributeValue(null, "relativeWeight", xMLNode);
        if (string != null) {
            try {
                this.m_relWeight = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.m_override = XmlNavigatorUtils.getAttributeValue(null, "schemaOverride", xMLNode);
        this.m_ignoreComparator = XmlFolderImpl.parseIgnoreComparator(xMLNode);
    }

    @Override
    public String getLabel() {
        if (this.m_label == null) {
            this.m_label = this.m_desc != null && this.m_labelKey != null ? this.m_desc.getResource(this.m_labelKey) : this.m_type.getType();
        }
        return this.m_label;
    }

    @Override
    public Icon getIcon() {
        if (this.m_icon == null) {
            if (this.m_iconKey != null) {
                this.m_icon = XmlNavigatorUtils.getIcon(this.m_iconKey, this.m_desc);
            } else if (this.m_iconPath != null) {
                this.m_icon = XmlNavigatorUtils.getIcon(this.m_iconPath);
            }
        }
        return this.m_icon;
    }

    @Override
    public String getType() {
        return this.m_type.getType();
    }

    public ObjectQueries getQueries() {
        return this.m_queries;
    }

    @Override
    public double getWeight() {
        if (this.m_weight == Double.NEGATIVE_INFINITY) {
            this.m_weight = this.m_type.getWeight() + this.m_relWeight;
        }
        return this.m_weight;
    }

    @Override
    public String getSchemaOverride() {
        return this.m_override;
    }

    @Override
    public boolean isCurrentSchemaOnly() {
        return this.m_currentSchemaOnly;
    }

    @Override
    public boolean isSingleClickOpen() {
        return this.m_singleClickOpen;
    }

    @Override
    public Class<? extends Element> getImplementationClass() {
        return null;
    }

    boolean isSupportsSynonyms() {
        return this.m_type.isIncludesSynonyms();
    }

    @Override
    public boolean ignoreDefaultComparator() {
        return this.m_ignoreComparator;
    }
}

