/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.xml;

import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.db.model.ChildType;
import oracle.dbtools.raptor.navigator.db.model.FilterChildProvider;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorDescriptor;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorXmlElements;
import oracle.dbtools.raptor.navigator.db.xml.XmlDatabaseItem;
import oracle.dbtools.raptor.navigator.db.xml.XmlNavigatorUtils;
import oracle.dbtools.raptor.query.ObjectQueries;
import oracle.xml.parser.v2.XMLNode;

public class XmlChildImpl
extends XmlDatabaseItem
implements ChildType,
NavigatorXmlElements {
    private ObjectQueries m_queries;
    private String m_nodeType;
    private String m_childType;
    private boolean m_showFolder;
    private String m_labelKey;
    private String m_label;
    private String m_iconKey;
    private String m_iconPath;
    private Icon m_icon;
    private String m_provImpl;
    private Class<? extends FilterChildProvider> m_provImplClass;

    XmlChildImpl(String string, NavigatorDescriptor navigatorDescriptor, String string2, XMLNode xMLNode) {
        super(xMLNode, navigatorDescriptor, string2);
        this.m_queries = new ObjectQueries(XmlNavigatorUtils.getSingleElement("queries", xMLNode));
        this.m_nodeType = XmlNavigatorUtils.getAttributeValue("", "nodeType", xMLNode);
        this.m_childType = string;
        this.m_provImpl = XmlNavigatorUtils.getAttributeValue("", "provImplClass", xMLNode);
        this.m_showFolder = Boolean.valueOf(XmlNavigatorUtils.getAttributeValue("", "showFolder", xMLNode));
        XMLNode xMLNode2 = XmlNavigatorUtils.getSingleElement("folder", xMLNode);
        if (xMLNode2 != null) {
            this.m_labelKey = XmlNavigatorUtils.getAttributeValue("label", "RSKEY", xMLNode2);
            this.m_iconKey = XmlNavigatorUtils.getAttributeValue("icon", "RSKEY", xMLNode2);
            if (this.m_iconKey == null) {
                this.m_iconPath = XmlNavigatorUtils.getAttributeValue("icon", "PATH", xMLNode2);
            }
        }
    }

    ObjectQueries getQueries() {
        if (this.m_queries.getLoadedQueryCount() == 0) {
            this.m_queries.initQueries(null);
        }
        return this.m_queries;
    }

    @Override
    public String getNodeType() {
        return this.m_nodeType;
    }

    @Override
    public String getChildType() {
        return this.m_childType;
    }

    Class<? extends FilterChildProvider> getProviderImpl() {
        if (this.m_provImplClass == null && this.m_provImpl != null) {
            try {
                this.m_provImplClass = Class.forName(this.m_provImpl, true, this.getDescriptor().getDescriptorClassLoader());
                assert (FilterChildProvider.class.isAssignableFrom(this.m_provImplClass));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.m_provImplClass;
    }

    @Override
    public boolean showAsFolder() {
        return this.m_showFolder;
    }

    @Override
    public Icon getFolderIcon() {
        if (this.m_icon == null) {
            if (this.m_iconKey != null) {
                this.m_icon = XmlNavigatorUtils.getIcon(this.m_iconKey, this.getDescriptor());
            } else if (this.m_iconPath != null) {
                this.m_icon = XmlNavigatorUtils.getIcon(this.m_iconPath);
            }
        }
        return this.m_icon;
    }

    @Override
    public String getFolderLabel() {
        if (this.m_label == null) {
            NavigatorDescriptor navigatorDescriptor = this.getDescriptor();
            this.m_label = navigatorDescriptor != null && this.m_labelKey != null ? navigatorDescriptor.getResource(this.m_labelKey) : this.m_childType;
        }
        return this.m_label;
    }
}

