/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.db.impl.FilterableTreeNode;
import oracle.dbtools.raptor.navigator.db.impl.TypeContainerTreeNode;
import oracle.dbtools.raptor.navigator.db.model.CategoryInstance;
import oracle.dbtools.raptor.navigator.db.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.impl.CategoryFolder;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.dbtools.raptor.navigator.model.NavigatorQueryTask;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.ide.model.Element;

public class SchemaTreeNode
extends TypeContainerTreeNode
implements FilterableTreeNode {
    public DBSchemaInstance getSchemaInstance() {
        SchemaFolder schemaFolder = (SchemaFolder)this.getElement();
        return schemaFolder.getSchemaInstance();
    }

    @Override
    protected RaptorTask<Collection<Element>> getLoadingTask() {
        SchemaFolder schemaFolder = (SchemaFolder)this.getElement();
        return new LoadTask(schemaFolder, (String)schemaFolder.getProviderIdentifier());
    }

    @Override
    public String getShortLabel() {
        DBSchemaInstance dBSchemaInstance;
        String string = super.getShortLabel();
        boolean bl = false;
        SchemaFolder schemaFolder = (SchemaFolder)this.getElement();
        if (schemaFolder != null && (dBSchemaInstance = schemaFolder.getSchemaInstance()) != null) {
            bl = dBSchemaInstance.isSchemaFiltered();
        }
        return bl ? DatabaseNavigatorResources.format("FILTER_FORMAT", string) : string;
    }

    @Override
    public boolean clearFilter() {
        DBSchemaInstance dBSchemaInstance = this.getSchemaInstance();
        if (dBSchemaInstance != null && dBSchemaInstance.isSchemaFiltered()) {
            dBSchemaInstance.clearFilter();
            return true;
        }
        return false;
    }

    @Override
    public boolean isFiltered() {
        DBSchemaInstance dBSchemaInstance = this.getSchemaInstance();
        return dBSchemaInstance != null && dBSchemaInstance.isSchemaFiltered();
    }

    @Override
    public boolean canHaveFilter() {
        return true;
    }

    @Override
    public boolean promptForFilter() {
        DBSchemaInstance dBSchemaInstance = this.getSchemaInstance();
        return dBSchemaInstance != null && dBSchemaInstance.promptForSchemaFilter();
    }

    private class LoadTask
    extends NavigatorQueryTask {
        private SchemaFolder m_parent;

        protected LoadTask(SchemaFolder schemaFolder, String string) {
            super(DatabaseNavigatorResources.getString("CONNECTION_FILTER_OPEN"), string, true);
            this.m_parent = schemaFolder;
        }

        @Override
        protected Collection<Element> doWorkImpl() throws TaskException {
            ArrayList<Element> arrayList = new ArrayList<Element>();
            URL uRL = this.m_parent.getURL();
            String string = DBURLFormatHelper.getConnectionName(uRL);
            DBSchemaInstance dBSchemaInstance = this.m_parent.getSchemaInstance();
            ObjectFactory objectFactory = dBSchemaInstance.getObjectFactory();
            if (objectFactory != null) {
                String string2;
                String string3 = (String)dBSchemaInstance.getProperty("CATALOG");
                if (string3 == null) {
                    string3 = DBURLFormatHelper.getCatalog(uRL);
                }
                if ((string2 = (String)dBSchemaInstance.getProperty("SCHEMA")) == null) {
                    string2 = DBURLFormatHelper.getSchema(uRL);
                }
                String string4 = string3;
                String string5 = string2;
                arrayList.addAll(SchemaTreeNode.this.loadTypeFolders(dBSchemaInstance, string, string4, string5));
                String string6 = SchemaTreeNode.this.getURLProtocol();
                if (string6 != null) {
                    for (CategoryInstance categoryInstance : dBSchemaInstance.listCategories()) {
                        URL uRL2 = DBURLFormatHelper.getURL(string6, string, string4, string5, categoryInstance.getDescriptor().getType());
                        arrayList.add(new CategoryFolder(uRL2, categoryInstance));
                    }
                }
            }
            return arrayList;
        }
    }
}

