/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.EventObject;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.navigator.DummyElement;
import oracle.dbtools.raptor.navigator.ViewableSelectionComponentProvider;
import oracle.dbtools.raptor.navigator.core.NavigatorUI;
import oracle.dbtools.raptor.navigator.core.NavigatorViewController;
import oracle.dbtools.raptor.navigator.model.CustomTreeModel;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.navigator.ui.CustomTree;
import oracle.dbtools.raptor.ui.RDockableWindow;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.javatools.ui.layout.VerticalFlowLayout;
import oracle.javatools.ui.search.SearchField;

public abstract class NavigatorWindow
extends RDockableWindow
implements ViewableSelectionComponentProvider {
    private JPanel m_northPanel;
    private Toolbar m_toolbar;
    private boolean m_toolbarVisible;
    private boolean m_toolbarVisibleSet;
    private JPanel m_southPanel;
    private SearchField m_search;
    private boolean m_searchVisible;
    private boolean m_searchVisibleSet;
    private JPanel m_host;
    private NavigatorUI m_ui;
    private NavigatorTree m_tree;
    private PropertyAccess m_props;
    private Controller m_controller;

    protected NavigatorWindow(ViewId viewId) {
        super(viewId.getId());
        this.setType(0);
    }

    private void createGUI() {
        if (this.m_host == null) {
            this.m_host = new JPanel(new BorderLayout());
            if (!RaptorExtensionConstants.isStandAlone()) {
                this.m_host.setOpaque(false);
            }
            this.m_ui = new NavigatorUI((View)this);
            this.m_ui.addViewSelectionListener(new ViewSelectionListener(){

                public void viewSelectionChanged(ViewSelectionEvent viewSelectionEvent) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            NavigatorWindow.this.updateSelection();
                            NavigatorWindow.this.fireViewSelectionChanged(new ViewSelectionEvent((View)NavigatorWindow.this));
                        }
                    };
                    if (SwingUtilities.isEventDispatchThread()) {
                        runnable.run();
                    } else {
                        SwingUtilities.invokeLater(runnable);
                    }
                }
            });
            this.m_ui.setOverlayCache(IconOverlayCache.getInstance());
            this.m_tree = new NavigatorTree(this, this.getRootElement(), this.isRootVisible());
            CustomTree customTree = this.m_tree.getTree();
            this.m_ui.setTree(this.m_tree);
            customTree.addTreeWillExpandListener(new TreeWillExpandListener(){

                @Override
                public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                }

                @Override
                public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                    NavigatorTreeNode navigatorTreeNode = (NavigatorTreeNode)treeExpansionEvent.getPath().getLastPathComponent();
                    if (!NavigatorWindow.this.canCollapse(navigatorTreeNode)) {
                        throw new ExpandVetoException(treeExpansionEvent);
                    }
                }
            });
            this.expandVisibleRoot(this.m_tree);
            this.m_host.add(this.m_ui.getGUI(), "Center");
            this.initCommonItems();
            this.initCustomItems();
        }
    }

    protected void initCustomItems() {
    }

    protected Element getRootElement() {
        return DummyElement.INSTANCE;
    }

    protected boolean isRootVisible() {
        return true;
    }

    public void loadLayout(PropertyAccess propertyAccess) {
        if (this.m_host == null) {
            this.m_props = propertyAccess;
            return;
        }
        super.loadLayout(propertyAccess);
    }

    public void saveLayout(PropertyAccess propertyAccess) {
        if (this.m_host != null) {
            super.saveLayout(propertyAccess);
        }
    }

    public String getTitleName() {
        return null;
    }

    protected final void initCommonItems() {
        this.initToolbarArea();
        this.initSearchArea();
        if (this.m_props != null) {
            this.loadLayout(this.m_props);
            this.m_props = null;
        }
    }

    private void initSearchArea() {
        if (this.m_searchVisibleSet) {
            this.setSearchAreaVisible(this.m_searchVisible);
            this.m_searchVisibleSet = false;
        }
    }

    protected final void initToolbarArea() {
        if (this.m_toolbarVisibleSet) {
            this.setToolbarVisible(this.m_toolbarVisible);
            this.m_toolbarVisibleSet = false;
        }
    }

    protected void initCustomToolbarItems(Toolbar toolbar) {
    }

    public Toolbar getToolbar() {
        return this.m_toolbar;
    }

    public final void setToolbarVisible(boolean bl) {
        if (this.m_host == null) {
            this.m_toolbarVisibleSet = true;
            this.m_toolbarVisible = bl;
            return;
        }
        if (bl) {
            this.createToolbar();
        } else {
            this.removeToolbar();
        }
    }

    public final void setSearchAreaVisible(boolean bl) {
        if (this.m_host == null) {
            this.m_searchVisibleSet = true;
            this.m_searchVisible = bl;
            return;
        }
        if (bl) {
            this.createSearchArea();
        } else {
            this.removeSearchArea();
        }
    }

    private String getViewType() {
        return new ViewId(this.getId()).getType();
    }

    private void createToolbar() {
        if (this.m_toolbar == null) {
            this.m_toolbar = new Toolbar();
            String string = this.getToolbarId();
            if (string != null) {
                NavigatorWindow.loadManifestToolbar((String)string, (Toolbar)this.m_toolbar, (View)this);
            }
            this.initCustomToolbarItems(this.m_toolbar);
            this.updateVisibleActions();
            if (this.m_northPanel == null) {
                this.m_northPanel = new JPanel();
                this.m_northPanel.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
                this.m_host.add((Component)this.m_northPanel, "North");
            }
            this.m_northPanel.add((Component)this.m_toolbar);
            this.m_host.revalidate();
        }
    }

    private void createSearchArea() {
        if (this.m_search == null) {
            this.m_search = new SearchField();
            if (this.m_southPanel == null) {
                this.m_southPanel = new JPanel();
                this.m_southPanel.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
                this.m_host.add((Component)this.m_southPanel, "South");
            }
            this.m_southPanel.add((Component)this.m_search);
            this.m_host.revalidate();
        }
    }

    protected String getToolbarId() {
        return this.getViewType() + ".Toolbar";
    }

    private void removeToolbar() {
        if (this.m_toolbar != null) {
            if (this.m_northPanel != null) {
                this.m_northPanel.remove((Component)this.m_toolbar);
                this.m_northPanel.revalidate();
            }
            this.m_toolbar.dispose();
            this.m_toolbar = null;
        }
    }

    private void removeSearchArea() {
        if (this.m_search != null) {
            if (this.m_southPanel != null) {
                this.m_southPanel.remove((Component)this.m_search);
                this.m_southPanel.revalidate();
            }
            this.m_search = null;
        }
    }

    public final Component getGUI() {
        this.createGUI();
        return this.m_host;
    }

    public NavigatorTree getTree() {
        return this.m_tree;
    }

    public String getTreeID() {
        return "nav-" + this.getId();
    }

    public boolean canCollapse(NavigatorTreeNode navigatorTreeNode) {
        assert (this.m_tree != null);
        if (this.m_tree.isRootVisible()) {
            return true;
        }
        NavigatorTreeNode navigatorTreeNode2 = this.m_tree.getRoot();
        return navigatorTreeNode2 != navigatorTreeNode;
    }

    public void expandVisibleRoot(NavigatorTree navigatorTree) {
        CustomTreeModel customTreeModel;
        NavigatorTreeNode navigatorTreeNode = navigatorTree.getRoot();
        navigatorTree.expand(navigatorTreeNode, false);
        if (!navigatorTree.isRootVisible() && (customTreeModel = navigatorTree.getModel()).getChildCount(navigatorTreeNode) > 0) {
            navigatorTree.expand((NavigatorTreeNode)customTreeModel.getChild(navigatorTreeNode, 0), false);
        }
    }

    public Context getContext(EventObject eventObject) {
        Context context;
        if (this.m_ui != null) {
            context = this.m_ui.getContext(eventObject);
            context.setView((View)this);
        } else {
            context = Context.newIdeContext((View)this, (EventObject)eventObject);
        }
        return context;
    }

    public final Controller getController() {
        if (this.m_controller == null) {
            this.m_controller = new Controller(){
                private Controller m_viewController;
                private Controller m_implementationController;
                {
                    this.m_viewController = new NavigatorViewController(NavigatorWindow.this);
                    this.m_implementationController = NavigatorWindow.this.createController();
                }

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    return this.m_implementationController != null && this.m_implementationController.handleEvent(ideAction, context) || this.m_viewController.handleEvent(ideAction, context);
                }

                public boolean update(IdeAction ideAction, Context context) {
                    return this.m_implementationController != null && this.m_implementationController.update(ideAction, context) || this.m_viewController.update(ideAction, context);
                }
            };
        }
        return this.m_controller;
    }

    protected abstract Controller createController();

    @Override
    public Component getViewableSelectionComponent() {
        this.createGUI();
        return this.m_ui.getJTree();
    }

    protected Element[] getSelectionFromUI() {
        return this.m_ui != null ? this.m_ui.getSelection() : super.getSelectionFromUI();
    }

    @Override
    protected UIUtils.MousePopupTriggerListener getMousePopupTriggerListener() {
        return null;
    }
}

