/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.navigator.ConnectionOwner;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.DatabaseOverlayClient;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.db.model.ConnectionStoreNode;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ideri.util.Product;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.DatabaseConnectionStores;

public class Databases
extends DefaultContainer
implements ConnectionListener,
ConnectionStoreNode,
ConnectionOwner {
    private String m_id;
    private String m_label;
    private String m_tooltip;

    public Databases(String string) {
        this.m_id = string;
        if ("IdeConnections".equals(this.m_id) && Product.isRaptor()) {
            this.m_tooltip = this.m_label = DatabaseNavigatorResources.getString("STANDALONE_NAVIGATOR_LABEL");
        } else {
            DatabaseConnectionStores databaseConnectionStores = DatabaseConnectionStores.getInstance();
            this.m_label = databaseConnectionStores.getShortLabel(this.m_id);
            this.m_tooltip = databaseConnectionStores.getToolTipText(this.m_id);
        }
    }

    public String getStoreId() {
        return this.m_id;
    }

    public String getShortLabel() {
        return this.m_label;
    }

    public String getLongLabel() {
        return this.getToolTipText();
    }

    public Icon getIcon() {
        return DatabaseConnectionStores.getInstance().getIcon(this.m_id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openImpl() throws IOException {
        Connections connections = Connections.getInstance();
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            for (String string : connections.getConnNames(this.m_id)) {
                DatabaseConnection databaseConnection = Databases.getConnectionNode(string, true);
                if (databaseConnection == null) continue;
                this.updateOverlaysForNode(databaseConnection);
                this._children.add(databaseConnection);
            }
        }
        if (Boolean.parseBoolean(System.getProperty("sqldev.tnsping", "true"))) {
            this.refreshPingTimes();
        }
        connections.addConnectionListener(this);
    }

    public static DatabaseConnection getConnectionNode(String string, boolean bl) {
        DatabaseConnection databaseConnection = null;
        URL uRL = DBURLFormatHelper.getURL("sqldev.nav", string);
        databaseConnection = bl ? DatabaseConnection.findOrCreateConnectionNode(uRL) : DatabaseConnection.findConnectionNode(uRL);
        return databaseConnection;
    }

    protected void closeImpl() throws IOException {
        Connections.getInstance().removeConnectionListener(this);
    }

    @Override
    public void connectionAdded(ConnectionEvent connectionEvent) {
        DatabaseConnection databaseConnection;
        String string = connectionEvent.getConnectionName();
        if (Connections.isUnsharedWorksheetConnection(string)) {
            return;
        }
        String string2 = Connections.getStoreName(string);
        if (ModelUtil.areEqual((Object)string2, (Object)this.m_id) && (databaseConnection = Databases.getConnectionNode(string, true)) != null) {
            this.updateOverlaysForNode(databaseConnection);
            this.add(databaseConnection, true);
        }
    }

    private void updateOverlaysForNode(DatabaseConnection databaseConnection) {
        IconOverlayTracker iconOverlayTracker = DatabaseOverlayClient.getTracker();
        if (iconOverlayTracker != null) {
            iconOverlayTracker.validateOverlay((Element)databaseConnection);
            iconOverlayTracker.repaintOverlays();
        }
    }

    @Override
    public void connectionRemoved(ConnectionEvent connectionEvent) {
        DatabaseConnection databaseConnection;
        String string = connectionEvent.getConnectionName();
        String string2 = Connections.getStoreName(string);
        if (ModelUtil.areEqual((Object)string2, (Object)this.m_id) && (databaseConnection = Databases.getConnectionNode(string, false)) != null) {
            this.remove(databaseConnection, true);
        }
    }

    @Override
    public void connectionModified(ConnectionEvent connectionEvent) {
        String string = connectionEvent.getOldName();
        String string2 = Connections.getStoreName(string);
        if (ModelUtil.areEqual((Object)string2, (Object)this.m_id)) {
            String string3 = connectionEvent.getConnectionName();
            if (ModelUtil.areDifferent((Object)string, (Object)string3)) {
                DatabaseConnection databaseConnection = Databases.getConnectionNode(string, false);
                if (databaseConnection != null) {
                    URL uRL = DBURLFormatHelper.getURL("sqldev.nav", string3);
                    databaseConnection.setURL(uRL);
                }
            } else {
                DatabaseConnection databaseConnection = Databases.getConnectionNode(string3, false);
                if (databaseConnection != null) {
                    UpdateMessage.firePropertiesChanged((Subject)databaseConnection, (PropertyChangeEvent[])new PropertyChangeEvent[0], null);
                }
            }
        }
    }

    @Override
    public void connectionOpened(ConnectionEvent connectionEvent) {
    }

    @Override
    public void connectionClosed(ConnectionEvent connectionEvent) {
    }

    @Override
    public void connectionRenamed(ConnectionEvent connectionEvent) {
    }

    public void markDirty(boolean bl) {
    }

    public String getToolTipText() {
        return this.m_tooltip;
    }

    public String getStoreName() {
        return this.m_id;
    }

    public void refreshPingTimes() {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>("", true, IRaptorTaskRunMode.NO_GUI){

            protected Void doWork() throws TaskException {
                DatabaseConnection databaseConnection = null;
                for (Object e : Databases.this._children) {
                    databaseConnection = (DatabaseConnection)e;
                    if (!Connections.getInstance().isOracle(databaseConnection.getQualifiedConnectionName())) continue;
                    databaseConnection.refreshPingTime();
                }
                return null;
            }
        };
        raptorTask.setCancellable(false);
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    @Override
    public Object getKey() {
        return this.getStoreId();
    }

    @Override
    public int compareTo(ConnectionOwner connectionOwner) {
        if (connectionOwner instanceof Databases) {
            String string = this.getStoreId();
            if ("IdeConnections".equals(string)) {
                return -1;
            }
            String string2 = ((Databases)connectionOwner).getStoreId();
            return "IdeConnections".equals(string2) ? 1 : string.compareTo(string2);
        }
        return -1;
    }
}

