/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.ui;

import java.net.URI;
import java.util.Comparator;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TreeItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.util.Callback;
import oracle.dbtools.raptor.metrics.ui.CacheElementLookup;

abstract class CacheElement {
    private TreeItem<CacheElement> treeItem;
    private final CacheElementLookup lookup;
    private ObservableList<CacheElement> childElements;
    private final URI id;
    private static final Comparator<CacheElement> standardElementComparator = (cacheElement, cacheElement2) -> cacheElement.toString().compareTo(cacheElement2.toString());

    CacheElement(CacheElementLookup cacheElementLookup, URI uRI) {
        String string = this.getIconPath();
        if (string != null) {
            this.treeItem = new TreeItem((Object)this, (Node)this.createImageView(string));
        }
        this.lookup = cacheElementLookup;
        this.id = uRI;
    }

    TreeItem<CacheElement> getTreeItem() {
        return this.treeItem;
    }

    String getIconPath() {
        return null;
    }

    void addChildElement(CacheElement cacheElement) {
        if (this.childElements == null) {
            this.childElements = FXCollections.observableArrayList();
        }
        if (cacheElement.treeItem != null) {
            this.treeItem.getChildren().add(cacheElement.treeItem);
        }
        if (cacheElement.getId() != null) {
            this.childElements.add((Object)cacheElement);
            this.lookup.addElement(cacheElement);
        }
    }

    void removeChildElement(CacheElement cacheElement) {
        this.remove(cacheElement);
        this.childElements.remove((Object)cacheElement);
        this.lookup.removeElement(cacheElement.getId());
    }

    void sortChildren() {
        Comparator<CacheElement> comparator = this.getChildElementComparator();
        FXCollections.sort((ObservableList)this.treeItem.getChildren(), (treeItem, treeItem2) -> comparator.compare((CacheElement)treeItem.getValue(), (CacheElement)treeItem2.getValue()));
    }

    Comparator<CacheElement> getChildElementComparator() {
        return standardElementComparator;
    }

    List<TableColumn<? extends CacheElement, String>> getTableColumns() {
        return null;
    }

    ObservableList<CacheElement> getTableRows() {
        return this.childElements;
    }

    URI getId() {
        return this.id;
    }

    CacheElementLookup getLookup() {
        return this.lookup;
    }

    <C extends CacheElement> TableColumn<C, String> createTableLeadColumn(String string, Callback<TableColumn.CellDataFeatures<C, String>, ObservableValue<String>> callback) {
        return this.createTableColumn(string, 150, callback);
    }

    <C extends CacheElement> TableColumn<C, String> createTableColumn(String string, Callback<TableColumn.CellDataFeatures<C, String>, ObservableValue<String>> callback) {
        return this.createTableColumn(string, 100, callback);
    }

    private <C extends CacheElement> TableColumn<C, String> createTableColumn(String string, int n, Callback<TableColumn.CellDataFeatures<C, String>, ObservableValue<String>> callback) {
        TableColumn tableColumn = new TableColumn(string);
        tableColumn.setMinWidth((double)n);
        tableColumn.setCellValueFactory(callback);
        return tableColumn;
    }

    private void remove(CacheElement cacheElement) {
        if (cacheElement.treeItem != null) {
            this.treeItem.getChildren().remove(cacheElement.treeItem);
        }
        if (cacheElement.childElements != null) {
            for (CacheElement cacheElement2 : cacheElement.childElements) {
                this.remove(cacheElement2);
                this.lookup.removeElement(cacheElement2.getId());
            }
            cacheElement.childElements.clear();
        }
    }

    private ImageView createImageView(String string) {
        return new ImageView(new Image(this.getClass().getClassLoader().getResourceAsStream(string)));
    }
}

