/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.sqlsource;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.metrics.engine.DXException;
import oracle.dbtools.raptor.metrics.engine.Job;
import oracle.dbtools.raptor.metrics.sqlsource.SQLJobType;
import oracle.dbtools.raptor.metrics.sqlsource.SQLSource;
import oracle.dbtools.raptor.query.ObjectQueries;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.Connections;

class SQLJob
extends Job {
    private final SQLJobType jobType;
    private final SQLSource source;
    private final ObjectQueries queries;
    private volatile Thread queryThread;
    private static final int ORACLE_STATEMENT_CANCELLED = 1013;

    SQLJob(SQLJobType sQLJobType, SQLSource sQLSource) {
        super(sQLJobType, sQLSource);
        this.jobType = sQLJobType;
        this.source = sQLSource;
        this.queries = sQLJobType.getQueries();
    }

    @Override
    public SQLJobType getJobType() {
        return this.jobType;
    }

    @Override
    public SQLSource getSource() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, List<?>> load() {
        HashMap<String, ArrayList> hashMap;
        block20: {
            hashMap = null;
            Connection connection = this.source.acquireJDBCConnection();
            if (connection == null) {
                throw new DXException("SQLJob connection not available");
            }
            HashMap<String, ArrayList> hashMap2 = new HashMap<String, ArrayList>();
            try {
                if (!Connections.getInstance().lock(connection)) break block20;
                try {
                    Query query = this.queries.getQuery(connection);
                    if (query == null) break block20;
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(false);
                    this.queryThread = Thread.currentThread();
                    ResultSet resultSet = dBUtil.executeOracleQuery(query.getSql(), query.getBindMap());
                    if (resultSet == null) {
                        SQLException sQLException = dBUtil.getLastException();
                        if (sQLException == null) {
                            throw new DXException("unknown SQL error");
                        }
                        if (sQLException.getErrorCode() != 1013 || !this.isTaskCancelled()) {
                            throw new DXException("SQLJob query error", sQLException);
                        }
                        break block20;
                    }
                    try {
                        try {
                            int n;
                            int n2 = resultSet.getMetaData().getColumnCount();
                            ArrayList[] arrayListArray = new ArrayList[n2];
                            for (n = 0; n < n2; ++n) {
                                arrayListArray[n] = new ArrayList();
                                hashMap2.put(resultSet.getMetaData().getColumnName(n + 1), arrayListArray[n]);
                            }
                            while (!this.isTaskCancelled() && resultSet.next()) {
                                for (n = 0; n < n2; ++n) {
                                    Object object = resultSet.getObject(n + 1);
                                    arrayListArray[n].add(object instanceof Comparable ? (Comparable)object : null);
                                }
                            }
                            if (!this.isTaskCancelled()) {
                                hashMap = hashMap2;
                            }
                        }
                        catch (SQLException sQLException) {
                            if (sQLException.getErrorCode() != 1013 || !this.isTaskCancelled()) {
                                throw new DXException("SQLJob query error", sQLException);
                            }
                        }
                    }
                    finally {
                        DBUtil.closeResultSet((ResultSet)resultSet);
                    }
                }
                finally {
                    Connections.getInstance().unlock(connection);
                }
            }
            finally {
                this.source.releaseJDBCConnection(connection);
            }
        }
        return hashMap;
    }

    @Override
    protected boolean cancelLoad() {
        boolean bl = false;
        Thread thread = this.queryThread;
        if (thread != null) {
            DBUtil.cancelExecution((Thread)thread);
            bl = true;
        }
        return bl;
    }
}

