/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.net.URI;
import java.util.EnumMap;
import oracle.dbtools.raptor.metrics.engine.Engine;
import oracle.dbtools.raptor.metrics.engine.InputEventImplementation;

abstract class StateMachine<S extends Enum<S>, A> {
    private final EnumMap<S, A> actionsMap;
    private S state;

    StateMachine(EnumMap<S, A> enumMap, S s) {
        this.actionsMap = enumMap;
        this.state = s;
    }

    S getState() {
        return this.state;
    }

    abstract URI getId();

    abstract Engine getEngine();

    void dispatch(InputEventImplementation<S, A> inputEventImplementation) {
        assert (Engine.isMetricsThread());
        S s = inputEventImplementation.callResponse(this.actionsMap.get(this.state));
        Engine engine = this.getEngine();
        if (engine.isTracingEnabled()) {
            engine.traceEvent(this.getId(), inputEventImplementation.getName(), ((Enum)this.state).toString(), ((Enum)s).toString());
        }
        this.state = s;
    }
}

