/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.engine.Engine;
import oracle.dbtools.raptor.metrics.engine.EngineNotification;
import oracle.dbtools.raptor.metrics.engine.ItemType;
import oracle.dbtools.raptor.metrics.engine.JobType;
import oracle.dbtools.raptor.metrics.engine.PropertyService;
import oracle.dbtools.raptor.metrics.engine.Source;
import oracle.dbtools.raptor.metrics.engine.XMLHelper;
import oracle.dbtools.raptor.metrics.listener.DXEngineListener;
import oracle.dbtools.raptor.metrics.listener.DXEvent;
import oracle.dbtools.raptor.metrics.listener.DXSourceTypeUpdate;
import oracle.dbtools.raptor.metrics.listener.DXSourceUpdate;
import oracle.xml.parser.v2.XMLElement;

public abstract class SourceType {
    private Engine engine;
    private String sourcePath;
    private long defaultMinimumInterval;
    private Map<String, ItemType> itemTypeMap;
    protected static final Logger logger = Logger.getLogger(SourceType.class.getName());

    protected SourceType(long l) {
        this.defaultMinimumInterval = l;
    }

    public URI getConnectionTypeId() {
        return DXIds.newConnectionTypeId(this.getConnectionTypeName());
    }

    public URI getSourceTypeId() {
        return DXIds.newTypeId(this.getConnectionTypeName(), this.sourcePath);
    }

    public abstract String getConnectionTypeName();

    public String getSourcePath() {
        return this.sourcePath;
    }

    protected abstract Map<String, ? extends JobType> jobTypeMap();

    protected abstract void mergeJobTypes(SourceType var1);

    protected void load(XMLHelper xMLHelper, XMLElement xMLElement) {
        this.sourcePath = xMLHelper.getStringAttribute(xMLElement, "path");
    }

    protected abstract Source createSource(String var1);

    Map<String, ItemType> itemTypeMap() {
        if (this.itemTypeMap == null) {
            this.itemTypeMap = new HashMap<String, ItemType>();
            for (JobType jobType : this.jobTypeMap().values()) {
                this.itemTypeMap.putAll(jobType.itemTypeMap());
            }
        }
        return this.itemTypeMap;
    }

    long getDefaultMinimumInterval() {
        assert (Engine.isMetricsThread());
        return this.defaultMinimumInterval;
    }

    long getMinimumInterval(Source source) {
        assert (Engine.isMetricsThread());
        return this.engine.getPropertyService().get(source.getSourceId(), "minimumInterval", this.defaultMinimumInterval);
    }

    void setMinimumInterval(Source source, long l, boolean bl) {
        assert (Engine.isMetricsThread());
        if (l != source.getMinimumInterval()) {
            this.engine.getPropertyService().set(source.getSourceId(), "minimumInterval", l, bl);
            source.setMinimumInterval(l);
            this.sendIntervalChangeNotification(source);
        }
    }

    void setDefaultMinimumInterval(long l, boolean bl) {
        assert (Engine.isMetricsThread());
        if (l != this.defaultMinimumInterval) {
            this.defaultMinimumInterval = l;
            this.sendIntervalChangeNotification();
            PropertyService propertyService = this.engine.getPropertyService();
            propertyService.set(this.getSourceTypeId(), "defaultMinimumInterval", l, bl);
        }
    }

    void attach(Engine engine) {
        assert (Engine.isMetricsThread());
        this.engine = engine;
        PropertyService propertyService = engine.getPropertyService();
        this.defaultMinimumInterval = propertyService.get(this.getSourceTypeId(), "defaultMinimumInterval", this.defaultMinimumInterval);
    }

    private void sendIntervalChangeNotification() {
        this.engine.addNotification(new EngineNotification<DXSourceTypeUpdate>(this.engine){

            @Override
            DXSourceTypeUpdate createEvent() {
                return this.createSourceTypeUpdateEvent(DXEvent.Type.SOURCE_TYPE_DEFAULT_INTERVAL, SourceType.this);
            }

            @Override
            void callListener(DXEngineListener dXEngineListener, DXSourceTypeUpdate dXSourceTypeUpdate) {
                dXEngineListener.onDefaultMinimumIntervalChange(dXSourceTypeUpdate);
            }
        });
    }

    private void sendIntervalChangeNotification(final Source source) {
        this.engine.addNotification(new EngineNotification<DXSourceUpdate>(this.engine){

            @Override
            DXSourceUpdate createEvent() {
                return this.createSourceUpdateEvent(DXEvent.Type.SOURCE_INTERVAL, source);
            }

            @Override
            void callListener(DXEngineListener dXEngineListener, DXSourceUpdate dXSourceUpdate) {
                dXEngineListener.onMinimumIntervalChange(dXSourceUpdate);
            }
        });
    }
}

