/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.metrics.engine.DXException;
import oracle.dbtools.raptor.metrics.engine.Engine;
import oracle.dbtools.raptor.metrics.engine.ListenerEntry;
import oracle.dbtools.raptor.metrics.listener.DXEngineListener;
import oracle.dbtools.raptor.metrics.listener.DXItemListener;

public class DXChannel {
    private final List<ListenerEntry> listenerEntries = new ArrayList<ListenerEntry>();
    private final List<CloseHandler> closeHandlers = new ArrayList<CloseHandler>();
    private int step = 0;

    DXChannel() {
    }

    public void addCloseHandler(CloseHandler closeHandler) {
        if (this.step > 0) {
            throw new DXException("can't add close handlers after registration");
        }
        this.closeHandlers.add(closeHandler);
    }

    public <T> void addItemListener(URI uRI, Class<? extends T> clazz, DXItemListener<T> dXItemListener) {
        this.add(Engine.getInstance().createItemListenerEntry(uRI, clazz, dXItemListener));
    }

    public void addEngineListener(DXEngineListener dXEngineListener) {
        this.add(Engine.getInstance().createEngineListenerEntry(dXEngineListener));
    }

    void add(ListenerEntry listenerEntry) {
        if (this.step > 0) {
            throw new DXException("can't add listeners after registration");
        }
        this.listenerEntries.add(listenerEntry);
    }

    void register(Engine engine) {
        if (this.step > 0) {
            throw new DXException("already registered");
        }
        ++this.step;
        engine.enqueueCommand(engine.createRegisterListenersCommand(this.listenerEntries));
    }

    void close(Engine engine) {
        if (this.step == 0) {
            throw new DXException("not registered");
        }
        if (this.step == 2) {
            throw new DXException("already closed");
        }
        ++this.step;
        for (CloseHandler closeHandler : this.closeHandlers) {
            closeHandler.onClose();
        }
        engine.enqueueCommand(engine.createUnregisterListenersCommand(this.listenerEntries));
    }

    protected void finalize() throws Throwable {
        if (this.step != 2) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "channel not unregistered from the metrics engine");
        }
        super.finalize();
    }

    public static interface CloseHandler {
        public void onClose();
    }
}

