/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.conn;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.dbtools.raptor.dialogs.conn.ConnectionInfoPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;

public class ConnectionPrompt
extends DatabaseProviderHelper.PasswordPrompter {
    private Map<String, AuthKey> m_cache = new HashMap<String, AuthKey>();

    public Connection promptForPassword(Properties properties, String string, ConnectionCreator connectionCreator) throws SQLException {
        Connection connection = null;
        String string2 = properties.getProperty("password");
        if (string2 == null) {
            AuthKey authKey = this.getAuthentication(this.getKey(properties));
            boolean bl = Boolean.parseBoolean(properties.getProperty("NoPasswordConnection", "true"));
            if (authKey != null) {
                properties.setProperty("user", authKey.m_user);
                properties.setProperty("password", authKey.m_pwd);
            } else if (bl) {
                ConnectionInfoPanel.promptForConnection(properties);
            }
        }
        connection = connectionCreator.getConnection(properties);
        this.cache(properties);
        return connection;
    }

    public void cache(Properties properties) {
        String string = this.getKey(properties);
        String string2 = properties.getProperty("password");
        String string3 = properties.getProperty("user");
        if (string != null && string2 != null) {
            this.m_cache.put(string, new AuthKey(string3, string2));
        }
    }

    public void uncache(Properties properties) {
        this.m_cache.remove(this.getKey(properties));
    }

    public void disconnect(Properties properties) {
        this.m_cache.remove(this.getKey(properties));
    }

    private AuthKey getAuthentication(String string) {
        return string != null ? this.m_cache.get(string) : null;
    }

    private String getKey(Properties properties) {
        String string = properties.getProperty("UnsharedWorksheetOriginalConnectionName");
        string = string != null ? Connections.getConnectionName(string) : properties.getProperty("ConnName");
        String string2 = string;
        return string2;
    }

    private static class AuthKey {
        final String m_pwd;
        final String m_user;

        AuthKey(String string, String string2) {
            this.m_pwd = string2;
            this.m_user = string;
        }
    }
}

