/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.writers;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.data.readservice.DataFormatException;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.Messages;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.readers.DataReadable;
import oracle.dbtools.raptor.data.readers.DataReaderException;
import oracle.dbtools.raptor.data.readers.DataReaderRegistry;
import oracle.dbtools.raptor.data.writers.ImportGen;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.log.LogManager;
import oracle.javatools.dialogs.MessageDialog;

public class ImportGenInsertScript
extends ImportGen {
    private ImportProperties _iProps;
    private boolean _isValid = false;
    private LoadFile _loadFile;
    private boolean _connLocked = false;
    private boolean _cancelled = false;
    private boolean _isRequestCancel;
    private DataReadable _reader;
    private Column[] _insCols;
    private boolean _isIgnoreAllErrors = false;
    private Integer _loadRowsLimit;
    private boolean _isLoadLimit;
    private int _errors = 0;
    private ExitCode _exitCode;
    private Logger LOGGER = Logger.getLogger(this.getClass().getName());

    public ImportGenInsertScript(ImportProperties importProperties) {
        super(importProperties);
        this._iProps = importProperties;
    }

    @Override
    public ExitCode start() {
        ExitCode exitCode = super.start();
        if (exitCode == ExitCode.EXIT_SEVERE) {
            return exitCode;
        }
        return this.validate();
    }

    @Override
    public ExitCode generate() {
        this._exitCode = ExitCode.EXIT_SUCCESS;
        this._loadRowsLimit = this._iProps.getValueInteger(ImportKeys.LOAD_LIMIT);
        boolean bl = this._isLoadLimit = this._loadRowsLimit > 0;
        if (!this._isValid) {
            return ExitCode.EXIT_SEVERE;
        }
        if (this.isBatch()) {
            this.getStream().println("SET DEFINE OFF\n");
            this.doCreateScript();
            this.doInsertScript();
            try {
                this.getStream().finishedBad();
            }
            catch (Exception exception) {
                this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            this.getStream().finished();
        } else {
            this.generateInsertScriptUI();
        }
        return this._exitCode;
    }

    private ExitCode validate() {
        this._exitCode = ExitCode.EXIT_SUCCESS;
        this._loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        this._isValid = true;
        return this._exitCode;
    }

    private ExitCode generateInsertScriptUI() {
        try {
            this.LOGGER.log(Level.INFO, Messages.getString("ImportGenerator.78"));
            String string = this._loadFile.getName();
            GenericTable genericTable = (GenericTable)this._iProps.get(ImportKeys.TABLE);
            int n = -1;
            n = string.lastIndexOf("/");
            if (n > 0) {
                string = string.substring(n + 1);
            }
            String string2 = genericTable.getTable().getTablename();
            String string3 = DataImportArb.format("TASK_FULL_NAME", string2, string);
            IRaptorTaskRunMode iRaptorTaskRunMode = IRaptorTaskRunMode.MODAL_OPTIONAL;
            DatabaseQueryTask<Void> databaseQueryTask = new DatabaseQueryTask<Void>(string3, iRaptorTaskRunMode, false, true){

                public Void doWork() {
                    ImportGenInsertScript.this.LOGGER.log(Level.INFO, Messages.getString("ImportGenerator.77"));
                    try {
                        ImportGenInsertScript.this.getStream().println("SET DEFINE OFF\n");
                        ImportGenInsertScript.this.doCreateScript();
                        ImportGenInsertScript.this.doInsertScript();
                        if (ImportGenInsertScript.this._isRequestCancel) {
                            this.requestCancel();
                        }
                    }
                    catch (Exception exception) {
                        ImportGenInsertScript.this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                    finally {
                        try {
                            ImportGenInsertScript.this.getStream().finishedBad();
                        }
                        catch (Exception exception) {
                            ImportGenInsertScript.this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        }
                    }
                    return null;
                }

                public boolean cancel() {
                    ImportGenInsertScript.this._cancelled = true;
                    return true;
                }

                @Override
                public String getConnectionName() {
                    return ImportGenInsertScript.this.getConnName();
                }

                @Override
                public String getQuery() {
                    return "";
                }
            };
            databaseQueryTask.setCancellable(true);
            databaseQueryTask.setPausable(true);
            databaseQueryTask.getDescriptor().addListener((IRaptorTaskListener)new DBTaskListener(string3));
            RaptorTaskManager.getInstance().addTask((RaptorTask)databaseQueryTask);
        }
        catch (Exception exception) {
            LogManager.getLogManager().getLogWindow().selectPage(LogManager.getLogManager().getMsgPage());
            LogManager.getLogManager().getLogWindow().activate();
            this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return this._exitCode;
    }

    private void doCreateScript() {
        if (!this.isExistingTable()) {
            String string = this.getCreateTableStatementWithComments() + "\n";
            this.getStream().println(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInsertScript() {
        int n = 0;
        Object[] objectArray = null;
        this._reader = DataReaderRegistry.getReader(this._loadFile.getType());
        this._reader.setDataFormat((ImportDataFormat)this._iProps.get(ImportKeys.IMPORT_DATA_FORMAT));
        String string = this._loadFile.getName();
        try {
            this._reader.setFileName(string);
            this._insCols = (Column[])this._iProps.get(ImportKeys.SELECTED_COLUMNS);
            if (this._iProps.get(ImportKeys.PAGEID) != null) {
                this._reader.setPage((Integer)this._iProps.get(ImportKeys.PAGEID));
            }
            this.LOGGER.log(Level.INFO, Messages.getString("ImportGenerator.74"));
            int n2 = 0;
            this._reader.start();
            ImportDataFormat importDataFormat = this.getDataFormat();
            if (importDataFormat.getSkipRows() != 0) {
                int n3 = importDataFormat.isHeader() ? importDataFormat.getSkipRows() + 1 : importDataFormat.getSkipRows();
                for (int i = 0; i < n3 && this._reader.hasMoreRows() && !this._cancelled; ++i) {
                    try {
                        this._reader.readline();
                        continue;
                    }
                    catch (DataFormatException dataFormatException) {
                        // empty catch block
                    }
                }
            } else if (importDataFormat.isHeader() && this._reader.hasMoreRows()) {
                try {
                    this._reader.readline();
                }
                catch (DataFormatException dataFormatException) {
                    // empty catch block
                }
            }
            while (this._reader.hasMoreRows() && (!this._isLoadLimit || n2 < this._loadRowsLimit)) {
                if (this._cancelled) {
                    break;
                }
                try {
                    ++n2;
                    objectArray = this._reader.readline();
                    if (objectArray == null) continue;
                    this.getStream().println(this.getInsertStatement(this.getTableName(), this._insCols, objectArray) + "\n");
                }
                catch (DataFormatException dataFormatException) {
                    ++n;
                    objectArray = dataFormatException.getColumns();
                    this.handleScriptException(n2, (Exception)((Object)dataFormatException));
                    if (this._isRequestCancel) {
                        this._cancelled = true;
                    }
                    this.getStream().println("-- " + dataFormatException.getMessage());
                    this.getStream().println("-- " + DataImportArb.getString("DATA_FORMAT_EXCEPTION_LINE"));
                    this.getStream().println("-- " + dataFormatException.getLine());
                    this.getStream().println(this.getInsertStatementForComment(this.getTableName(), this._insCols, objectArray) + "\n");
                    this.outBad("-- " + dataFormatException.getMessage());
                    this.outBad("-- " + DataImportArb.getString("DATA_FORMAT_EXCEPTION_LINE"));
                    this.outBad("-- " + dataFormatException.getLine());
                    this.outBad(this.getInsertStatement(this.getTableName(), this._insCols, objectArray) + "\n");
                }
            }
        }
        catch (DataReaderException dataReaderException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dataReaderException.getMessage(), dataReaderException);
        }
        finally {
            if (n > 0) {
                this.getStream().println("-- " + DataImportArb.getString("DATA_FORMAT_EXCEPTION_SUMMARY"));
            }
            this._reader.closeFile();
        }
    }

    private void handleScriptException(int n, Exception exception) {
        ++this._errors;
        String string = exception.getMessage();
        string = string.substring(0, string.length() - 1);
        if (!this.isBatch() && !this._isIgnoreAllErrors) {
            try {
                this.askContinueOnError(string + "\n\n" + DataImportArb.getString("TASK_PROGRESS_SCRIPT_CONTINUE"));
            }
            catch (Throwable throwable) {
                this.LOGGER.log(Level.WARNING, throwable.getStackTrace()[0].toString(), throwable);
                this._isRequestCancel = true;
            }
        }
    }

    private void askContinueOnError(String string) throws Throwable {
        final String string2 = string;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    int n = MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)string2, (String)DataImportArb.getString("TASK_SHORT_NAME"), null);
                    if (n == -1) {
                        ImportGenInsertScript.this._isRequestCancel = true;
                    } else if (n == 1) {
                        ImportGenInsertScript.this._isIgnoreAllErrors = true;
                    }
                }
                catch (Exception exception) {
                    ImportGenInsertScript.this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    ImportGenInsertScript.this._isRequestCancel = true;
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
        }
    }

    private void outBad(String string) {
        try {
            this.getStream().printlnBad(string);
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private Column getColumnFromSourceName(String string, Column[] columnArray) {
        if (string == null || columnArray == null) {
            return null;
        }
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i].getSourceColumnName() == null || !columnArray[i].getSourceColumnName().equals(string)) continue;
            return columnArray[i];
        }
        return null;
    }

    final class DBTaskListener
    extends RaptorTaskAdapter {
        private String _taskFullName;
        private String _msg = "";

        DBTaskListener(String string) {
            this._taskFullName = string;
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            RaptorTaskEvent raptorTaskEvent2 = raptorTaskEvent;
            if (raptorTaskEvent2.getTaskDescriptor().isCancelled()) {
                this._msg = this._taskFullName + ". ";
                this._msg = this._msg + DataImportArb.getString("TASK_CANCELLED");
                ImportGenInsertScript.this.LOGGER.log(Level.WARNING, this._msg);
            } else {
                this._msg = this._taskFullName + ". ";
                this._msg = this._msg + DataImportArb.getString("TASK_FAILED");
                ImportGenInsertScript.this.LOGGER.log(Level.SEVERE, this._msg);
            }
            this.finish(this._msg);
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            this._msg = this._taskFullName + ". ";
            this._msg = this._msg + DataImportArb.getString("TASK_CANCELLED");
            ImportGenInsertScript.this.getStream().println("-- " + this._msg);
            ImportGenInsertScript.this.LOGGER.log(Level.WARNING, this._msg);
            this.finish(this._msg);
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            RaptorTaskEvent raptorTaskEvent2 = raptorTaskEvent;
            if (raptorTaskEvent2.getTaskDescriptor().isCancelled()) {
                this._msg = this._taskFullName + ". ";
                this._msg = this._msg + DataImportArb.getString("TASK_FAILED");
            }
            if (this._msg.length() == 0) {
                this._msg = this._taskFullName + ". " + DataImportArb.getString("TASK_SUCCEEDED");
            }
            this.finish(this._msg);
        }

        private void finish(String string) {
            try {
                if (ImportGenInsertScript.this._connLocked) {
                    Connections.getInstance().unlock(ImportGenInsertScript.this.getConn());
                    ImportGenInsertScript.this._connLocked = false;
                }
            }
            catch (Exception exception) {
                ImportGenInsertScript.this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            ImportGenInsertScript.this.getStream().println("-- " + this._msg);
            ImportGenInsertScript.this.getStream().finished();
            if (ImportGenInsertScript.this.getStream().isBadFileUsed()) {
                try {
                    ImportGen.openSqlNodeForURL(ImportGenInsertScript.this.getStream().geturlBad());
                }
                catch (Exception exception) {
                    ImportGenInsertScript.this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            } else {
                ImportGenInsertScript.this.getStream().deleteEmptyBadFile();
            }
            ImportGenInsertScript.this.LOGGER.log(Level.INFO, Messages.getString("ImportGenerator.77"));
            if (ImportGenInsertScript.this._iProps.get(ImportKeys.URL_FOR_AUTO_OPEN) != null) {
                try {
                    ImportGen.openSqlNodeForURL((URL)ImportGenInsertScript.this._iProps.get(ImportKeys.URL_FOR_AUTO_OPEN));
                }
                catch (Exception exception) {
                    ImportGenInsertScript.this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
            this.showFinalMsg(this._msg);
        }

        private void showFinalMsg(String string) {
            if (!ImportGenInsertScript.this.isBatch()) {
                final String string2 = string;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MessageDialog.information((Component)Ide.getMainWindow(), (Object)string2, (String)DataImportArb.getString("TASK_SHORT_NAME"), null);
                        }
                        catch (Exception exception) {
                            ImportGenInsertScript.this.LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }
}

