/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.readers.DataReadable;
import oracle.dbtools.raptor.data.ui.PreviewLimitPanel;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.datatools.ui.BaseFormatOptionsPanel;
import oracle.dbtools.raptor.export.wizard.ExportWizArb;
import oracle.ide.util.Encodings;

public class ImportFormatOptionsPanel
extends BaseFormatOptionsPanel {
    private static final long serialVersionUID = 1L;
    private PreviewLimitPanel _previewLimitPanel;
    private JLabel _encodingLabel;
    private JComboBox _encodings;
    private NumericSpinBox _skipRows;
    private JLabel _skipRowsLabel;
    private JComboBox _headerLocation;
    private JComboBox _worksheet;
    private JLabel _worksheetLabel;
    private GridBagConstraints _worksheetLabelConstraints;
    private GridBagConstraints _worksheetConstraints;
    private DataReadable _datareader;

    public ImportFormatOptionsPanel(int n, String string) {
        this._dataFormat = new ImportDataFormat(n, string);
        this._options = this._dataFormat.getOptions();
    }

    public ImportFormatOptionsPanel(BaseDataFormat baseDataFormat) {
        super(baseDataFormat);
    }

    public void setDataReader(DataReadable dataReadable) {
        this._datareader = dataReadable;
    }

    public void setDataFormat(ImportDataFormat importDataFormat) {
        this._dataFormat = importDataFormat;
        this.setOptions(importDataFormat.getOptions());
    }

    public BaseDataFormat getProperties() {
        if (this._datareader.isEncodingAllowed()) {
            ((ImportDataFormat)this._dataFormat).setEncoding((String)this._encodings.getSelectedItem());
        }
        if (((ImportDataFormat)this._dataFormat).isHeaderLocationSupported()) {
            ((ImportDataFormat)this._dataFormat).setHeaderLocation(this._headerLocation.getSelectedIndex());
        }
        ((ImportDataFormat)this._dataFormat).setSkipRows(this._skipRows.getIntValue());
        ((ImportDataFormat)this._dataFormat).setUsePreviewLimit(this._previewLimitPanel.getPreviewLimitCheckBox().isSelected());
        ((ImportDataFormat)this._dataFormat).setPreviewLimit(this._previewLimitPanel.getPreviewLimitSpinBox().getIntValue());
        if (!this._dataFormat.isExcel() && !this._dataFormat.isExcelX()) {
            super.getFormatProperties();
        }
        return this._dataFormat;
    }

    public JComboBox getEncodingsComponent() {
        return this._encodings;
    }

    public NumericSpinBox getSkipRowsComponent() {
        return this._skipRows;
    }

    public JComboBox getHeaderLocationComponent() {
        return this._headerLocation;
    }

    public JCheckBox getUsePreviewLimitComponent() {
        return this._previewLimitPanel.getPreviewLimitCheckBox();
    }

    public NumericSpinBox getPreviewLimitComponent() {
        return this._previewLimitPanel.getPreviewLimitSpinBox();
    }

    public JComboBox getWorksheetComponent() {
        return this._worksheet;
    }

    @Override
    protected void addBasicComponents() {
        if (this._dataFormat.getUsage() == BaseDataFormat.IMPORT_WIZARD) {
            super.initHeader();
            this.initWizardComponents();
            this._row = 0;
            this._formatPanel.add((Component)this._header, new GridBagConstraints(0, this._row, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 0, 0, 0), 0, 0));
            if (((ImportDataFormat)this._dataFormat).isHeaderLocationSupported()) {
                this._formatPanel.add((Component)this._headerLocation, new GridBagConstraints(1, this._row, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 0, 0, 0), 0, 0));
            }
            this._formatPanel.add((Component)this._skipRowsLabel, new GridBagConstraints(2, this._row, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 24, 0, 8), 0, 0));
            this._formatPanel.add((Component)this._skipRows, new GridBagConstraints(3, this._row, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 0, 0, 0), 0, 0));
            if (this._dataFormat.getFormats().length > 0) {
                this._formatPanel.add((Component)this._formatLabel, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 0, 0, 8), 0, 0));
                this._formatPanel.add((Component)this._format, new GridBagConstraints(1, this._row, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 0, 0, 0), 0, 0));
            } else {
                ++this._row;
            }
            this._formatPanel.add((Component)this._previewLimitPanel.getPreviewLimitCheckBox(), new GridBagConstraints(2, this._row, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 24, 0, 8), 0, 0));
            this._formatPanel.add((Component)this._previewLimitPanel.getPreviewLimitSpinBox(), new GridBagConstraints(3, this._row, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 0, 0, 0), 0, 0));
            if (this._datareader == null || this._datareader.isEncodingAllowed()) {
                this._formatPanel.add((Component)this._encodingLabel, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 0, 8, 8), 0, 0));
                this._formatPanel.add((Component)this._encodings, new GridBagConstraints(1, this._row, 3, 1, 0.0, 0.0, 18, 0, new Insets(6, 0, 8, 0), 0, 0));
            }
        } else {
            super.addBasicComponents();
        }
    }

    private void initWizardComponents() {
        this._previewLimitPanel = new PreviewLimitPanel((ImportDataFormat)this._dataFormat, true);
        this._previewLimitPanel.onEntry();
        if (this._formatLabel == null && this._dataFormat.getFormats().length > 0) {
            this._formatLabel = new JLabel(StringUtils.stripMnemonic((String)ExportWizArb.getString("FORMAT")));
            this._formatLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)ExportWizArb.getString("FORMAT")));
            this._format = new JComboBox<String>(((ImportDataFormat)this._dataFormat).getFormats());
            this._formatLabel.setLabelFor(this._format);
        }
        this._format.setSelectedItem(this._dataFormat.getFormat());
        if (((ImportDataFormat)this._dataFormat).isHeaderLocationSupported()) {
            if (this._headerLocation == null) {
                this._headerLocation = new JComboBox<String>(((ImportDataFormat)this._dataFormat).getHeaderLocations());
            }
            this._headerLocation.setSelectedIndex(((ImportDataFormat)this._dataFormat).getHeaderLocation());
        }
        if (this._skipRows == null) {
            this._skipRows = new NumericSpinBox(0, Integer.MAX_VALUE);
            this._skipRowsLabel = new JLabel(StringUtils.stripMnemonic((String)DataImportArb.getString("WIZARD_PREVIEW_SKIP_ROWS")));
            this._skipRowsLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DataImportArb.getString("WIZARD_PREVIEW_SKIP_ROWS")));
            this._skipRowsLabel.setLabelFor((Component)this._skipRows);
            this._skipRows.setIntValue(0);
        } else {
            this._skipRows.setIntValue(((ImportDataFormat)this._dataFormat).getSkipRows());
        }
        if (this._datareader == null || this._datareader.isEncodingAllowed()) {
            if (this._encodingLabel == null) {
                this._encodings = new JComboBox();
                this._encodingLabel = new JLabel(StringUtils.stripMnemonic((String)ExportWizArb.getString("ENCODING")));
                this._encodingLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)ExportWizArb.getString("ENCODING")));
                this._encodingLabel.setLabelFor(this._encodings);
            }
            Encodings.initComboBox((JComboBox)this._encodings, (boolean)true, (String)((ImportDataFormat)this._dataFormat).getEncoding());
            Encodings.loadEncodings((JComboBox)this._encodings, (boolean)true, (String)((ImportDataFormat)this._dataFormat).getEncoding());
        }
    }

    @Override
    public JPanel getFormatPanel() {
        this.addBasicComponents();
        this.addFormatComponents();
        this.addLeftEnclosureListener();
        boolean bl = true;
        if (this._dataFormat.getUsage() == BaseDataFormat.IMPORT_PREFERENCES) {
            this.addFormatPreferenceComponents();
        } else {
            bl = this._datareader != null;
            this._formatPanel.setEnabled(bl);
        }
        for (Component component : this._formatPanel.getComponents()) {
            component.setEnabled(bl);
        }
        return this._formatPanel;
    }

    @Override
    protected void addOtherComponents() {
        if (this._dataFormat.isExcel() || this._dataFormat.isExcelX()) {
            this.addExcelComponents();
        }
    }

    protected void addExcelComponents() {
        if (this._dataFormat.getUsage() == BaseDataFormat.IMPORT_WIZARD && this._datareader.getNosPages() > 1) {
            this.initExcelComponents();
            this._formatPanel.add((Component)this._worksheetLabel, this._worksheetLabelConstraints);
            this._formatPanel.add((Component)this._worksheet, this._worksheetConstraints);
        }
    }

    void initExcelComponents() {
        if (this._worksheetLabel == null) {
            this._worksheetLabel = new JLabel(this._datareader.getPageLabel());
            this._worksheet = new JComboBox<String>(this._datareader.getPageNames());
            this._worksheet.setSelectedIndex(0);
            this.addExcelConstraints();
        }
    }

    void addExcelConstraints() {
        this._worksheetLabelConstraints = new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 0, 0, 8), 0, 0);
        this._worksheetConstraints = new GridBagConstraints(1, this._row, 1, 1, 0.5, 0.0, 18, 0, new Insets(6, 0, 0, 0), 0, 0);
        this._formatPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
    }
}

