/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.connections.ConnectionDialog;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.core.ImportXMLUtil;
import oracle.dbtools.raptor.data.ui.DataSummaryPanel;
import oracle.dbtools.raptor.data.writers.ImportGenerator;
import oracle.dbtools.raptor.data.writers.ImportWriteStream;
import oracle.dbtools.raptor.ddl.TargetFormat;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;

public class DataSummaryPage
extends DefaultTraversablePanel {
    protected final String ENCODING = "UTF-8";
    private JPanel savePanel;
    private JButton saveButton;
    private URLFileChooser _configChooser;
    private final FileNameExtensionFilter _configFilter = new FileNameExtensionFilter(DataImportArb.getString("CONFIG_FILE_TYPE"), "sdimp");
    private static final long serialVersionUID = -4806824652842858395L;
    private TraversableContext m_ctx;
    private DataSummaryPanel _summaryPanel = new DataSummaryPanel();
    private int _loadMethod;
    private ImportProperties _iProps;

    public void onEntry(TraversableContext traversableContext) {
        this.m_ctx = traversableContext;
        this._iProps = (ImportProperties)this.m_ctx.get("IMPORT_PROPERTIES");
        this._iProps.put(ImportKeys.FIELDSEPARATOR, DBConfig.getInstance((PropertyStorage)Preferences.getPreferences()).getString("IMPORT_DELIMITER"));
        this._loadMethod = (Integer)this._iProps.get(ImportKeys.LOAD_METHOD);
        this._summaryPanel.onEntry(traversableContext);
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        if (traversableContext.getDirection() == 1) {
            try {
                GenericTable genericTable = (GenericTable)this._iProps.get(ImportKeys.TABLE);
                Column[] columnArray = (Column[])this._iProps.get(ImportKeys.SELECTED_COLUMNS);
                for (Column column : columnArray) {
                    Column column2 = genericTable.getTable().getColumnByName(column.getName());
                    column2.setSourceColumnName(column.getSourceColumnName());
                    column2.setSourceColID(column.getSourceColID());
                    column = column2;
                }
                this._iProps.put(ImportKeys.TABLE, genericTable);
                ImportWriteStream importWriteStream = this.createPrintStream();
                this._iProps.put(ImportKeys.URL_FOR_AUTO_OPEN, importWriteStream.geturl());
                this._iProps.put(ImportKeys.IMPORT_WRITE_STREAM, importWriteStream);
                this._iProps.put(ImportKeys.IS_BATCH, false);
                this._iProps.put(ImportKeys.ERROR_LIMIT, 0);
                ImportGenerator importGenerator = new ImportGenerator(this._iProps);
                importGenerator.gen();
            }
            catch (Exception exception) {
                Logger.getLogger(ConnectionDialog.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    public DataSummaryPage() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(DataImportArb.getString("SAVE_CONFIG"));
        this.add(this.getSaveButton(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)((Object)this._summaryPanel), new GridBagConstraints(0, 2, 2, 1, 0.5, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private String getSummary() {
        this._iProps = (ImportProperties)this.m_ctx.get("IMPORT_PROPERTIES");
        ImportWriteStream importWriteStream = null;
        ImportGenerator importGenerator = null;
        try {
            importWriteStream = this.createPrintStream();
            this._iProps.put(ImportKeys.URL_FOR_AUTO_OPEN, importWriteStream.geturl());
            this._iProps.put(ImportKeys.IS_BATCH, false);
            this._iProps.put(ImportKeys.IMPORT_WRITE_STREAM, importWriteStream);
            importGenerator = new ImportGenerator(this._iProps);
        }
        catch (IOException iOException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        return importGenerator.getExternalTableText();
    }

    public static void main(String[] stringArray) {
        JDialog jDialog = new JDialog();
        DataSummaryPage dataSummaryPage = new DataSummaryPage();
        jDialog.add((Component)((Object)dataSummaryPage));
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jDialog.setVisible(Boolean.TRUE);
    }

    protected JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton(DataImportArb.getString("CONFIG_SAVE_STATE"));
            this.saveButton.setIcon(RaptorImagesArb.getIcon("GEAR"));
            this.saveButton.setToolTipText(DataImportArb.getString("SAVE_CONFIG_TIP"));
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DataSummaryPage.this.saveConfig();
                }
            });
        }
        return this.saveButton;
    }

    public void saveConfig() {
        String string = DataImportArb.getString("SAVE_CONFIG_DIALOG_TITLE");
        JPanel jPanel = new JPanel(new GridBagLayout());
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_saveimportconfig_html");
        this._configChooser = new URLFileChooser();
        LoadFile loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        this._configChooser.setCurrentDirectory(new File(loadFile.getName()).getParentFile());
        this._configChooser.setFileFilter(this._configFilter);
        int n = this._configChooser.showSaveDialog((Component)((Object)this), string);
        if (n == 0) {
            File file = this._configChooser.getSelectedFile();
            TargetFormat targetFormat = new TargetFormat(1, 1);
            targetFormat.setSaveAsType(0);
            String string2 = null;
            if (file != null && !(string2 = file.getPath()).contains(".")) {
                string2 = string2 + ".sdimp";
                file = new File(string2);
            }
            targetFormat.setSaveAs(string2);
            int n2 = targetFormat.validateSaveAs((Component)((Object)this));
            if (n2 == 1) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)targetFormat.getValidationMessage(), (String)DataImportArb.getString("OPEN_CONFIG_ERROR_TITLE"), (String)"IMPORT_FILE_ERROR");
            } else if (n2 == 0) {
                ImportXMLUtil importXMLUtil = new ImportXMLUtil();
                importXMLUtil.saveConfigOptions(file, this._iProps);
            }
        }
    }

    private ImportWriteStream createPrintStream() throws IOException, UnsupportedEncodingException {
        String string = Ide.getEnvironOptions().getEncoding();
        LoadFile loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        String string2 = loadFile.getName();
        int n = string2.lastIndexOf(File.separator);
        if (n > 0) {
            string2 = string2.substring(n + 1);
        }
        string2 = string2.replace(".", "-");
        ImportWriteStream importWriteStream = new ImportWriteStream(string2, string);
        return importWriteStream;
    }
}

