/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.Table;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.Messages;
import oracle.dbtools.raptor.data.core.ColumnChangeEvent;
import oracle.dbtools.raptor.data.core.ColumnChangeListener;
import oracle.dbtools.raptor.data.core.DataType;
import oracle.dbtools.raptor.data.ui.ColumnPropertiesPanel;
import oracle.dbtools.raptor.data.ui.DataPreviewGizmo;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.javatools.util.ModelUtil;

abstract class ColumnPropertyPanel
extends JPanel {
    private static final long serialVersionUID = 7720631577011179873L;
    protected final DataPreviewGizmo m_gizmo;
    protected Column currentSrcColumn;
    protected Table m_table;
    protected JLabel nameLabel;
    protected JLabel typeLabel;
    protected JLabel scaleLabel;
    protected JLabel precisionLabel;
    protected JLabel defaultLabel;
    protected JTextField nameField;
    protected Component typeField;
    protected JTextField scaleField;
    protected Component precisionField;
    protected JTextField defaultField;
    protected JCheckBox nullCheck;
    protected JLabel commentLabel;
    protected JTextArea commentArea;
    protected JScrollPane commentPane;
    protected JPanel dataPanel = new JPanel();
    protected GridBagConstraints precisionTextfieldConstraints;
    protected GridBagConstraints scaleTextfieldConstraints;
    protected GridBagConstraints precisionLabelConstraints;
    protected GridBagConstraints scaleLabelConstraints;
    protected GridBagConstraints dateMaskLblConstraints;
    protected GridBagConstraints dateMaskConstraints;
    protected Column column;
    protected GridBagConstraints typeFieldConstraints = new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
    private ArrayList<ColumnChangeListener> listeners = new ArrayList();
    private static final String[] DATE_MASKS = new String[]{"RRRR-MM-DD", "RR-MM-DD", "RRRR-MON-DD", "RR-MON-DD", "YYYY-MM-DD", "YY-MM-DD", "YYYY-MON-DD", "YY-MON-DD"};
    private static final String[] TIMESTAMP_MASKS = new String[]{"YYYY-MM-DD HH24:MI:SS.FF"};
    private static final String[] TIMESTAMP_TZ_MASKS = new String[]{"YYYY-MM-DD HH24:MI:SS.FF TZH:TZM", "YYYY-MM-DD HH24:MI:SS.FF TZR"};
    protected DefaultComboBoxModel<String> dateMaskModel;
    protected DefaultComboBoxModel<String> timestampMaskModel;
    protected DefaultComboBoxModel<String> timestamptzMaskModel;
    protected DefaultComboBoxModel<String> timestampltzMaskModel;
    protected JComboBox<String> dateMask = new JComboBox();
    protected JLabel dateMaskLbl;

    public ColumnPropertyPanel(DataPreviewGizmo dataPreviewGizmo, Connection connection) {
        super(new GridBagLayout());
        this.dateMask.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    ColumnPropertyPanel.this.column.setFormat((String)((JComboBox)itemEvent.getSource()).getSelectedItem());
                    ColumnPropertyPanel.this.firelisteners(new ColumnChangeEvent(ColumnPropertyPanel.this.column, ColumnChangeEvent.Type.FORMAT));
                }
            }
        });
        ((JTextField)this.dateMask.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.valueChanged(documentEvent);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.valueChanged(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.valueChanged(documentEvent);
            }

            void valueChanged(DocumentEvent documentEvent) {
                String string = "";
                try {
                    string = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ColumnPropertyPanel.this.column.setFormat(string);
                ColumnPropertyPanel.this.firelisteners(new ColumnChangeEvent(ColumnPropertyPanel.this.column, ColumnChangeEvent.Type.FORMAT));
            }
        });
        this.dateMaskModel = new DefaultComboBoxModel(new Vector(DATE_MASKS.length + 2, 5));
        this.dateMaskModel.addElement("");
        this.dateMask.setModel(this.dateMaskModel);
        try {
            this.addDateMask(((OracleNLSProvider)NLSProvider.getProvider((Connection)connection)).getOraDATEFormat().toPattern());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        for (String string : DATE_MASKS) {
            this.addDateMask(string);
        }
        this.timestampMaskModel = new DefaultComboBoxModel(new Vector(TIMESTAMP_MASKS.length + 2, 5));
        this.timestampMaskModel.addElement("");
        this.dateMask.setModel(this.timestampMaskModel);
        try {
            this.addDateMask(((OracleNLSProvider)NLSProvider.getProvider((Connection)connection)).getOraTIMESTAMPFormat().toPattern());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        for (String string : TIMESTAMP_MASKS) {
            this.addDateMask(string);
        }
        this.timestamptzMaskModel = new DefaultComboBoxModel(new Vector(TIMESTAMP_TZ_MASKS.length + 2, 5));
        this.timestamptzMaskModel.addElement("");
        this.dateMask.setModel(this.timestamptzMaskModel);
        try {
            this.addDateMask(((OracleNLSProvider)NLSProvider.getProvider((Connection)connection)).getOraTIMESTAMPTZFormat().toPattern());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        for (String string : TIMESTAMP_TZ_MASKS) {
            this.addDateMask(string);
        }
        this.timestampltzMaskModel = new DefaultComboBoxModel(new Vector(TIMESTAMP_MASKS.length + 2, 5));
        this.timestampltzMaskModel.addElement("");
        this.dateMask.setModel(this.timestampltzMaskModel);
        try {
            this.addDateMask(((OracleNLSProvider)NLSProvider.getProvider((Connection)connection)).getOraTIMESTAMPLTZFormat().toPattern());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        for (String string : TIMESTAMP_MASKS) {
            this.addDateMask(string);
        }
        this.setBorder(BorderFactory.createTitledBorder(DataImportArb.getString("DATA_MAPPING_TGT_COLUMNS")));
        this.m_gizmo = dataPreviewGizmo;
        this.nameLabel = new JLabel();
        this.nameLabel.setText(DataImportArb.getString("COLUMN_NAME_LABEL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0);
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.typeLabel = new JLabel();
        this.typeLabel.setText(DataImportArb.getString("COLUMN_DATATYPE_LABEL"));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.add((Component)this.typeLabel, gridBagConstraints2);
        this.precisionLabel = new JLabel();
        this.precisionLabel.setText(DataImportArb.getString("COLUMN_PRECISION_LABEL"));
        this.precisionLabelConstraints = new GridBagConstraints();
        this.precisionLabelConstraints.insets = new Insets(5, 5, 0, 5);
        this.precisionLabelConstraints.gridy = 3;
        this.precisionLabelConstraints.gridx = 0;
        this.precisionLabelConstraints.anchor = 13;
        this.add((Component)this.precisionLabel, this.precisionLabelConstraints);
        this.scaleLabel = new JLabel();
        this.scaleLabel.setText(DataImportArb.getString("COLUMN_SCALE_LABEL"));
        this.scaleLabelConstraints = new GridBagConstraints();
        this.scaleLabelConstraints.insets = new Insets(5, 5, 0, 5);
        this.scaleLabelConstraints.gridy = 4;
        this.scaleLabelConstraints.gridx = 0;
        this.scaleLabelConstraints.anchor = 13;
        this.add((Component)this.scaleLabel, this.scaleLabelConstraints);
        this.dateMaskLbl = new JLabel();
        this.dateMaskLbl.setText(Messages.getString("ColumnPropertyPanel.0"));
        this.dateMaskLblConstraints = new GridBagConstraints();
        this.dateMaskLblConstraints.insets = new Insets(5, 5, 0, 5);
        this.dateMaskLblConstraints.gridy = 5;
        this.dateMaskLblConstraints.gridx = 0;
        this.dateMaskLblConstraints.anchor = 13;
        this.defaultLabel = new JLabel();
        this.defaultLabel.setText(DataImportArb.getString("COLUMN_DEFAULT_LABEL"));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints3.gridy = 6;
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.anchor = 13;
        this.add((Component)this.defaultLabel, gridBagConstraints3);
        this.precisionTextfieldConstraints = new GridBagConstraints();
        this.precisionTextfieldConstraints.gridwidth = 2;
        this.precisionTextfieldConstraints.insets = new Insets(5, 5, 0, 5);
        this.precisionTextfieldConstraints.fill = 2;
        this.precisionTextfieldConstraints.gridy = 3;
        this.precisionTextfieldConstraints.gridx = 1;
        this.scaleField = new JTextField();
        this.scaleTextfieldConstraints = new GridBagConstraints();
        this.scaleTextfieldConstraints.gridwidth = 2;
        this.scaleTextfieldConstraints.insets = new Insets(5, 5, 0, 5);
        this.scaleTextfieldConstraints.fill = 2;
        this.scaleTextfieldConstraints.weightx = 1.0;
        this.scaleTextfieldConstraints.gridy = 4;
        this.scaleTextfieldConstraints.gridx = 1;
        this.add((Component)this.scaleField, this.scaleTextfieldConstraints);
        this.scaleField.setEnabled(true);
        this.dateMaskConstraints = new GridBagConstraints();
        this.dateMaskConstraints.gridwidth = 2;
        this.dateMaskConstraints.insets = new Insets(5, 5, 0, 5);
        this.dateMaskConstraints.fill = 2;
        this.dateMaskConstraints.weightx = 1.0;
        this.dateMaskConstraints.gridy = 5;
        this.dateMaskConstraints.gridx = 1;
        this.dateMask.setEditable(true);
        this.addDateMask();
        this.defaultField = new JTextField();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.gridy = 6;
        gridBagConstraints4.gridx = 2;
        this.add((Component)this.defaultField, gridBagConstraints4);
        this.nullCheck = new JCheckBox(Messages.getString("ColumnPropertyPanel.2"));
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.weightx = 0.0;
        gridBagConstraints5.gridy = 6;
        gridBagConstraints5.gridx = 0;
        this.add((Component)this.nullCheck, gridBagConstraints5);
        this.commentLabel = new JLabel();
        this.commentLabel.setText(DataImportArb.getString("COLUMN_COMMENT_LABEL"));
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints6.gridy = 7;
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridwidth = 2;
        gridBagConstraints6.anchor = 17;
        this.add((Component)this.commentLabel, gridBagConstraints6);
        this.commentArea = new JTextArea();
        this.commentArea.setRows(4);
        this.commentPane = new JScrollPane(this.commentArea);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints7.fill = 1;
        gridBagConstraints7.weighty = 0.2;
        gridBagConstraints7.gridwidth = 3;
        gridBagConstraints7.gridheight = 8;
        gridBagConstraints7.gridy = 8;
        gridBagConstraints7.gridx = 0;
        this.add((Component)this.commentPane, gridBagConstraints7);
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.insets = new Insets(16, 5, 0, 5);
        gridBagConstraints8.fill = 1;
        gridBagConstraints8.weighty = 0.8;
        gridBagConstraints8.gridwidth = 3;
        gridBagConstraints8.gridy = 16;
        gridBagConstraints8.gridx = 0;
        this.add((Component)this.m_gizmo.getUIOneCol(0), gridBagConstraints8);
        this.removeDateMask();
    }

    protected void addPrecisionScale() {
        this.add((Component)this.precisionLabel, this.precisionLabelConstraints);
        this.add((Component)this.scaleLabel, this.scaleLabelConstraints);
        this.add(this.precisionField, this.precisionTextfieldConstraints);
        this.add((Component)this.scaleField, this.scaleTextfieldConstraints);
        this.revalidate();
        this.repaint();
    }

    protected void removePrecisionScale() {
        this.remove(this.precisionLabel);
        this.remove(this.scaleLabel);
        this.remove(this.precisionField);
        this.remove(this.scaleField);
        this.revalidate();
        this.repaint();
    }

    protected void addPrecision() {
        this.add((Component)this.precisionLabel, this.precisionLabelConstraints);
        this.add(this.precisionField, this.precisionTextfieldConstraints);
        if (this.column != null && !(this.precisionField instanceof JComboBox)) {
            ((JTextField)this.precisionField).setText(String.valueOf(this.column.getPrecision()));
        }
        this.revalidate();
        this.repaint();
    }

    protected void removePrecision() {
        this.remove(this.precisionLabel);
        this.remove(this.precisionField);
        this.revalidate();
        this.repaint();
    }

    protected void addScale() {
        this.add((Component)this.scaleLabel, this.scaleLabelConstraints);
        this.add((Component)this.scaleField, this.scaleTextfieldConstraints);
        this.enableScale();
        if (this.column != null) {
            this.scaleField.setText(String.valueOf(this.column.getScale()));
        }
        this.revalidate();
        this.repaint();
    }

    protected void enableScale() {
        String string = null;
        if (this.typeField instanceof JComboBox) {
            string = ((JComboBox)this.typeField).getSelectedItem().toString();
        } else if (this.typeField instanceof JTextField) {
            string = ((JTextField)this.typeField).getText();
        }
        String string2 = this.precisionField instanceof JComboBox ? ((JComboBox)this.precisionField).getSelectedItem().toString() : ((JTextField)this.precisionField).getText();
        this.scaleField.setEnabled(false);
        if (ModelUtil.hasLength((String)string2) && DataType.NUMBER.toString().equals(string)) {
            String string3;
            if (Integer.parseInt(string2.trim()) > 0) {
                this.scaleField.setEnabled(true);
            }
            if (ModelUtil.hasLength((String)(string3 = this.scaleField.getText())) && Integer.parseInt(string3.trim()) == 200) {
                this.scaleField.setText("0");
            }
        }
    }

    protected void removeScale() {
        this.remove(this.scaleLabel);
        this.remove(this.scaleField);
        this.revalidate();
        this.repaint();
    }

    protected void addDateMask() {
        this.add((Component)this.dateMaskLbl, this.dateMaskLblConstraints);
        this.add(this.dateMask, this.dateMaskConstraints);
        this.revalidate();
        this.repaint();
    }

    protected void removeDateMask() {
        this.remove(this.dateMaskLbl);
        this.remove(this.dateMask);
        this.revalidate();
        this.repaint();
    }

    public static void main(String[] stringArray) {
        JDialog jDialog = new JDialog();
        ColumnPropertiesPanel columnPropertiesPanel = new ColumnPropertiesPanel(null, null, null);
        jDialog.add(columnPropertiesPanel);
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jDialog.setVisible(true);
    }

    abstract void setColumn(Column var1);

    public Column getColumn() {
        return this.column;
    }

    protected void setComment(String string) {
        this.commentArea.setText(string);
    }

    protected String getComment() {
        return this.commentArea.getText();
    }

    protected void setNullable(boolean bl) {
        this.nullCheck.setSelected(bl);
    }

    protected boolean setNullable() {
        return this.nullCheck.isSelected();
    }

    protected void setScale(int n) {
        if (this.scaleField != null) {
            this.scaleField.setText(String.valueOf(n));
        }
    }

    protected int getScale() {
        if (this.scaleField != null) {
            return Integer.parseInt(this.scaleField.getText());
        }
        return 0;
    }

    protected void setPrecision(int n) {
        ((JTextField)this.precisionField).setText(String.valueOf(n));
    }

    protected int getPrecision() {
        if (this.precisionField != null) {
            if (this.precisionField instanceof JComboBox) {
                JComboBox jComboBox = (JComboBox)this.precisionField;
                return Integer.parseInt(((JTextField)jComboBox.getEditor().getEditorComponent()).getText());
            }
            return Integer.parseInt(((JTextField)this.precisionField).getText());
        }
        return 0;
    }

    protected void setPrecision(int n, int n2, String string) {
        String string2 = String.valueOf(n);
        String string3 = String.valueOf(n2);
        if (this.precisionField instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)this.precisionField;
            int n3 = this.getRoundedPrecision(n2, string);
            this.addPrecisionItems(n2, n3);
            jComboBox.setSelectedItem(n != n2 ? n : n3);
        } else {
            ((JTextField)this.precisionField).setText(string2);
        }
    }

    private int getRoundedPrecision(int n, String string) {
        if (string.equals(DataType.VARCHAR2.toString()) || string.equals(DataType.NCHAR.toString()) || string.equals(DataType.NVARCHAR2.toString())) {
            if (ColumnPropertyPanel.isBetween(n, 0, 25)) {
                return 26;
            }
            if (ColumnPropertyPanel.isBetween(n, 17, 100)) {
                return 128;
            }
            if (ColumnPropertyPanel.isBetween(n, 101, 200)) {
                return 256;
            }
            if (ColumnPropertyPanel.isBetween(n, 201, 1000)) {
                return 1024;
            }
            if (ColumnPropertyPanel.isBetween(n, 1001, 1500)) {
                return 2048;
            }
            return 4000;
        }
        if (string.equals(DataType.NUMBER.toString())) {
            return n < 36 ? n + 2 : 38;
        }
        if (string.equals(DataType.FLOAT.toString())) {
            return n < 124 ? n + 2 : 126;
        }
        return n;
    }

    private static boolean isBetween(int n, int n2, int n3) {
        return n2 <= n && n <= n3;
    }

    private void addPrecisionItems(int n, int n2) {
        if (n > n2) {
            this.swap(n, n2);
        }
        JComboBox jComboBox = (JComboBox)this.precisionField;
        this.addComboNum(jComboBox, n);
        this.addComboNum(jComboBox, n2);
    }

    private void swap(int n, int n2) {
        int n3 = n2;
        n2 = n;
        n = n3;
    }

    private void addComboNum(JComboBox<String> jComboBox, int n) {
        boolean bl = false;
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            if (!jComboBox.getItemAt(i).equals(n)) continue;
            bl = true;
        }
        if (!bl) {
            jComboBox.addItem(String.valueOf(n));
        }
    }

    abstract void setDataType(String var1);

    abstract void setColumnName(String var1);

    abstract void switchColumn(Column var1);

    public void enabled(boolean bl) {
        this.precisionField.setEnabled(bl);
        this.scaleField.setEnabled(bl);
        this.commentArea.setEnabled(bl);
        this.nullCheck.setEnabled(bl);
        this.defaultField.setEnabled(bl);
    }

    public void setDataTable(GenericTable genericTable) {
        this.setTable(genericTable);
    }

    abstract void setTable(GenericTable var1);

    abstract Column getColumnDetails();

    public void addColumnChangeListener(ColumnChangeListener columnChangeListener) {
        this.listeners.add(columnChangeListener);
    }

    public void removeColumnChangeListener(ColumnChangeListener columnChangeListener) {
        this.listeners.remove(columnChangeListener);
    }

    public void firelisteners(ColumnChangeEvent columnChangeEvent) {
        Iterator<ColumnChangeListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().columnChanged(columnChangeEvent);
        }
    }

    public JComboBox<String> getDateMask() {
        return this.dateMask;
    }

    public void setDateMaskModel(String string) {
        this.setDateMaskModel(string, null);
    }

    public void setDateMaskModel(String string, String string2) {
        if (string.equals(DataType.DATE.toString())) {
            this.dateMask.setModel(this.dateMaskModel);
        } else if (string.equals(DataType.TIMESTAMP.toString())) {
            this.dateMask.setModel(this.timestampMaskModel);
        } else if (string.equals(DataType.TIMESTAMPTZ.toString())) {
            this.dateMask.setModel(this.timestamptzMaskModel);
        } else if (string.equals(DataType.TIMESTAMPLTZ.toString())) {
            this.dateMask.setModel(this.timestampltzMaskModel);
        } else {
            return;
        }
        if (string2 != null) {
            this.setDateMask(string2);
        }
    }

    public void setDateMask(String string) {
        if (this.dateMask != null && string != null) {
            for (int i = 0; i < this.dateMask.getItemCount(); ++i) {
                if (!this.dateMask.getItemAt(i).equalsIgnoreCase(string)) continue;
                this.dateMask.setSelectedIndex(i);
                return;
            }
            this.dateMask.addItem(string);
            this.dateMask.setSelectedItem(string);
        }
    }

    public void addDateMask(String string) {
        if (this.dateMask != null) {
            for (int i = 0; i < this.dateMask.getItemCount(); ++i) {
                if (!this.dateMask.getItemAt(i).equalsIgnoreCase(string)) continue;
                return;
            }
            this.dateMask.addItem(string);
        }
    }
}

