/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.headless;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.data.headless.ImportCommand;
import oracle.dbtools.raptor.data.headless.ImportHeadlessResources;
import oracle.dbtools.raptor.headless.HeadlessCommandProcessor;
import oracle.dbtools.raptor.headless.HeadlessCore;
import oracle.dbtools.raptor.headless.HeadlessTask;
import oracle.dbtools.raptor.headless.InvalidCommandArgumentException;

public class ImportProcessor
implements HeadlessCommandProcessor {
    private ImportCommand _cmd;

    @Override
    public HeadlessTask<Void> parseCommandArguments(HeadlessCore headlessCore, String ... stringArray) throws InvalidCommandArgumentException {
        if (stringArray.length == 0) {
            headlessCore.printMessage(ImportHeadlessResources.getString("USAGE_STRING"));
        } else {
            if (!"IMPORT".equalsIgnoreCase(stringArray[0])) {
                headlessCore.printErrorMessage(ImportHeadlessResources.format("INVALID_COMMAND", stringArray[0]), ImportHeadlessResources.getString("USAGE_STRING"));
                throw new InvalidCommandArgumentException(ImportHeadlessResources.format("INVALID_COMMAND", stringArray[0]));
            }
            this._cmd = new ImportCommand(ImportCommand.Type.IMPORT, headlessCore);
            this.parseDefinition(stringArray);
            if (this._cmd.isHelp()) {
                headlessCore.printMessage(ImportHeadlessResources.getString(this._cmd.getHelpKey()));
            } else {
                this._cmd.validateParse();
                this._cmd.handleLog();
                this._cmd.getConfig();
                this._cmd.validate();
                return new ImportHeadlessTask(this._cmd);
            }
        }
        return null;
    }

    @Override
    public String getUsageString() {
        return ImportHeadlessResources.getString("USAGE_STRING");
    }

    private void parseDefinition(String[] stringArray) throws InvalidCommandArgumentException {
        List<String> list = this.expandDefinition(stringArray);
        String string = null;
        ArrayList<String> arrayList = null;
        for (String string2 : list) {
            if (string2.startsWith("-")) {
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                } else {
                    this.processItem(string, arrayList);
                    arrayList.clear();
                }
                string = string2.substring(1);
                continue;
            }
            arrayList.add(string2);
        }
        if (string != null) {
            this.processItem(string, arrayList);
        }
    }

    private List<String> expandDefinition(String[] stringArray) throws InvalidCommandArgumentException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 1;
        while (n < stringArray.length) {
            String string = stringArray[n++];
            arrayList.add(string);
        }
        return arrayList;
    }

    private Deque<String> tokenizeLine(String string) {
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \"", true);
        while (stringTokenizer.hasMoreTokens()) {
            arrayDeque.addLast(stringTokenizer.nextToken());
        }
        return arrayDeque;
    }

    private void processItem(String string, List<String> list) throws InvalidCommandArgumentException {
        if ("IMPORT".equalsIgnoreCase(string)) {
            if (list.size() != 1) {
                throw new InvalidCommandArgumentException(ImportHeadlessResources.format("INVALID_OPTION_VALUE", string));
            }
        } else if ("CONFIG".equalsIgnoreCase(string) || "C".equalsIgnoreCase(string)) {
            if (list.size() != 1) {
                throw new InvalidCommandArgumentException(ImportHeadlessResources.format("INVALID_OPTION_VALUE", string));
            }
            this._cmd.setConfigXML(list.get(0));
        } else if ("LOG".equalsIgnoreCase(string) || "LOG".equalsIgnoreCase(string)) {
            if (list.size() != 1) {
                throw new InvalidCommandArgumentException(ImportHeadlessResources.format("INVALID_OPTION_VALUE", string));
            }
            this._cmd.setLogFile(list.get(0));
        } else if ("HELP".equalsIgnoreCase(string) || "H".equalsIgnoreCase(string)) {
            if (list.size() != 0) {
                throw new InvalidCommandArgumentException(ImportHeadlessResources.format("INVALID_OPTION_VALUE", string));
            }
            this._cmd.isHelp(true);
        } else if (!this._cmd.processToolItem(string, list)) {
            throw new InvalidCommandArgumentException(ImportHeadlessResources.format("INVALID_OPTION", string));
        }
    }

    private static class ImportHeadlessTask
    extends HeadlessTask<Void> {
        private ImportCommand cmd;

        ImportHeadlessTask(ImportCommand importCommand) {
            super(importCommand.getType());
            this.cmd = importCommand;
        }

        protected Void doWork() throws TaskException {
            this.cmd.doCommand();
            return null;
        }
    }
}

