/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.plsql.DictionaryQuery;
import oracle.dbtools.parser.plsql.TabCol;
import oracle.dbtools.raptor.SerializedData;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.controls.OracleConnectionComboBox;
import oracle.dbtools.raptor.controls.search.AutoCompleter;
import oracle.dbtools.raptor.controls.search.BaseSearchPanel;
import oracle.dbtools.raptor.controls.search.IndependentNode;
import oracle.dbtools.raptor.controls.search.PastLookup;
import oracle.dbtools.raptor.controls.search.QueryTask;
import oracle.dbtools.raptor.controls.search.SearchPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.checktree.CheckboxTree;
import oracle.javatools.ui.checktree.TriStateNode;

public class InputTreePanel
extends BaseSearchPanel {
    private Logger logger = Logger.getLogger(SearchPanel.class.getName());
    private static final long serialVersionUID = 1L;
    private DBConnectionComboBox _dbSelector;
    static final String[] identifierTypes = new String[]{"ASSOC ARRAY", "BFILE DATATYPE", "BLOB DATATYPE", "BOOLEAN DATATYPE", "CHARACTER DATATYPE", "CLOB DATATYPE", "CONSTANT", "CURSOR", "DATE DATATYPE", "EXCEPTION", "FORMAL IN", "FORMAL IN OUT", "FORMAL OUT", "FUNCTION", "INDEX TABLE", "INTERVAL DATATYPE", "ITERATOR", "LABEL", "LIBRARY", "NESTED TABLE", "NUMBER DATATYPE", "OBJECT", "OPAQUE", "PACKAGE", "PROCEDURE", "RECORD", "REFCURSOR", "SUBTYPE", "SYNONYM", "TIME DATATYPE", "TIMESTAMP DATATYPE", "TRIGGER", "UROWID", "VARIABLE", "VARRAY"};
    static final String[] objTypes = new String[]{"TABLE", "VIEW", "SYNONYM", "INDEX", "PACKAGE", "PACKAGE BODY", "SEQUENCE", "TYPE BODY", "FUNCTION", "PROCEDURE", "TRIGGER", "TYPE", "LIBRARY", "MATERIALIZED VIEW", "MATERIALIZED VIEW LOG", "DATABASE LINK"};
    static final String[] identifierUsages = new String[]{"ASSIGNMENT", "CALL", "DECLARATION", "DEFINITION", "REFERENCE"};
    JTextField fldName = new JTextField();
    JButton lookupButton = new JButton(StringUtils.stripMnemonic((String)ControlsArb.getString("_LABEL_GO")), OracleIcons.getIcon((String)"find.png"));
    String currentSchema;
    private DefaultMutableTreeNode root = new TriStateNode((Object)"Guava");
    private DefaultTreeModel treeModel = new DefaultTreeModel(this.root);
    private CheckboxTree tree;
    static final String ALL_SCHEMAS = ControlsArb.getString("FIND_OBJECT_ALL_SCHEMAS");
    static final String ALL_OBJECTS = ControlsArb.getString("FIND_OBJECT_ALL_OBJECT_TYPES");
    static final String ALL_SOURCE = ControlsArb.getString("FIND_OBJECT_ALL_SOURCE_LINES");
    static final String WILDCARD_NAME_WILDCARD = "%" + ControlsArb.getString("FIND_OBJECT_ALL_SOURCE_LINE_PATTERN_NAME") + "%";
    static final String COLUMNS = ControlsArb.getString("FIND_OBJECT_COLUMNS");
    static final String ALL_DEPENDENCIES = ControlsArb.getString("FIND_OBJECT_ALL_DEPENDENCIES");
    static final String ALL_ID_TYPES = ControlsArb.getString("FIND_OBJECT_ALL_IDENTIFIER_TYPES");
    static final String ALL_ID_USAGES = ControlsArb.getString("FIND_OBJECT_ALL_IDENTIFIER_USAGES");
    static final int pixels = 24;
    ConnectionListener renameListener = new ConnectionListener(){

        @Override
        public void connectionAdded(ConnectionEvent connectionEvent) {
        }

        @Override
        public void connectionClosed(ConnectionEvent connectionEvent) {
            InputTreePanel.this._dbSelector.setCurrentConnection(null);
        }

        @Override
        public void connectionModified(ConnectionEvent connectionEvent) {
            switch (connectionEvent.getID()) {
                case 3: {
                    InputTreePanel.this._dbSelector.setCurrentConnection(null);
                    break;
                }
            }
        }

        @Override
        public void connectionOpened(ConnectionEvent connectionEvent) {
        }

        @Override
        public void connectionRemoved(ConnectionEvent connectionEvent) {
            InputTreePanel.this._dbSelector.setCurrentConnection(null);
        }

        @Override
        public void connectionRenamed(ConnectionEvent connectionEvent) {
        }
    };
    static final String host = TabCol.host;
    static final String user = TabCol.user;
    static final String pwd = TabCol.pwd;
    private static boolean isTest = false;

    public InputTreePanel() {
        super(new BorderLayout());
    }

    @Override
    public URL getSelectedURL() {
        return null;
    }

    protected String getConnectionName() {
        return this._dbSelector.getCurrentConnectionName();
    }

    public JList getResultsList() {
        return null;
    }

    protected int getSelectionMode() {
        return 0;
    }

    public final void removeStaticNodes(String string) {
        this.removeStaticNodes(string, this.root);
    }

    public final void removeStaticNodes(String string, DefaultMutableTreeNode defaultMutableTreeNode) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            this.removeStaticNodes(string, defaultMutableTreeNode2);
        }
        if (defaultMutableTreeNode.toString().equals(string)) {
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
        }
    }

    public void createGUI() {
        this.initConnection();
        this.fldName.getAccessibleContext().setAccessibleName(ControlsArb.getString("LABEL_NAME"));
        this.fldName.setToolTipText(ControlsArb.getString("SearchPanel.NAME_TOOLTIP"));
        this.fldName.setName("objectname");
        this.lookupButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)ControlsArb.getString("_LABEL_GO")));
        this.lookupButton.setToolTipText(ControlsArb.getString("LABEL_LOOKUP"));
        this.lookupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Connection connection = InputTreePanel.this.getConnection();
                if (connection != null) {
                    InputTreePanel.this.doSearch();
                } else {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)ControlsArb.getString("MSG_MISSING_CONN"), (String)ControlsArb.getString("MSG_MISSING_INFO"), null);
                }
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this._dbSelector.getJComboBox(), new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 2, new Insets(1, 1, 0, 0), 0, 0));
        this.fldName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    InputTreePanel.this.doSearch();
                }
            }
        });
        jPanel.add((Component)this.fldName, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 1, 0, 0), 10, 0));
        jPanel.add((Component)this.lookupButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(1, 1, 0, 0), 0, 0));
        Connection connection = this.getConnection();
        this.refreshSchemas(connection, true);
        this.addObjectTypes();
        this.addColumns();
        this.refreshTypeUsage(connection);
        this.addAllSource();
        this.addAllDependencies();
        this.tree = new CheckboxTree((TreeModel)this.treeModel);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        JScrollPane jScrollPane = new JScrollPane((Component)this.tree);
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 6, 5, 10, 1.0, 1.0, 17, 1, new Insets(1, 1, 0, 0), 0, 0));
        this.add((Component)jPanel, "Center");
        Connections.getInstance().addConnectionListener(this.renameListener);
        new AutoCompleter(this.fldName){

            @Override
            protected boolean updateListData() {
                String string = this.textComp.getText();
                LinkedList<PastLookup> linkedList = new LinkedList<PastLookup>();
                String string2 = InputTreePanel.this.getConnectionName();
                for (PastLookup pastLookup : SerializedData.getInstance().getHistory()) {
                    if (pastLookup.toString().startsWith(string) && pastLookup.connection.equals(string2)) {
                        linkedList.add(pastLookup);
                    }
                    if (10 >= linkedList.size()) continue;
                    break;
                }
                this.list.setListData(linkedList.toArray(new PastLookup[0]));
                return true;
            }

            @Override
            protected void acceptedListItem(PastLookup pastLookup) {
                if (pastLookup == null || "...".equals(pastLookup.toString())) {
                    return;
                }
                String string = this.textComp.getText();
                int n = string.length();
                try {
                    pastLookup.setOptions("", InputTreePanel.this.root);
                    InputTreePanel.this.tree.repaint();
                    this.textComp.getDocument().insertString(this.textComp.getCaretPosition(), pastLookup.toString().substring(n), null);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        };
    }

    private void refreshSchemas(final Connection connection, final boolean bl) {
        TriStateNode triStateNode = (TriStateNode)this.find(this.root, ALL_SCHEMAS);
        if (triStateNode != null) {
            this.treeModel.removeNodeFromParent((MutableTreeNode)triStateNode);
        }
        triStateNode = new TriStateNode(ALL_SCHEMAS){

            public void setNodeState(TriStateNode.NodeState nodeState, boolean bl, boolean bl2) {
                super.setNodeState(nodeState, false, bl2);
                if (nodeState == TriStateNode.NodeState.NO) {
                    TriStateNode triStateNode = (TriStateNode)InputTreePanel.this.find((DefaultMutableTreeNode)((Object)this), InputTreePanel.this.currentSchema);
                    if (triStateNode == null) {
                        return;
                    }
                    triStateNode.setNodeState(TriStateNode.NodeState.YES, false, false);
                    super.setNodeState(TriStateNode.NodeState.PARTIAL, false, false);
                }
            }
        };
        this.treeModel.insertNodeInto((MutableTreeNode)triStateNode, this.root, 0);
        if (connection == null) {
            return;
        }
        final TriStateNode triStateNode2 = triStateNode;
        new SwingWorker(){
            List<String> list = new LinkedList<String>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Integer doInBackground() throws Exception {
                ResultSet resultSet = null;
                PreparedStatement preparedStatement = null;
                try {
                    preparedStatement = connection.prepareStatement("select username from sys.all_users order by username");
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        this.list.add(resultSet.getString(1));
                    }
                }
                catch (Exception exception) {
                    InputTreePanel.this.logger.severe(exception.getMessage());
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    preparedStatement = null;
                }
                return null;
            }

            @Override
            protected void done() {
                for (String string : this.list) {
                    TriStateNode triStateNode = new TriStateNode((Object)string);
                    if (triStateNode.getLabel().equals(InputTreePanel.this.currentSchema)) {
                        triStateNode.setNodeState(TriStateNode.NodeState.YES, false, false);
                    } else {
                        triStateNode.setNodeState(bl ? TriStateNode.NodeState.NO : TriStateNode.NodeState.YES, false, false);
                    }
                    triStateNode2.add((MutableTreeNode)triStateNode);
                }
                if (this.list.size() > 1) {
                    triStateNode2.setNodeState(bl ? TriStateNode.NodeState.PARTIAL : TriStateNode.NodeState.YES, false, false);
                } else if (this.list.size() == 1) {
                    triStateNode2.setNodeState(TriStateNode.NodeState.YES, false, false);
                }
            }
        }.execute();
    }

    private void addObjectTypes() {
        TriStateNode triStateNode = new TriStateNode((Object)ALL_OBJECTS);
        this.root.add((MutableTreeNode)triStateNode);
        for (String string : objTypes) {
            triStateNode.add((MutableTreeNode)new TriStateNode((Object)string));
        }
        for (int i = 0; i < triStateNode.getChildCount(); ++i) {
            TriStateNode triStateNode2 = (TriStateNode)triStateNode.getChildAt(i);
            triStateNode2.setNodeState(TriStateNode.NodeState.YES);
        }
    }

    private void addAllSource() {
        IndependentNode independentNode = new IndependentNode(ALL_SOURCE);
        this.root.add((MutableTreeNode)((Object)independentNode));
        IndependentNode independentNode2 = new IndependentNode(WILDCARD_NAME_WILDCARD){

            @Override
            public void setNodeState(TriStateNode.NodeState nodeState, boolean bl, boolean bl2) {
                super.setNodeState(nodeState, false, false);
                if (nodeState == TriStateNode.NodeState.NO) {
                    // empty if block
                }
            }
        };
        independentNode.add((MutableTreeNode)((Object)independentNode2));
        independentNode2.setNodeState(TriStateNode.NodeState.YES);
    }

    private void addColumns() {
        this.root.add((MutableTreeNode)new TriStateNode((Object)COLUMNS));
    }

    private void addAllDependencies() {
        this.root.add((MutableTreeNode)new TriStateNode((Object)ALL_DEPENDENCIES));
    }

    private void refreshTypeUsage(Connection connection) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.find(this.root, ALL_ID_TYPES);
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.find(this.root, ALL_ID_USAGES);
        if (defaultMutableTreeNode != null) {
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
        }
        if (defaultMutableTreeNode2 != null) {
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode2);
        }
        if (connection == null) {
            return;
        }
        try {
            if (isTest) {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                int n = databaseMetaData.getDatabaseMajorVersion();
                if (n < 11) {
                    return;
                }
            } else {
                Version version = DBUtil.getDbVersion((Connection)connection);
                if (version == null) {
                    return;
                }
                int n = version.toIntArray()[0];
                if (n < 11) {
                    return;
                }
            }
            this.addIdentifierTypes();
            this.addIdentifierUsages();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addIdentifierTypes() {
        TriStateNode triStateNode = new TriStateNode((Object)ALL_ID_TYPES);
        this.treeModel.insertNodeInto((MutableTreeNode)triStateNode, this.root, 2);
        for (String string : identifierTypes) {
            triStateNode.add((MutableTreeNode)new TriStateNode((Object)string));
        }
    }

    private void addIdentifierUsages() {
        TriStateNode triStateNode = new TriStateNode((Object)ALL_ID_USAGES);
        this.treeModel.insertNodeInto((MutableTreeNode)triStateNode, this.root, 3);
        for (String string : identifierUsages) {
            triStateNode.add((MutableTreeNode)new TriStateNode((Object)string));
        }
    }

    void doSearch() {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        String[] stringArray4;
        String string;
        String string2;
        block3: {
            string2 = this.getConnectionName();
            if (string2 == null) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)ControlsArb.getString("FIND_OBJECT_GET_CONNECTION"), (String)ControlsArb.getString("FIND_OBJECT_NO_CONNECTION"), null);
                return;
            }
            string = this.fldName.getText();
            SerializedData.getInstance().logHistory(new PastLookup(string2, string, this.scanOptions("", this.root), this.captureOptions()));
            stringArray4 = this.getSchemaNames();
            stringArray3 = this.getObjectTypes();
            stringArray2 = null;
            stringArray = null;
            try {
                stringArray2 = this.getIdentifierTypes();
                stringArray = this.getIdentifierUsages();
            }
            catch (AssertionError assertionError) {
                if ("N/A".equals(((Throwable)((Object)assertionError)).getMessage())) break block3;
                this.logger.severe(((Throwable)((Object)assertionError)).getMessage());
            }
        }
        RaptorTaskManager.getInstance().addTask((RaptorTask)new QueryTask(string, string2, stringArray3, stringArray4, stringArray2, stringArray, this.isSelected(COLUMNS), this.isSelected(ALL_SOURCE), this.isSelected(WILDCARD_NAME_WILDCARD), this.isSelected(ALL_DEPENDENCIES)));
    }

    private ImageIcon captureOptions() {
        return null;
    }

    private List<String> scanOptions(String string, TreeNode treeNode) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (treeNode instanceof TriStateNode && ((TriStateNode)treeNode).getNodeState() == TriStateNode.NodeState.YES) {
            linkedList.add(string);
        }
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            TreeNode treeNode2 = treeNode.getChildAt(i);
            linkedList.addAll(this.scanOptions(string + '.' + i, treeNode2));
        }
        return linkedList;
    }

    private void initConnection() {
        this._dbSelector = new OracleConnectionComboBox();
        this._dbSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = InputTreePanel.this._dbSelector.getCurrentConnectionName();
                Properties properties = Connections.getInstance().getConnectionInfo(string);
                if (properties != null) {
                    InputTreePanel.this.currentSchema = properties.getProperty("user").toUpperCase();
                }
                Connection connection = InputTreePanel.this.getConnection();
                InputTreePanel.this.refreshSchemas(connection, true);
                InputTreePanel.this.refreshTypeUsage(connection);
                InputTreePanel.this.restoreTreeOptions(string);
            }
        });
        this._dbSelector.getAccessibleContext().setAccessibleName(ControlsArb.getString("SearchPanel.1"));
        this._dbSelector.getJComboBox().setName("Connection");
    }

    protected void restoreTreeOptions(String string) {
        List<PastLookup> list = SerializedData.getInstance().getHistory();
        for (PastLookup pastLookup : list) {
            if (!pastLookup.connection.equals(string)) continue;
            pastLookup.setOptions("", this.root);
            this.tree.repaint();
            break;
        }
    }

    public void setConnectionAndInput(String string, String string2) throws DBException {
        this._dbSelector.setCurrentConnection(string);
        Connection connection = Connections.getInstance().getConnection(string);
        Properties properties = Connections.getInstance().getConnectionInfo(this._dbSelector.getCurrentConnectionName());
        if (properties != null) {
            this.currentSchema = properties.getProperty("user").toUpperCase();
        }
        this.refreshSchemas(connection, string2 == null);
        this.refreshTypeUsage(connection);
        if (string2 != null) {
            this.fldName.setText(string2);
        }
    }

    public void setInput() throws DBException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Connection getConnection() {
        Connection connection = null;
        if (isTest) {
            try {
                Class.forName("oracle.jdbc.OracleDriver");
                return DriverManager.getConnection(host, user, TabCol.pwd);
            }
            catch (Exception exception) {
                if (!exception.getMessage().contains("IO Error: The Network Adapter could not est")) return connection;
                return null;
            }
        }
        try {
            return Connections.getInstance().getConnection(this.getConnectionName());
        }
        catch (DBException dBException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)dBException.getMessage(), (String)ControlsArb.getString("ErrorEncountered"), null);
        }
        return connection;
    }

    protected String[] getSchemaNames() {
        return this.getSelectedNodes(ALL_SCHEMAS);
    }

    protected String[] getObjectTypes() {
        return this.getSelectedNodes(ALL_OBJECTS);
    }

    protected String[] getIdentifierTypes() {
        return this.getSelectedNodes(ALL_ID_TYPES);
    }

    protected String[] getIdentifierUsages() {
        return this.getSelectedNodes(ALL_ID_USAGES);
    }

    private String[] getSelectedNodes(String string) {
        TriStateNode triStateNode = null;
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            TreeNode treeNode = this.root.getChildAt(i);
            if (!treeNode.toString().equals(string)) continue;
            triStateNode = (TriStateNode)treeNode;
            break;
        }
        if (triStateNode == null) {
            throw new AssertionError((Object)"N/A");
        }
        if (triStateNode.getNodeState() == TriStateNode.NodeState.NO) {
            return null;
        }
        if (triStateNode.getNodeState() == TriStateNode.NodeState.YES) {
            return new String[0];
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 0; i < triStateNode.getChildCount(); ++i) {
            TriStateNode triStateNode2 = (TriStateNode)triStateNode.getChildAt(i);
            if (triStateNode2.getNodeState() != TriStateNode.NodeState.YES) continue;
            linkedList.add(triStateNode2.toString());
        }
        return linkedList.toArray(new String[0]);
    }

    private DefaultMutableTreeNode find(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        if (defaultMutableTreeNode.toString().equals(string)) {
            return defaultMutableTreeNode;
        }
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            DefaultMutableTreeNode defaultMutableTreeNode3 = this.find(defaultMutableTreeNode2, string);
            if (defaultMutableTreeNode3 == null) continue;
            return defaultMutableTreeNode3;
        }
        return null;
    }

    private boolean isSelected(String string) {
        return ((TriStateNode)this.find(this.root, string)).getNodeState() == TriStateNode.NodeState.YES;
    }

    protected DictionaryQuery newQuery(String string, String string2) {
        return new DictionaryQuery(string, string2){

            @Override
            protected String conditionalUpperCase(String string) {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (i == 0 && c == '\"') {
                        if (string.endsWith("%")) {
                            return string.substring(1, string.length() - 2) + "%";
                        }
                        return string.substring(1, string.length() - 1);
                    }
                    if ('A' <= c && c <= 'Z') {
                        bl2 = true;
                    }
                    if ('a' <= c && c <= 'z') {
                        bl3 = true;
                    }
                    if (!bl2 || !bl3) continue;
                    bl = true;
                    break;
                }
                return bl ? string : string.toUpperCase();
            }
        };
    }
}

