/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid.contextmenu;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.apex.importer.ApexImportArb;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.grid.IResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.models.SQLComboxModel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdbc.OracleCallableStatement;

public class PublishQueryToApexApplication
extends GridContextMenuItem {
    private static final Version MIN_VER = new Version("3.1.1.00.01");
    private static final String SQL = "declare     PRAGMA AUTONOMOUS_TRANSACTION;  l_app_id number;  begin   wwv_flow_api.set_security_group_id(:SGID1);  wwv_flow_api.create_app_from_query (     p_schema                 => user,     p_sql                    => :SQL,     p_page_name           \t => :PAGE_NAME ,     p_workspace_id           => :SGID,     p_theme                  => :THEME_ID,     p_theme_type             => :THEME_TYPE,     p_application_name       => :APP_NAME ,     p_application_id         => l_app_id,     p_authentication         => 'DATABASE ACCOUNT' ,    p_group_name             => 'Published From SQL Developer' ,    p_max_displayed_columns  => 10 );      ? := l_app_id;    commit; end; ";
    private static PublishQueryToApexApplication _instance;
    public static final String PUBLISH_QUERY_TO_APEX = "grid.publishToApex";
    public static final int PUBLISH_QUERY_TO_APEX_ID;
    public static IdeAction PUBLISH_TO_APEX;
    private ResultSetTable _table;
    private Connection conn = null;

    private PublishQueryToApexApplication() {
        this.initActions();
    }

    private void initActions() {
        if (PUBLISH_TO_APEX == null) {
            PUBLISH_TO_APEX = this.createAction(PUBLISH_QUERY_TO_APEX_ID, ApexImportArb.getString("PUBLISH_QUERY"), null);
        }
    }

    public static synchronized PublishQueryToApexApplication getInstance() {
        if (_instance == null) {
            _instance = new PublishQueryToApexApplication();
        }
        return _instance;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == PUBLISH_QUERY_TO_APEX_ID) {
            this.showDialog(context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (this.conn == null) {
            ideAction.setEnabled(false);
            return true;
        }
        ReentrantLock reentrantLock = Connections.getInstance().getLock(this.conn);
        if (reentrantLock != null && reentrantLock.isLocked()) {
            ideAction.setEnabled(false);
        } else {
            ideAction.setEnabled(true);
        }
        return true;
    }

    private void showDialog(Context context) {
        IResultSetTableModel iResultSetTableModel = (IResultSetTableModel)((Object)this._table.getModel());
        final JTextField jTextField = new JTextField();
        final JTextField jTextField2 = new JTextField();
        try {
            this.conn = Connections.getInstance().getConnection(iResultSetTableModel.getConnectionName());
        }
        catch (DBException dBException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
        }
        if (this.conn == null) {
            return;
        }
        ReentrantLock reentrantLock = Connections.getInstance().getLock(this.conn);
        if (reentrantLock != null && reentrantLock.isLocked()) {
            return;
        }
        final String string = iResultSetTableModel.getModifiedSql();
        final SQLComboxModel sQLComboxModel = new SQLComboxModel(this.conn, "select workspace ,workspace_id from apex_workspaces order by 1", null, null);
        final JComboBox jComboBox = new JComboBox(sQLComboxModel);
        final SQLComboxModel sQLComboxModel2 = new SQLComboxModel(this.conn, "select theme_name, theme_number,theme_type from apex_themes order by theme_type desc, theme_number", null, null);
        final JComboBox jComboBox2 = new JComboBox(sQLComboxModel2);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 1, 2, 0), 0, 0);
        jPanel.add((Component)new JLabel(Messages.getString("PublishQueryToApexApplication.24")), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 1, 2, 0), 0, 0);
        jPanel.add(jComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 1, 2, 0), 0, 0);
        jPanel.add((Component)new JLabel(Messages.getString("PublishQueryToApexApplication.25")), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 1, 2, 0), 0, 0);
        jPanel.add((Component)jTextField2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 1, 2, 0), 0, 0);
        jPanel.add((Component)new JLabel(Messages.getString("PublishQueryToApexApplication.26")), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 1, 2, 0), 0, 0);
        jPanel.add(jComboBox2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 1, 2, 0), 0, 0);
        jPanel.add((Component)new JLabel(Messages.getString("PublishQueryToApexApplication.27")), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 1, 2, 0), 0, 0);
        jPanel.add((Component)jTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 1, 2, 0), 0, 0);
        jPanel.add((Component)new JLabel("SQL"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 5, 2, 1, 0.0, 1.0, 18, 1, new Insets(2, 1, 2, 0), 0, 0);
        gridBagConstraints.fill = 1;
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setColumns(80);
        jTextArea.setRows(12);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        jPanel.setSize(jPanel.getPreferredSize());
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl;
                boolean bl2 = bl = !((JEWTDialog)actionEvent.getSource()).isCancelled();
                if (bl) {
                    Object object;
                    Object object2 = jComboBox.getSelectedItem();
                    Object object3 = jComboBox.getSelectedIndex() > -1 ? sQLComboxModel.getValueAtIndex(jComboBox.getSelectedIndex(), 1) : null;
                    Object object4 = jComboBox2.getSelectedIndex() > -1 ? sQLComboxModel2.getValueAtIndex(jComboBox2.getSelectedIndex(), 2) : null;
                    Object object5 = object = jComboBox2.getSelectedIndex() > -1 ? sQLComboxModel2.getValueAtIndex(jComboBox2.getSelectedIndex(), 1) : null;
                    if (object2 == null || object3 == null || object4 == null || object == null) {
                        return;
                    }
                    PublishQueryToApexApplication.this.publish(object2.toString(), object3.toString(), jTextField2.getText(), jTextField.getText(), string, PublishQueryToApexApplication.this.conn, object.toString(), object4.toString());
                    ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
                }
            }
        };
        jPanel.putClientProperty("HELP_TEXT", ApexImportArb.getString("PUBLISH_QUERY_HELP"));
        UIUtils.showPanelAsDialog((JPanel)jPanel, (String)ApexImportArb.getString("PUBLISH_QUERY"), (ActionListener)actionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publish(String string, String string2, String string3, String string4, String string5, Connection connection, String string6, String string7) {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(SQL);
            oracleCallableStatement.setStringAtName("SGID1", string2);
            oracleCallableStatement.setStringAtName("APP_NAME", string3);
            oracleCallableStatement.setStringAtName("PAGE_NAME", string4);
            oracleCallableStatement.setStringAtName("SQL", string5);
            oracleCallableStatement.setStringAtName("SGID", string2);
            oracleCallableStatement.setStringAtName("THEME_ID", string6);
            oracleCallableStatement.setStringAtName("THEME_TYPE", string7);
            oracleCallableStatement.registerOutParameter(8, 4);
            oracleCallableStatement.execute();
            int n = oracleCallableStatement.getInt(8);
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)String.format(ApexImportArb.getString("PUBLISHED_QUERY"), string, string3, n), (String)ApexImportArb.getString("PUBLISH_QUERY"), null);
        }
        catch (SQLException sQLException) {
            ExceptionHandler.handleException((Throwable)sQLException);
        }
        finally {
            try {
                oracleCallableStatement.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    protected boolean canShow(ContextMenu contextMenu) {
        return true;
    }

    protected void createAndShowMenu(ContextMenu contextMenu) {
        if (contextMenu.getContext().getEvent().getSource() instanceof ResultSetTable) {
            this._table = (ResultSetTable)((Object)contextMenu.getContext().getEvent().getSource());
            String string = ((IResultSetTableModel)((Object)this._table.getModel())).getConnectionName();
            try {
                this.conn = Connections.getInstance().getConnection(string, false);
            }
            catch (DBException dBException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
            }
            Version version = (Version)Connections.getInstance().getProperty(this.conn, "APEX_VERSION");
            if (version != null && DBUtil.checkVersion((Version)version, null, (Version)MIN_VER)) {
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)PUBLISH_TO_APEX));
            }
        }
    }

    static {
        PUBLISH_QUERY_TO_APEX_ID = Ide.findOrCreateCmdID((String)PUBLISH_QUERY_TO_APEX);
        PUBLISH_TO_APEX = null;
    }
}

